/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.util;

import biweekly.util.DayOfWeek;
import biweekly.util.com.google.ical.util.DTBuilder;
import biweekly.util.com.google.ical.values.DateTimeValue;
import biweekly.util.com.google.ical.values.DateTimeValueImpl;
import biweekly.util.com.google.ical.values.DateValue;
import biweekly.util.com.google.ical.values.DateValueImpl;
import biweekly.util.com.google.ical.values.TimeValue;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    private static TimeZone ZULU = new SimpleTimeZone(0, "Etc/GMT");
    private static int[] MONTH_START_TO_DOY = new int[12];
    private static final DayOfWeek[] DAYS_OF_WEEK;
    private static final long SECS_PER_DAY = 86400L;
    private static final TimeZone BOGUS_TIMEZONE;
    private static final Pattern UTC_TZID;
    private static final TimeValue MIDNIGHT;

    public static TimeZone utcTimezone() {
        return ZULU;
    }

    private static long timetMillisFromEpochSecs(long epochSecs, TimeZone zone) {
        DateTimeValue date = TimeUtils.timeFromSecsSinceEpoch(epochSecs);
        GregorianCalendar cal = new GregorianCalendar(zone);
        cal.clear();
        cal.set(date.year(), date.month() - 1, date.day(), date.hour(), date.minute(), date.second());
        return cal.getTimeInMillis();
    }

    private static DateTimeValue convert(DateTimeValue time, TimeZone zone, int sense) {
        TimeZone dateTimeValueTz;
        TimeZone epochTz;
        if (zone == null || zone.hasSameRules(ZULU) || time.year() == 0) {
            return time;
        }
        if (sense > 0) {
            epochTz = ZULU;
            dateTimeValueTz = zone;
        } else {
            epochTz = zone;
            dateTimeValueTz = ZULU;
        }
        long epochSeconds = TimeUtils.secsSinceEpoch(time);
        long timetMillis = TimeUtils.timetMillisFromEpochSecs(epochSeconds, epochTz);
        return TimeUtils.toDateTimeValue(timetMillis, dateTimeValueTz);
    }

    public static DateValue fromUtc(DateValue date, TimeZone zone) {
        return date instanceof DateTimeValue ? TimeUtils.fromUtc((DateTimeValue)date, zone) : date;
    }

    public static DateTimeValue fromUtc(DateTimeValue date, TimeZone zone) {
        return TimeUtils.convert(date, zone, 1);
    }

    public static DateValue toUtc(DateValue date, TimeZone zone) {
        return date instanceof TimeValue ? TimeUtils.convert((DateTimeValue)date, zone, -1) : date;
    }

    public static DateValue add(DateValue date, DateValue duration) {
        DTBuilder db = new DTBuilder(date);
        db.year += duration.year();
        db.month += duration.month();
        db.day += duration.day();
        if (duration instanceof TimeValue) {
            TimeValue tdur = (TimeValue)((Object)duration);
            db.hour += tdur.hour();
            db.minute += tdur.minute();
            db.second += tdur.second();
            return db.toDateTime();
        }
        return date instanceof TimeValue ? db.toDateTime() : db.toDate();
    }

    public static int daysBetween(DateValue date1, DateValue date2) {
        return TimeUtils.fixedFromGregorian(date1) - TimeUtils.fixedFromGregorian(date2);
    }

    public static int daysBetween(int year1, int month1, int day1, int year2, int month2, int day2) {
        return TimeUtils.fixedFromGregorian(year1, month1, day1) - TimeUtils.fixedFromGregorian(year2, month2, day2);
    }

    private static int fixedFromGregorian(DateValue date) {
        return TimeUtils.fixedFromGregorian(date.year(), date.month(), date.day());
    }

    public static int fixedFromGregorian(int year, int month, int day) {
        int yearM1 = year - 1;
        return 365 * yearM1 + yearM1 / 4 - yearM1 / 100 + yearM1 / 400 + (367 * month - 362) / 12 + (month <= 2 ? 0 : (TimeUtils.isLeapYear(year) ? -1 : -2)) + day;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int yearLength(int year) {
        return TimeUtils.isLeapYear(year) ? 366 : 365;
    }

    public static int monthLength(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return TimeUtils.isLeapYear(year) ? 29 : 28;
            }
        }
        throw new AssertionError(month);
    }

    public static int dayOfYear(int year, int month, int date) {
        int leapAdjust = month > 2 && TimeUtils.isLeapYear(year) ? 1 : 0;
        return MONTH_START_TO_DOY[month - 1] + leapAdjust + date - 1;
    }

    public static DayOfWeek dayOfWeek(DateValue date) {
        int dayIndex = TimeUtils.fixedFromGregorian(date.year(), date.month(), date.day()) % 7;
        if (dayIndex < 0) {
            dayIndex += 7;
        }
        return DAYS_OF_WEEK[dayIndex];
    }

    public static DayOfWeek firstDayOfWeekInMonth(int year, int month) {
        int result = TimeUtils.fixedFromGregorian(year, month, 1) % 7;
        if (result < 0) {
            result += 7;
        }
        return DAYS_OF_WEEK[result];
    }

    public static DateTimeValue timeFromSecsSinceEpoch(long secsSinceEpoch) {
        int secsInDay = (int)(secsSinceEpoch % 86400L);
        int daysSinceEpoch = (int)(secsSinceEpoch / 86400L);
        int approx = (int)((long)(daysSinceEpoch + 10) * 400L / 146097L);
        int year = daysSinceEpoch >= TimeUtils.fixedFromGregorian(approx + 1, 1, 1) ? approx + 1 : approx;
        int jan1 = TimeUtils.fixedFromGregorian(year, 1, 1);
        int priorDays = daysSinceEpoch - jan1;
        int march1 = TimeUtils.fixedFromGregorian(year, 3, 1);
        int correction = daysSinceEpoch < march1 ? 0 : (TimeUtils.isLeapYear(year) ? 1 : 2);
        int month = (12 * (priorDays + correction) + 373) / 367;
        int month1 = TimeUtils.fixedFromGregorian(year, month, 1);
        int day = daysSinceEpoch - month1 + 1;
        int second = secsInDay % 60;
        int minutesInDay = secsInDay / 60;
        int minute = minutesInDay % 60;
        int hour = minutesInDay / 60;
        if (hour < 0 || hour >= 24) {
            throw new AssertionError((Object)("Input was: " + secsSinceEpoch + "to make hour: " + hour));
        }
        return new DateTimeValueImpl(year, month, day, hour, minute, second);
    }

    public static long secsSinceEpoch(DateValue date) {
        long result = (long)TimeUtils.fixedFromGregorian(date) * 86400L;
        if (date instanceof TimeValue) {
            TimeValue time = (TimeValue)((Object)date);
            result += (long)(time.second() + 60 * (time.minute() + 60 * time.hour()));
        }
        return result;
    }

    public static DateTimeValue dayStart(DateValue date) {
        return new DateTimeValueImpl(date.year(), date.month(), date.day(), 0, 0, 0);
    }

    public static DateValue toDateValue(DateValue date) {
        return date instanceof TimeValue ? new DateValueImpl(date.year(), date.month(), date.day()) : date;
    }

    public static TimeZone timeZoneForName(String tzString) {
        TimeZone tz = TimeZone.getTimeZone(tzString);
        if (!tz.hasSameRules(BOGUS_TIMEZONE)) {
            return tz;
        }
        Matcher m = UTC_TZID.matcher(tzString);
        return m.matches() ? TimeUtils.utcTimezone() : null;
    }

    public static DateTimeValue toDateTimeValue(long millisFromEpoch, TimeZone zone) {
        GregorianCalendar c = new GregorianCalendar(zone);
        c.clear();
        c.setTimeInMillis(millisFromEpoch);
        return new DateTimeValueImpl(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13));
    }

    public static TimeValue timeOf(DateValue date) {
        return date instanceof TimeValue ? (TimeValue)((Object)date) : MIDNIGHT;
    }

    private TimeUtils() {
    }

    static {
        for (int m = 1; m < 12; ++m) {
            TimeUtils.MONTH_START_TO_DOY[m] = MONTH_START_TO_DOY[m - 1] + TimeUtils.monthLength(1970, m);
        }
        DAYS_OF_WEEK = DayOfWeek.values();
        BOGUS_TIMEZONE = TimeZone.getTimeZone("noSuchTimeZone");
        UTC_TZID = Pattern.compile("^GMT([+-]0(:00)?)?$|UTC|Zulu|Etc\\/GMT|Greenwich.*", 2);
        MIDNIGHT = new TimeValue(){

            public int hour() {
                return 0;
            }

            public int minute() {
                return 0;
            }

            public int second() {
                return 0;
            }
        };
    }
}

