/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.util.DateTimeComponents;
import java.util.Calendar;
import java.util.Date;

public class ICalDate
extends Date {
    private static final long serialVersionUID = -8172624513821588097L;
    private final DateTimeComponents rawComponents;
    private final boolean hasTime;

    public ICalDate() {
        this(true);
    }

    public ICalDate(boolean hasTime) {
        this(new Date(), null, hasTime);
    }

    public ICalDate(Date date) {
        this(date, true);
    }

    public ICalDate(Date date, boolean hasTime) {
        this(date, null, hasTime);
    }

    public ICalDate(DateTimeComponents date, boolean hasTime) {
        this(date.toDate(), date, hasTime);
    }

    public ICalDate(ICalDate date) {
        this(date, date.rawComponents == null ? null : new DateTimeComponents(date.rawComponents), date.hasTime);
    }

    public ICalDate(Date date, DateTimeComponents rawComponents, boolean hasTime) {
        if (!hasTime) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            date = c.getTime();
        }
        this.setTime(date.getTime());
        this.rawComponents = rawComponents;
        this.hasTime = hasTime;
    }

    public DateTimeComponents getRawComponents() {
        return this.rawComponents;
    }

    public boolean hasTime() {
        return this.hasTime;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ICalDate) {
            ICalDate other = (ICalDate)obj;
            if (this.hasTime != other.hasTime) {
                return false;
            }
        }
        return super.equals(obj);
    }
}

