/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.component.ICalComponent;
import biweekly.property.DateStart;
import biweekly.property.ExceptionDates;
import biweekly.property.ExceptionRule;
import biweekly.property.RecurrenceDates;
import biweekly.property.RecurrenceRule;
import biweekly.property.ValuedProperty;
import biweekly.util.DateTimeComponents;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import biweekly.util.com.google.ical.compat.javautil.DateIterator;
import biweekly.util.com.google.ical.compat.javautil.DateIteratorFactory;
import biweekly.util.com.google.ical.iter.RecurrenceIterable;
import biweekly.util.com.google.ical.iter.RecurrenceIterator;
import biweekly.util.com.google.ical.iter.RecurrenceIteratorFactory;
import biweekly.util.com.google.ical.values.DateTimeValue;
import biweekly.util.com.google.ical.values.DateTimeValueImpl;
import biweekly.util.com.google.ical.values.DateValue;
import biweekly.util.com.google.ical.values.DateValueImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Google2445Utils {
    public static DateValue convertFromRawComponents(ICalDate date) {
        DateTimeComponents raw = date.getRawComponents();
        if (raw == null) {
            raw = new DateTimeComponents(date);
        }
        return Google2445Utils.convert(raw);
    }

    public static DateValue convert(DateTimeComponents components) {
        if (components.hasTime()) {
            return new DateTimeValueImpl(components.getYear(), components.getMonth(), components.getDate(), components.getHour(), components.getMinute(), components.getSecond());
        }
        return new DateValueImpl(components.getYear(), components.getMonth(), components.getDate());
    }

    public static DateValue convert(ICalDate date, TimeZone timezone) {
        Calendar c = Calendar.getInstance(timezone);
        c.setTime(date);
        return new DateTimeValueImpl(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13));
    }

    public static DateValue convertUtc(ICalDate date) {
        return Google2445Utils.convert(date, Google2445Utils.utc());
    }

    public static ICalDate convert(DateValue date, TimeZone timezone) {
        Calendar c = Calendar.getInstance(timezone);
        c.clear();
        c.set(1, date.year());
        c.set(2, date.month() - 1);
        c.set(5, date.day());
        boolean hasTime = date instanceof DateTimeValue;
        if (hasTime) {
            DateTimeValue dateTime = (DateTimeValue)date;
            c.set(11, dateTime.hour());
            c.set(12, dateTime.minute());
            c.set(13, dateTime.second());
        }
        return new ICalDate(c.getTime(), hasTime);
    }

    public static ICalDate convertUtc(DateValue date) {
        return Google2445Utils.convert(date, Google2445Utils.utc());
    }

    public static RecurrenceIterator createRecurrenceIterator(Recurrence recurrence, ICalDate start, TimeZone timezone) {
        DateValue startValue = Google2445Utils.convert(start, timezone);
        return RecurrenceIteratorFactory.createRecurrenceIterator(recurrence, startValue, timezone);
    }

    public static RecurrenceIterable createRecurrenceIterable(Recurrence recurrence, ICalDate start, TimeZone timezone) {
        DateValue startValue = Google2445Utils.convert(start, timezone);
        return RecurrenceIteratorFactory.createRecurrenceIterable(recurrence, startValue, timezone);
    }

    public static DateIterator getDateIterator(ICalComponent component, TimeZone timezone) {
        DateStart dtstart = component.getProperty(DateStart.class);
        ICalDate start = ValuedProperty.getValue(dtstart);
        if (start != null && !start.hasTime()) {
            timezone = TimeZone.getDefault();
        }
        ArrayList<RecurrenceIterator> include = new ArrayList<RecurrenceIterator>();
        if (start != null) {
            for (RecurrenceRule recurrenceRule : component.getProperties(RecurrenceRule.class)) {
                Recurrence recurrence = ValuedProperty.getValue(recurrenceRule);
                if (recurrence == null) continue;
                include.add(Google2445Utils.createRecurrenceIterator(recurrence, start, timezone));
            }
        }
        ArrayList<ICalDate> allDates = new ArrayList<ICalDate>();
        for (RecurrenceDates recurrenceDates : component.getProperties(RecurrenceDates.class)) {
            allDates.addAll(recurrenceDates.getDates());
        }
        if (!allDates.isEmpty()) {
            include.add(new ICalDateRecurrenceIterator(allDates));
        }
        if (include.isEmpty()) {
            if (start == null) {
                return new EmptyDateIterator();
            }
            include.add(new ICalDateRecurrenceIterator(Arrays.asList(start)));
        }
        ArrayList<RecurrenceIterator> arrayList = new ArrayList<RecurrenceIterator>();
        if (start != null) {
            for (ExceptionRule exrule : component.getProperties(ExceptionRule.class)) {
                Recurrence recurrence = ValuedProperty.getValue(exrule);
                if (recurrence == null) continue;
                arrayList.add(Google2445Utils.createRecurrenceIterator(recurrence, start, timezone));
            }
        }
        allDates = new ArrayList();
        for (ExceptionDates exdate : component.getProperties(ExceptionDates.class)) {
            allDates.addAll(exdate.getValues());
        }
        if (!allDates.isEmpty()) {
            arrayList.add(new ICalDateRecurrenceIterator(allDates));
        }
        RecurrenceIterator recurrenceIterator = Google2445Utils.join(include);
        if (arrayList.isEmpty()) {
            return DateIteratorFactory.createDateIterator(recurrenceIterator);
        }
        RecurrenceIterator excludeJoined = Google2445Utils.join(arrayList);
        RecurrenceIterator iterator = RecurrenceIteratorFactory.except(recurrenceIterator, excludeJoined);
        return DateIteratorFactory.createDateIterator(iterator);
    }

    private static RecurrenceIterator join(List<RecurrenceIterator> iterators) {
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        RecurrenceIterator first = iterators.get(0);
        List<RecurrenceIterator> rest = iterators.subList(1, iterators.size());
        return RecurrenceIteratorFactory.join(first, rest.toArray(new RecurrenceIterator[0]));
    }

    private static TimeZone utc() {
        return TimeZone.getTimeZone("UTC");
    }

    private Google2445Utils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ICalDateRecurrenceIterator
    implements RecurrenceIterator {
        private final List<ICalDate> dates;
        private int index = 0;

        public ICalDateRecurrenceIterator(List<ICalDate> dates) {
            this.dates = new ArrayList<ICalDate>(dates);
            Collections.sort(this.dates);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.dates.size();
        }

        @Override
        public DateValue next() {
            ICalDate next = this.dates.get(this.index++);
            return Google2445Utils.convertUtc(next);
        }

        @Override
        public void advanceTo(DateValue newStartUtc) {
            ICalDate newStart = Google2445Utils.convertUtc(newStartUtc);
            while (this.index < this.dates.size() && newStart.compareTo(this.dates.get(this.index)) > 0) {
                ++this.index;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class EmptyDateIterator
    implements DateIterator {
        public boolean hasNext() {
            return false;
        }

        public Date next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void advanceTo(Date newStartUtc) {
        }
    }
}

