/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.parameter.Related;
import biweekly.property.ICalProperty;
import biweekly.util.Duration;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trigger
extends ICalProperty {
    private Duration duration;
    private Date date;

    public Trigger(Duration duration, Related related) {
        this.setDuration(duration, related);
    }

    public Trigger(Date date) {
        this.setDate(date);
    }

    public Trigger(Trigger original) {
        super(original);
        this.date = original.date == null ? null : new Date(original.date.getTime());
        this.duration = original.duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration, Related related) {
        this.date = null;
        this.duration = duration;
        this.setRelated(related);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
        this.duration = null;
        this.setRelated(null);
    }

    public Related getRelated() {
        return this.parameters.getRelated();
    }

    public void setRelated(Related related) {
        this.parameters.setRelated(related);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        if (this.duration == null && this.date == null) {
            warnings.add(new ValidationWarning(33, new Object[0]));
        }
        Related related = this.getRelated();
        if (this.duration != null && related == null) {
            warnings.add(new ValidationWarning(10, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("duration", this.duration);
        values.put("date", this.date);
        return values;
    }

    @Override
    public Trigger copy() {
        return new Trigger(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Trigger other = (Trigger)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        return !(this.duration == null ? other.duration != null : !this.duration.equals(other.duration));
    }
}

