/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.property.EnumProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Action
extends EnumProperty {
    public static final String AUDIO = "AUDIO";
    public static final String DISPLAY = "DISPLAY";
    public static final String EMAIL = "EMAIL";
    public static final String PROCEDURE = "PROCEDURE";

    public Action(String value) {
        super(value);
    }

    public Action(Action original) {
        super(original);
    }

    public static Action audio() {
        return Action.create(AUDIO);
    }

    public boolean isAudio() {
        return this.is(AUDIO);
    }

    public static Action display() {
        return Action.create(DISPLAY);
    }

    public boolean isDisplay() {
        return this.is(DISPLAY);
    }

    public static Action email() {
        return Action.create(EMAIL);
    }

    public boolean isEmail() {
        return this.is(EMAIL);
    }

    public static Action procedure() {
        return Action.create(PROCEDURE);
    }

    public boolean isProcedure() {
        return this.is(PROCEDURE);
    }

    private static Action create(String value) {
        return new Action(value);
    }

    @Override
    protected Collection<String> getStandardValues(ICalVersion version) {
        switch (version) {
            case V1_0: {
                return Arrays.asList(AUDIO, DISPLAY, EMAIL, PROCEDURE);
            }
        }
        return Arrays.asList(AUDIO, DISPLAY, EMAIL);
    }

    @Override
    protected Collection<ICalVersion> getValueSupportedVersions() {
        if (this.value == null) {
            return Collections.emptyList();
        }
        if (this.isAudio() || this.isDisplay() || this.isEmail()) {
            return Arrays.asList(ICalVersion.values());
        }
        if (this.isProcedure()) {
            return Arrays.asList(ICalVersion.V1_0);
        }
        return Collections.emptyList();
    }

    @Override
    public Action copy() {
        return new Action(this);
    }
}

