/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.xml;

import biweekly.ICalDataType;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.io.SkipMeException;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalOutputProperties;
import biweekly.io.xml.XCalQNames;
import biweekly.io.xml.XCalWriterBase;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.Version;
import biweekly.property.Xml;
import biweekly.util.Utf8Writer;
import biweekly.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCalWriter
extends XCalWriterBase {
    private final Document DOC = XmlUtils.createDocument();
    private final Writer writer;
    private final TransformerHandler handler;
    private final boolean icalendarElementExists;
    private boolean started = false;

    public XCalWriter(OutputStream out) {
        this(out, (Integer)null);
    }

    public XCalWriter(OutputStream out, Integer indent) {
        this(out, indent, null);
    }

    public XCalWriter(OutputStream out, Integer indent, String xmlVersion) {
        this((Writer)new Utf8Writer(out), indent, xmlVersion);
    }

    public XCalWriter(OutputStream out, Map<String, String> outputProperties) {
        this((Writer)new Utf8Writer(out), outputProperties);
    }

    public XCalWriter(File file) throws IOException {
        this(file, (Integer)null);
    }

    public XCalWriter(File file, Integer indent) throws IOException {
        this(file, indent, null);
    }

    public XCalWriter(File file, Integer indent, String xmlVersion) throws IOException {
        this((Writer)new Utf8Writer(file), indent, xmlVersion);
    }

    public XCalWriter(File file, Map<String, String> outputProperties) throws IOException {
        this((Writer)new Utf8Writer(file), outputProperties);
    }

    public XCalWriter(Writer writer) {
        this(writer, (Integer)null);
    }

    public XCalWriter(Writer writer, Integer indent) {
        this(writer, indent, null);
    }

    public XCalWriter(Writer writer, Integer indent, String xmlVersion) {
        this(writer, (Map<String, String>)new XCalOutputProperties(indent, xmlVersion));
    }

    public XCalWriter(Writer writer, Map<String, String> outputProperties) {
        this(writer, null, outputProperties);
    }

    public XCalWriter(Node parent) {
        this(null, parent, new HashMap<String, String>());
    }

    private XCalWriter(Writer writer, Node parent, Map<String, String> outputProperties) {
        Node root;
        this.writer = writer;
        if (parent instanceof Document && (root = parent.getFirstChild()) != null) {
            parent = root;
        }
        this.icalendarElementExists = this.isICalendarElement(parent);
        try {
            SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            this.handler = factory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        Transformer transformer = this.handler.getTransformer();
        for (Map.Entry<String, String> entry : outputProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            transformer.setOutputProperty(key, value);
        }
        Result result = writer == null ? new DOMResult(parent) : new StreamResult(writer);
        this.handler.setResult(result);
    }

    private boolean isICalendarElement(Node node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof Element)) {
            return false;
        }
        return XmlUtils.hasQName(node, XCalQNames.ICALENDAR);
    }

    @Override
    protected void _write(ICalendar ical) throws IOException {
        try {
            if (!this.started) {
                this.handler.startDocument();
                if (!this.icalendarElementExists) {
                    this.start(XCalQNames.ICALENDAR);
                }
                this.started = true;
            }
            this.write((ICalComponent)ical);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private void write(ICalComponent component) throws SAXException {
        ICalComponentScribe<? extends ICalComponent> scribe = this.index.getComponentScribe(component);
        String name = scribe.getComponentName().toLowerCase();
        this.start(name);
        List<ICalProperty> properties = scribe.getProperties(component);
        if (component instanceof ICalendar && component.getProperty(Version.class) == null) {
            properties.add(0, new Version(this.targetVersion));
        }
        if (!properties.isEmpty()) {
            this.start(XCalQNames.PROPERTIES);
            for (ICalProperty propertyObj : properties) {
                this.context.setParent(component);
                ICalProperty property = propertyObj;
                this.write(property);
            }
            this.end(XCalQNames.PROPERTIES);
        }
        List<ICalComponent> subComponents = scribe.getComponents(component);
        if (component instanceof ICalendar) {
            Collection<VTimezone> tzs = this.getTimezoneComponents();
            for (VTimezone tz : tzs) {
                if (subComponents.contains(tz)) continue;
                subComponents.add(0, tz);
            }
        }
        if (!subComponents.isEmpty()) {
            this.start(XCalQNames.COMPONENTS);
            Iterator<ICalComponent> iterator = subComponents.iterator();
            while (iterator.hasNext()) {
                ICalComponent subComponentObj;
                ICalComponent subComponent = subComponentObj = iterator.next();
                this.write(subComponent);
            }
            this.end(XCalQNames.COMPONENTS);
        }
        this.end(name);
    }

    private void write(ICalProperty property) throws SAXException {
        Element propertyElement;
        ICalPropertyScribe<? extends ICalProperty> scribe = this.index.getPropertyScribe(property);
        ICalParameters parameters = scribe.prepareParameters(property, this.context);
        if (property instanceof Xml) {
            Xml xml = (Xml)property;
            Document value = (Document)xml.getValue();
            if (value == null) {
                return;
            }
            propertyElement = value.getDocumentElement();
        } else {
            QName qname = scribe.getQName();
            propertyElement = this.DOC.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
            try {
                scribe.writeXml(property, propertyElement, this.context);
            }
            catch (SkipMeException e) {
                return;
            }
        }
        this.start(propertyElement);
        this.write(parameters);
        this.write(propertyElement);
        this.end(propertyElement);
    }

    private void write(Element propertyElement) throws SAXException {
        NodeList children = propertyElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Element element = (Element)child;
                if (element.hasChildNodes()) {
                    this.start(element);
                    this.write(element);
                    this.end(element);
                    continue;
                }
                this.childless(element);
                continue;
            }
            if (!(child instanceof Text)) continue;
            Text text = (Text)child;
            this.text(text.getTextContent());
        }
    }

    private void write(ICalParameters parameters) throws SAXException {
        if (parameters.isEmpty()) {
            return;
        }
        this.start(XCalQNames.PARAMETERS);
        for (Map.Entry parameter : parameters) {
            String parameterName = ((String)parameter.getKey()).toLowerCase();
            this.start(parameterName);
            for (String parameterValue : parameter.getValue()) {
                ICalDataType dataType = (ICalDataType)this.parameterDataTypes.get(parameterName);
                String dataTypeElementName = dataType == null ? "unknown" : dataType.getName().toLowerCase();
                this.start(dataTypeElementName);
                this.text(parameterValue);
                this.end(dataTypeElementName);
            }
            this.end(parameterName);
        }
        this.end(XCalQNames.PARAMETERS);
    }

    private void childless(Element element) throws SAXException {
        Attributes attributes = XCalWriter.getElementAttributes(element);
        this.handler.startElement(element.getNamespaceURI(), "", element.getLocalName(), attributes);
        this.handler.endElement(element.getNamespaceURI(), "", element.getLocalName());
    }

    private void start(Element element) throws SAXException {
        Attributes attributes = XCalWriter.getElementAttributes(element);
        this.start(element.getNamespaceURI(), element.getLocalName(), attributes);
    }

    private void start(String element) throws SAXException {
        this.start(element, (Attributes)new AttributesImpl());
    }

    private void start(QName qname) throws SAXException {
        this.start(qname, (Attributes)new AttributesImpl());
    }

    private void start(QName qname, Attributes attributes) throws SAXException {
        this.start(qname.getNamespaceURI(), qname.getLocalPart(), attributes);
    }

    private void start(String element, Attributes attributes) throws SAXException {
        this.start("urn:ietf:params:xml:ns:icalendar-2.0", element, attributes);
    }

    private void start(String namespace, String element, Attributes attributes) throws SAXException {
        this.handler.startElement(namespace, "", element, attributes);
    }

    private void end(Element element) throws SAXException {
        this.end(element.getNamespaceURI(), element.getLocalName());
    }

    private void end(String element) throws SAXException {
        this.end("urn:ietf:params:xml:ns:icalendar-2.0", element);
    }

    private void end(QName qname) throws SAXException {
        this.end(qname.getNamespaceURI(), qname.getLocalPart());
    }

    private void end(String namespace, String element) throws SAXException {
        this.handler.endElement(namespace, "", element);
    }

    private void text(String text) throws SAXException {
        this.handler.characters(text.toCharArray(), 0, text.length());
    }

    private static Attributes getElementAttributes(Element element) {
        AttributesImpl attributes = new AttributesImpl();
        NamedNodeMap attributeNodes = element.getAttributes();
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node node = attributeNodes.item(i);
            String localName = node.getLocalName();
            if ("xmlns".equals(localName)) continue;
            attributes.addAttribute(node.getNamespaceURI(), "", node.getLocalName(), "", node.getNodeValue());
        }
        return attributes;
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.started) {
                this.handler.startDocument();
                if (!this.icalendarElementExists) {
                    this.start(XCalQNames.ICALENDAR);
                }
            }
            if (!this.icalendarElementExists) {
                this.end(XCalQNames.ICALENDAR);
            }
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

