/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.io.CannotParseException;
import biweekly.io.DataModelConversionException;
import biweekly.io.ParseWarning;
import biweekly.io.SkipMeException;
import biweekly.io.StreamReader;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.scribe.property.RawPropertyScribe;
import biweekly.parameter.Encoding;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.util.Utf8Reader;
import com.github.mangstadt.vinnie.VObjectProperty;
import com.github.mangstadt.vinnie.io.Context;
import com.github.mangstadt.vinnie.io.SyntaxRules;
import com.github.mangstadt.vinnie.io.VObjectDataListener;
import com.github.mangstadt.vinnie.io.VObjectReader;
import com.github.mangstadt.vinnie.io.Warning;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class ICalReader
extends StreamReader {
    private static final String VCALENDAR_COMPONENT_NAME = ScribeIndex.getICalendarScribe().getComponentName();
    private final VObjectReader reader;
    private final ICalVersion defaultVersion;

    public ICalReader(String str) {
        this(str, ICalVersion.V2_0);
    }

    public ICalReader(String str, ICalVersion defaultVersion) {
        this(new StringReader(str), defaultVersion);
    }

    public ICalReader(InputStream in) {
        this(in, ICalVersion.V2_0);
    }

    public ICalReader(InputStream in, ICalVersion defaultVersion) {
        this(new Utf8Reader(in), defaultVersion);
    }

    public ICalReader(File file) throws FileNotFoundException {
        this(file, ICalVersion.V2_0);
    }

    public ICalReader(File file, ICalVersion defaultVersion) throws FileNotFoundException {
        this(new BufferedReader(new Utf8Reader(file)), defaultVersion);
    }

    public ICalReader(Reader reader) {
        this(reader, ICalVersion.V2_0);
    }

    public ICalReader(Reader reader, ICalVersion defaultVersion) {
        SyntaxRules rules = SyntaxRules.iCalendar();
        rules.setDefaultSyntaxStyle(defaultVersion.getSyntaxStyle());
        this.reader = new VObjectReader(reader, rules);
        this.defaultVersion = defaultVersion;
    }

    public boolean isCaretDecodingEnabled() {
        return this.reader.isCaretDecodingEnabled();
    }

    public void setCaretDecodingEnabled(boolean enable) {
        this.reader.setCaretDecodingEnabled(enable);
    }

    public Charset getDefaultQuotedPrintableCharset() {
        return this.reader.getDefaultQuotedPrintableCharset();
    }

    public void setDefaultQuotedPrintableCharset(Charset charset) {
        this.reader.setDefaultQuotedPrintableCharset(charset);
    }

    public ICalVersion getDefaultVersion() {
        return this.defaultVersion;
    }

    protected ICalendar _readNext() throws IOException {
        VObjectDataListenerImpl listener = new VObjectDataListenerImpl();
        this.reader.parse((VObjectDataListener)listener);
        return listener.ical;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    static /* synthetic */ ICalVersion access$200(ICalReader x0) {
        return x0.defaultVersion;
    }

    private static class ComponentStack {
        private final List<ICalComponent> components = new ArrayList<ICalComponent>();

        private ComponentStack() {
        }

        public ICalComponent peek() {
            return this.isEmpty() ? null : this.components.get(this.components.size() - 1);
        }

        public void push(ICalComponent component) {
            this.components.add(component);
        }

        public ICalComponent pop() {
            return this.isEmpty() ? null : this.components.remove(this.components.size() - 1);
        }

        public boolean isEmpty() {
            return this.components.isEmpty();
        }

        public int size() {
            return this.components.size();
        }
    }

    private class VObjectDataListenerImpl
    implements VObjectDataListener {
        private ICalendar ical = null;
        private ICalVersion version = ICalReader.access$200(ICalReader.this);
        private ComponentStack stack = new ComponentStack();

        private VObjectDataListenerImpl() {
        }

        public void onComponentBegin(String name, Context vobjectContext) {
            if (this.ical == null && !this.isVCalendarComponent(name)) {
                return;
            }
            ICalComponent parentComponent = this.stack.peek();
            ICalComponentScribe<? extends ICalComponent> scribe = ICalReader.this.index.getComponentScribe(name, this.version);
            ICalComponent component = scribe.emptyInstance();
            this.stack.push(component);
            if (parentComponent == null) {
                this.ical = (ICalendar)component;
                ICalReader.this.context.setVersion(this.version);
            } else {
                parentComponent.addComponent(component);
            }
        }

        public void onComponentEnd(String name, Context vobjectContext) {
            if (this.ical == null) {
                return;
            }
            this.stack.pop();
            if (this.stack.isEmpty()) {
                vobjectContext.stop();
            }
        }

        public void onProperty(VObjectProperty vobjectProperty, Context vobjectContext) {
            if (this.ical == null) {
                return;
            }
            String propertyName = vobjectProperty.getName();
            ICalParameters parameters = new ICalParameters(vobjectProperty.getParameters().getMap());
            String value = vobjectProperty.getValue();
            ICalReader.this.context.getWarnings().clear();
            ICalReader.this.context.setLineNumber(vobjectContext.getLineNumber());
            ICalReader.this.context.setPropertyName(propertyName);
            ICalPropertyScribe<? extends ICalProperty> scribe = ICalReader.this.index.getPropertyScribe(propertyName, this.version);
            this.processNamelessParameters(parameters, this.version);
            ICalDataType dataType = parameters.getValue();
            parameters.setValue(null);
            if (dataType == null) {
                dataType = scribe.defaultDataType(this.version);
            }
            ICalComponent parentComponent = this.stack.peek();
            try {
                ICalProperty property = scribe.parseText(value, dataType, parameters, ICalReader.this.context);
                parentComponent.addProperty(property);
            }
            catch (SkipMeException e) {
                ICalReader.this.warnings.add(new ParseWarning.Builder(ICalReader.this.context).message(0, e.getMessage()).build());
            }
            catch (CannotParseException e) {
                ICalReader.this.warnings.add(new ParseWarning.Builder(ICalReader.this.context).message(e).build());
                Object property = new RawPropertyScribe(propertyName).parseText(value, dataType, parameters, ICalReader.this.context);
                parentComponent.addProperty((ICalProperty)property);
            }
            catch (DataModelConversionException e) {
                for (ICalProperty property : e.getProperties()) {
                    parentComponent.addProperty(property);
                }
                for (ICalComponent component : e.getComponents()) {
                    parentComponent.addComponent(component);
                }
            }
            ICalReader.this.warnings.addAll(ICalReader.this.context.getWarnings());
        }

        public void onVersion(String value, Context vobjectContext) {
            if (this.stack.size() != 1) {
                return;
            }
            this.version = ICalVersion.get(value);
            ICalReader.this.context.setVersion(this.version);
        }

        public void onWarning(Warning warning, VObjectProperty property, Exception thrown, Context vobjectContext) {
            if (this.ical == null) {
                return;
            }
            ICalReader.this.warnings.add(new ParseWarning.Builder().lineNumber(vobjectContext.getLineNumber()).propertyName(property == null ? null : property.getName()).message(warning.getMessage()).build());
        }

        private boolean isVCalendarComponent(String componentName) {
            return VCALENDAR_COMPONENT_NAME.equals(componentName);
        }

        private void processNamelessParameters(ICalParameters parameters, ICalVersion version) {
            List namelessParamValues = parameters.removeAll(null);
            if (namelessParamValues.isEmpty()) {
                return;
            }
            if (version != ICalVersion.V1_0) {
                ICalReader.this.warnings.add(new ParseWarning.Builder(ICalReader.this.context).message(4, namelessParamValues).build());
            }
            for (String paramValue : namelessParamValues) {
                String paramName = this.guessParameterName(paramValue);
                parameters.put(paramName, paramValue);
            }
        }

        private String guessParameterName(String value) {
            if (ICalDataType.find(value) != null) {
                return "VALUE";
            }
            if (Encoding.find(value) != null) {
                return "ENCODING";
            }
            return "TYPE";
        }
    }
}

