/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.Version;
import biweekly.util.VersionNumber;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionScribe
extends ICalPropertyScribe<Version> {
    public VersionScribe() {
        super(Version.class, "VERSION", ICalDataType.TEXT);
    }

    @Override
    protected String _writeText(Version property, WriteContext context) {
        StringBuilder sb = new StringBuilder();
        if (property.getMinVersion() != null) {
            sb.append(property.getMinVersion()).append(';');
        }
        if (property.getMaxVersion() != null) {
            sb.append(property.getMaxVersion());
        }
        return sb.toString();
    }

    @Override
    protected Version _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String max;
        VObjectPropertyValues.SemiStructuredValueIterator it = new VObjectPropertyValues.SemiStructuredValueIterator(value);
        String one = it.next();
        String two = it.next();
        String min = null;
        if (two == null) {
            max = one;
        } else {
            min = one;
            max = two;
        }
        return this.parse(min, max);
    }

    @Override
    protected void _writeXml(Version property, XCalElement element, WriteContext context) {
        VersionNumber max = property.getMaxVersion();
        String value = max == null ? null : max.toString();
        element.append(this.dataType(property, null), value);
    }

    @Override
    protected Version _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDataType dataType = this.defaultDataType(context.getVersion());
        String value = element.first(dataType);
        if (value != null) {
            return this.parse(null, value);
        }
        throw VersionScribe.missingXmlElements(dataType);
    }

    @Override
    protected JCalValue _writeJson(Version property, WriteContext context) {
        VersionNumber max = property.getMaxVersion();
        String value = max == null ? null : max.toString();
        return JCalValue.single(value);
    }

    @Override
    protected Version _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.parse(null, value.asSingle());
    }

    private Version parse(String min, String max) {
        try {
            return new Version(min, max);
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(30, new Object[0]);
        }
    }
}

