/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.json.JsonValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.RawProperty;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawPropertyScribe
extends ICalPropertyScribe<RawProperty> {
    public RawPropertyScribe(String propertyName) {
        super(RawProperty.class, propertyName, null);
    }

    @Override
    protected ICalDataType _dataType(RawProperty property, ICalVersion version) {
        return property.getDataType();
    }

    @Override
    protected String _writeText(RawProperty property, WriteContext context) {
        String value = property.getValue();
        return value == null ? "" : value;
    }

    @Override
    protected RawProperty _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return new RawProperty(this.propertyName, dataType, value);
    }

    @Override
    protected RawProperty _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        XCalElement.XCalValue firstValue = element.firstValue();
        ICalDataType dataType = firstValue.getDataType();
        String value = firstValue.getValue();
        return new RawProperty(this.propertyName, dataType, value);
    }

    @Override
    protected RawProperty _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String valueStr = RawPropertyScribe.jcardValueToString(value);
        return new RawProperty(this.propertyName, dataType, valueStr);
    }

    private static String jcardValueToString(JCalValue value) {
        List<List<String>> structured;
        List<String> multi;
        List<JsonValue> values = value.getValues();
        if (values.size() > 1 && !(multi = value.asMulti()).isEmpty()) {
            return VObjectPropertyValues.writeList(multi);
        }
        if (!values.isEmpty() && values.get(0).getArray() != null && !(structured = value.asStructured()).isEmpty()) {
            return VObjectPropertyValues.writeStructured(structured, (boolean)true);
        }
        return value.asSingle();
    }
}

