/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.Geo;
import biweekly.util.ICalFloatFormatter;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoScribe
extends ICalPropertyScribe<Geo> {
    public GeoScribe() {
        super(Geo.class, "GEO");
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        return ICalDataType.FLOAT;
    }

    @Override
    protected String _writeText(Geo property, WriteContext context) {
        ICalFloatFormatter formatter = new ICalFloatFormatter();
        Double latitude = property.getLatitude();
        if (latitude == null) {
            latitude = 0.0;
        }
        String latitudeStr = formatter.format(latitude);
        Double longitude = property.getLongitude();
        if (longitude == null) {
            longitude = 0.0;
        }
        String longitudeStr = formatter.format(longitude);
        char delimiter = this.getDelimiter(context.getVersion());
        return latitudeStr + delimiter + longitudeStr;
    }

    @Override
    protected Geo _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        char delimiter = this.getDelimiter(context.getVersion());
        int pos = value.indexOf(delimiter);
        if (pos < 0) {
            throw new CannotParseException(20, new Object[0]);
        }
        String latitudeStr = value.substring(0, pos);
        String longitudeStr = value.substring(pos + 1);
        return this.parse(latitudeStr, longitudeStr);
    }

    @Override
    protected void _writeXml(Geo property, XCalElement element, WriteContext context) {
        ICalFloatFormatter formatter = new ICalFloatFormatter();
        Double latitude = property.getLatitude();
        if (latitude == null) {
            latitude = 0.0;
        }
        element.append("latitude", formatter.format(latitude));
        Double longitude = property.getLongitude();
        if (longitude == null) {
            longitude = 0.0;
        }
        element.append("longitude", formatter.format(longitude));
    }

    @Override
    protected Geo _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        String latitudeStr = element.first("latitude");
        String longitudeStr = element.first("longitude");
        if (latitudeStr == null && longitudeStr == null) {
            throw GeoScribe.missingXmlElements("latitude", "longitude");
        }
        if (latitudeStr == null) {
            throw GeoScribe.missingXmlElements("latitude");
        }
        if (longitudeStr == null) {
            throw GeoScribe.missingXmlElements("longitude");
        }
        return this.parse(latitudeStr, longitudeStr);
    }

    @Override
    protected JCalValue _writeJson(Geo property, WriteContext context) {
        Double longitude;
        Double latitude = property.getLatitude();
        if (latitude == null) {
            latitude = 0.0;
        }
        if ((longitude = property.getLongitude()) == null) {
            longitude = 0.0;
        }
        return JCalValue.structured(latitude, longitude);
    }

    @Override
    protected Geo _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        VObjectPropertyValues.StructuredValueIterator it = new VObjectPropertyValues.StructuredValueIterator(value.asStructured());
        String latitudeStr = it.nextValue();
        String longitudeStr = it.nextValue();
        return this.parse(latitudeStr, longitudeStr);
    }

    private char getDelimiter(ICalVersion version) {
        return version == ICalVersion.V1_0 ? (char)',' : ';';
    }

    private Geo parse(String latitudeStr, String longitudeStr) {
        Double latitude = null;
        if (latitudeStr != null) {
            try {
                latitude = Double.valueOf(latitudeStr);
            }
            catch (NumberFormatException e) {
                throw new CannotParseException(21, latitudeStr);
            }
        }
        Double longitude = null;
        if (longitudeStr != null) {
            try {
                longitude = Double.valueOf(longitudeStr);
            }
            catch (NumberFormatException e) {
                throw new CannotParseException(22, longitudeStr);
            }
        }
        return new Geo(latitude, longitude);
    }
}

