/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.component.VAlarm;
import biweekly.io.scribe.property.VCalAlarmPropertyScribe;
import biweekly.property.Action;
import biweekly.property.Attachment;
import biweekly.property.AudioAlarm;
import biweekly.util.org.apache.commons.codec.binary.Base64;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioAlarmScribe
extends VCalAlarmPropertyScribe<AudioAlarm> {
    public AudioAlarmScribe() {
        super(AudioAlarm.class, "AALARM");
    }

    @Override
    protected ICalDataType _dataType(AudioAlarm property, ICalVersion version) {
        if (property.getUri() != null) {
            return ICalDataType.URL;
        }
        if (property.getData() != null) {
            return ICalDataType.BINARY;
        }
        if (property.getContentId() != null) {
            return ICalDataType.CONTENT_ID;
        }
        return null;
    }

    @Override
    protected List<String> writeData(AudioAlarm property) {
        String uri = property.getUri();
        if (uri != null) {
            return Arrays.asList(uri);
        }
        byte[] data = property.getData();
        if (data != null) {
            String base64Str = Base64.encodeBase64String(data);
            return Arrays.asList(base64Str);
        }
        String contentId = property.getContentId();
        if (contentId != null) {
            return Arrays.asList(contentId);
        }
        return Arrays.asList(new String[0]);
    }

    @Override
    protected AudioAlarm create(ICalDataType dataType, VObjectPropertyValues.SemiStructuredValueIterator it) {
        AudioAlarm aalarm = new AudioAlarm();
        String next = it.next();
        if (next == null) {
            return aalarm;
        }
        if (dataType == ICalDataType.BINARY) {
            byte[] data = Base64.decodeBase64(next);
            aalarm.setData(data);
        } else if (dataType == ICalDataType.URL) {
            aalarm.setUri(next);
        } else if (dataType == ICalDataType.CONTENT_ID) {
            aalarm.setContentId(next);
        } else {
            aalarm.setUri(next);
        }
        return aalarm;
    }

    @Override
    protected void toVAlarm(VAlarm valarm, AudioAlarm property) {
        Attachment attach = AudioAlarmScribe.buildAttachment(property);
        if (attach != null) {
            valarm.addAttachment(attach);
        }
    }

    private static Attachment buildAttachment(AudioAlarm aalarm) {
        String type = aalarm.getType();
        String contentType = type == null ? null : "audio/" + type.toLowerCase();
        Attachment attach = new Attachment(contentType, (String)null);
        byte[] data = aalarm.getData();
        if (data != null) {
            attach.setData(data);
            return attach;
        }
        String contentId = aalarm.getContentId();
        if (contentId != null) {
            attach.setContentId(contentId);
            return attach;
        }
        String uri = aalarm.getUri();
        if (uri != null) {
            attach.setUri(uri);
            return attach;
        }
        return null;
    }

    @Override
    protected Action action() {
        return Action.audio();
    }
}

