/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.json;

import biweekly.ICalendar;
import biweekly.io.TimezoneAssignment;
import biweekly.io.json.JCalWriter;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.property.ICalProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonFormat
public class JCalSerializer
extends StdSerializer<ICalendar> {
    private static final long serialVersionUID = 8964681078186049817L;
    private ScribeIndex index = new ScribeIndex();
    private TimezoneAssignment globalTimezone;

    public JCalSerializer() {
        super(ICalendar.class);
    }

    public void serialize(ICalendar value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        JCalWriter writer = new JCalWriter(gen);
        writer.setScribeIndex(this.getScribeIndex());
        writer.setGlobalTimezone(this.globalTimezone);
        writer.write(value);
    }

    public void registerScribe(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public TimezoneAssignment getGlobalTimezone() {
        return this.globalTimezone;
    }

    public void setGlobalTimezone(TimezoneAssignment globalTimezone) {
        this.globalTimezone = globalTimezone;
    }
}

