/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.ICalVersion;
import biweekly.io.ParseWarning;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.util.ICalDate;
import biweekly.util.ListMultimap;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseContext {
    private ICalVersion version;
    private List<ParseWarning> warnings = new ArrayList<ParseWarning>();
    private ListMultimap<String, TimezonedDate> timezonedDates = new ListMultimap();
    private List<TimezonedDate> floatingDates = new ArrayList<TimezonedDate>();
    private Integer lineNumber;
    private String propertyName;

    public ICalVersion getVersion() {
        return this.version;
    }

    public void setVersion(ICalVersion version) {
        this.version = version;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void addDate(ICalDate icalDate, ICalProperty property, ICalParameters parameters) {
        if (!icalDate.hasTime()) {
            return;
        }
        if (icalDate.getRawComponents().isUtc()) {
            return;
        }
        String tzid = parameters.getTimezoneId();
        if (tzid == null) {
            this.addFloatingDate(property, icalDate);
        } else {
            this.addTimezonedDate(tzid, property, icalDate);
        }
    }

    public void addTimezonedDate(String tzid, ICalProperty property, ICalDate date) {
        this.timezonedDates.put(tzid, new TimezonedDate(date, property));
    }

    public ListMultimap<String, TimezonedDate> getTimezonedDates() {
        return this.timezonedDates;
    }

    public void addFloatingDate(ICalProperty property, ICalDate date) {
        this.floatingDates.add(new TimezonedDate(date, property));
    }

    public List<TimezonedDate> getFloatingDates() {
        return this.floatingDates;
    }

    public void addWarning(int code, Object ... args) {
        this.warnings.add(new ParseWarning.Builder(this).message(code, args).build());
    }

    public void addWarning(String message) {
        this.warnings.add(new ParseWarning.Builder(this).message(message).build());
    }

    public List<ParseWarning> getWarnings() {
        return this.warnings;
    }

    public static class TimezonedDate {
        private final ICalDate date;
        private final ICalProperty property;

        public TimezonedDate(ICalDate date, ICalProperty property) {
            this.date = date;
            this.property = property;
        }

        public ICalDate getDate() {
            return this.date;
        }

        public ICalProperty getProperty() {
            return this.property;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
            result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimezonedDate other = (TimezonedDate)obj;
            if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
                return false;
            }
            return !(this.property == null ? other.property != null : !this.property.equals(other.property));
        }
    }
}

