/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.component.DaylightSavingsTime;
import biweekly.component.Observance;
import biweekly.component.StandardTime;
import biweekly.component.VTimezone;
import biweekly.io.ICalTimeZone;
import biweekly.property.Daylight;
import biweekly.property.Timezone;
import biweekly.property.UtcOffsetProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.DateTimeComponents;
import biweekly.util.ICalDate;
import biweekly.util.UtcOffset;
import biweekly.util.com.google.ical.values.DateTimeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataModelConverter {
    public static VTimezone convert(List<Daylight> daylights, Timezone tz) {
        UtcOffset tzOffset = ValuedProperty.getValue(tz);
        if (daylights.isEmpty() && tzOffset == null) {
            return null;
        }
        VTimezone timezone = new VTimezone("TZ");
        if (daylights.isEmpty() && tzOffset != null) {
            StandardTime st = new StandardTime();
            st.setTimezoneOffsetFrom(tzOffset);
            st.setTimezoneOffsetTo(tzOffset);
            timezone.addStandardTime(st);
            return timezone;
        }
        for (Daylight daylight : daylights) {
            if (!daylight.isDaylight()) continue;
            UtcOffset daylightOffset = daylight.getOffset();
            UtcOffset standardOffset = new UtcOffset(daylightOffset.getMillis() - 3600000L);
            DaylightSavingsTime dst = new DaylightSavingsTime();
            dst.setDateStart(daylight.getStart());
            dst.setTimezoneOffsetFrom(standardOffset);
            dst.setTimezoneOffsetTo(daylightOffset);
            dst.addTimezoneName(daylight.getDaylightName());
            timezone.addDaylightSavingsTime(dst);
            StandardTime st = new StandardTime();
            st.setDateStart(daylight.getEnd());
            st.setTimezoneOffsetFrom(daylightOffset);
            st.setTimezoneOffsetTo(standardOffset);
            st.addTimezoneName(daylight.getStandardName());
            timezone.addStandardTime(st);
        }
        return timezone.getComponents().isEmpty() ? null : timezone;
    }

    public static VCalTimezoneProperties convert(VTimezone timezone, List<Date> dates) {
        ArrayList<Daylight> daylights = new ArrayList<Daylight>();
        Timezone tz = null;
        if (dates.isEmpty()) {
            return new VCalTimezoneProperties(daylights, tz);
        }
        ICalTimeZone icalTz = new ICalTimeZone(timezone);
        Collections.sort(dates);
        HashSet<DateTimeValue> daylightStartDates = new HashSet<DateTimeValue>();
        boolean zeroObservanceUsed = false;
        for (Date date : dates) {
            Daylight daylight;
            String daylightName;
            String standardName;
            DateTimeValue end;
            DateTimeValue start;
            UtcOffset offset;
            ICalTimeZone.Boundary boundary = icalTz.getObservanceBoundary(date);
            Observance observance = boundary.getObservanceIn();
            Observance observanceAfter = boundary.getObservanceAfter();
            if (observance == null && observanceAfter == null) continue;
            if (observance == null) {
                if (observanceAfter instanceof StandardTime && !zeroObservanceUsed) {
                    offset = DataModelConverter.getOffset(observanceAfter.getTimezoneOffsetFrom());
                    start = null;
                    end = boundary.getObservanceAfterStart();
                    standardName = icalTz.getDisplayName(false, 0);
                    daylightName = icalTz.getDisplayName(true, 0);
                    daylight = new Daylight(true, offset, DataModelConverter.convert(start), DataModelConverter.convert(end), standardName, daylightName);
                    daylights.add(daylight);
                    zeroObservanceUsed = true;
                }
                if (!(observanceAfter instanceof DaylightSavingsTime) || (offset = DataModelConverter.getOffset(observanceAfter.getTimezoneOffsetFrom())) == null) continue;
                tz = new Timezone(offset);
                continue;
            }
            if (observance instanceof StandardTime) {
                offset = DataModelConverter.getOffset(observance.getTimezoneOffsetTo());
                if (offset == null) continue;
                tz = new Timezone(offset);
                continue;
            }
            if (!(observance instanceof DaylightSavingsTime) || daylightStartDates.contains(boundary.getObservanceInStart())) continue;
            offset = DataModelConverter.getOffset(observance.getTimezoneOffsetTo());
            start = boundary.getObservanceInStart();
            end = null;
            if (observanceAfter != null) {
                end = boundary.getObservanceAfterStart();
            }
            standardName = icalTz.getDisplayName(false, 0);
            daylightName = icalTz.getDisplayName(true, 0);
            daylight = new Daylight(true, offset, DataModelConverter.convert(start), DataModelConverter.convert(end), standardName, daylightName);
            daylights.add(daylight);
            daylightStartDates.add(start);
        }
        if (tz == null) {
            int rawOffset = icalTz.getRawOffset();
            UtcOffset offset = new UtcOffset(rawOffset);
            tz = new Timezone(offset);
        }
        if (daylights.isEmpty()) {
            Daylight daylight = new Daylight();
            daylight.setDaylight(false);
            daylights.add(daylight);
        }
        return new VCalTimezoneProperties(daylights, tz);
    }

    private static UtcOffset getOffset(UtcOffsetProperty property) {
        return property == null ? null : (UtcOffset)property.getValue();
    }

    private static ICalDate convert(DateTimeValue value) {
        if (value == null) {
            return null;
        }
        DateTimeComponents components = new DateTimeComponents(value.year(), value.month(), value.day(), value.hour(), value.minute(), value.second(), false);
        return new ICalDate(components, true);
    }

    private DataModelConverter() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VCalTimezoneProperties {
        private final List<Daylight> daylights;
        private final Timezone tz;

        public VCalTimezoneProperties(List<Daylight> daylights, Timezone tz) {
            this.daylights = daylights;
            this.tz = tz;
        }

        public List<Daylight> getDaylights() {
            return this.daylights;
        }

        public Timezone getTz() {
            return this.tz;
        }
    }
}

