/*
 * Decompiled with CFR 0.152.
 */
package biweekly;

import biweekly.ICalendar;
import biweekly.io.chain.ChainingJsonParser;
import biweekly.io.chain.ChainingJsonStringParser;
import biweekly.io.chain.ChainingJsonWriter;
import biweekly.io.chain.ChainingTextParser;
import biweekly.io.chain.ChainingTextStringParser;
import biweekly.io.chain.ChainingTextWriter;
import biweekly.io.chain.ChainingXmlMemoryParser;
import biweekly.io.chain.ChainingXmlParser;
import biweekly.io.chain.ChainingXmlWriter;
import biweekly.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Biweekly {
    public static final String VERSION;
    public static final String GROUP_ID;
    public static final String ARTIFACT_ID;
    public static final String URL;

    public static ChainingTextStringParser parse(String ical) {
        return new ChainingTextStringParser(ical);
    }

    public static ChainingTextParser<ChainingTextParser<?>> parse(File file) {
        return new ChainingTextParser(file);
    }

    public static ChainingTextParser<ChainingTextParser<?>> parse(InputStream in) {
        return new ChainingTextParser(in);
    }

    public static ChainingTextParser<ChainingTextParser<?>> parse(Reader reader) {
        return new ChainingTextParser(reader);
    }

    public static ChainingTextWriter write(ICalendar ... icals) {
        return Biweekly.write(Arrays.asList(icals));
    }

    public static ChainingTextWriter write(Collection<ICalendar> icals) {
        return new ChainingTextWriter(icals);
    }

    public static ChainingXmlMemoryParser parseXml(String xml) {
        return new ChainingXmlMemoryParser(xml);
    }

    public static ChainingXmlParser<ChainingXmlParser<?>> parseXml(File file) {
        return new ChainingXmlParser(file);
    }

    public static ChainingXmlParser<ChainingXmlParser<?>> parseXml(InputStream in) {
        return new ChainingXmlParser(in);
    }

    public static ChainingXmlParser<ChainingXmlParser<?>> parseXml(Reader reader) {
        return new ChainingXmlParser(reader);
    }

    public static ChainingXmlMemoryParser parseXml(Document document) {
        return new ChainingXmlMemoryParser(document);
    }

    public static ChainingXmlWriter writeXml(ICalendar ... icals) {
        return Biweekly.writeXml(Arrays.asList(icals));
    }

    public static ChainingXmlWriter writeXml(Collection<ICalendar> icals) {
        return new ChainingXmlWriter(icals);
    }

    public static ChainingJsonStringParser parseJson(String json) {
        return new ChainingJsonStringParser(json);
    }

    public static ChainingJsonParser<ChainingJsonParser<?>> parseJson(File file) {
        return new ChainingJsonParser(file);
    }

    public static ChainingJsonParser<ChainingJsonParser<?>> parseJson(InputStream in) {
        return new ChainingJsonParser(in);
    }

    public static ChainingJsonParser<ChainingJsonParser<?>> parseJson(Reader reader) {
        return new ChainingJsonParser(reader);
    }

    public static ChainingJsonWriter writeJson(ICalendar ... icals) {
        return Biweekly.writeJson(Arrays.asList(icals));
    }

    public static ChainingJsonWriter writeJson(Collection<ICalendar> icals) {
        return new ChainingJsonWriter(icals);
    }

    private Biweekly() {
    }

    static {
        InputStream in = null;
        try {
            in = Biweekly.class.getResourceAsStream("biweekly.properties");
            Properties props = new Properties();
            props.load(in);
            VERSION = props.getProperty("version");
            GROUP_ID = props.getProperty("groupId");
            ARTIFACT_ID = props.getProperty("artifactId");
            URL = props.getProperty("url");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }
}

