/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.wkt.StoreFormat;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultAddress;
import org.apache.sis.metadata.iso.citation.DefaultContact;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.iso.lineage.DefaultLineage;
import org.apache.sis.metadata.iso.lineage.DefaultSource;
import org.apache.sis.metadata.iso.quality.DefaultDataQuality;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

final class MetadataReader
extends MetadataBuilder {
    private static final boolean EXPERIMENTAL = true;
    private static final String[] SEARCH_PATH = new String[]{"NCISOMetadata", "CFMetadata", null, "THREDDSMetadata"};
    private static final String[] SERVICES = new String[]{"wms_service", "wcs_service"};
    private static final char SEPARATOR = ',';
    private static final char QUOTE = '\"';
    private static final VerticalCRS VERTICAL_CRS = null;
    private final Decoder decoder;
    private final String[] searchPath;
    private transient DefaultNameFactory nameFactory;
    private transient ResponsibleParty pointOfContact;

    MetadataReader(Decoder decoder) {
        this.decoder = decoder;
        decoder.setSearchPath(SEARCH_PATH);
        this.searchPath = decoder.getSearchPath();
    }

    private void warning(Exception exception) {
        this.decoder.listeners.warning(null, exception);
    }

    private Errors errors() {
        return Errors.getResources((Locale)this.decoder.listeners.getLocale());
    }

    static List<String> split(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)0, (int)string.length());
        while ((n = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)n, (int)n2)) < n2) {
            int n3;
            int n4;
            block6: {
                if (string.charAt(n) == '\"') {
                    n4 = ++n;
                    while ((n3 = string.indexOf(34, n4)) >= 0) {
                        n4 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n3 + 1), (int)n2);
                        if (n4 < n2 && string.charAt(n4) != ',') continue;
                        break block6;
                    }
                    break;
                }
                n4 = string.indexOf(44, n);
                if (n4 < 0) break;
                n3 = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)n, (int)n4);
            }
            if (n != n3) {
                arrayList.add(string.substring(n, n3));
            }
            n = n4 + 1;
        }
        if (n < n2) {
            arrayList.add(string.substring(n, n2));
        }
        return arrayList;
    }

    private static String trim(String string) {
        if (string != null && (string = string.trim()).isEmpty()) {
            string = null;
        }
        return string;
    }

    private String stringValue(String string) {
        return MetadataReader.trim(this.decoder.stringValue(string));
    }

    private static InternationalString toInternationalString(String string) {
        return string != null ? new SimpleInternationalString(string) : null;
    }

    private <T extends CodeList<T>> T forCodeName(Class<T> clazz, String string) {
        CodeList codeList = Types.forCodeName(clazz, (String)string, (boolean)false);
        if (codeList == null && string != null) {
            this.decoder.listeners.warning(this.errors().getString((short)146, clazz, (Object)string), null);
        }
        return (T)codeList;
    }

    private static <T> void addIfAbsent(Collection<T> collection, T t) {
        if (!collection.contains(t)) {
            collection.add(t);
        }
    }

    private static <T> Set<T> addIfNonNull(Set<T> set, T t) {
        if (t != null) {
            if (set == null) {
                set = new LinkedHashSet<T>(4);
            }
            set.add(t);
        }
        return set;
    }

    private static boolean canShare(CharSequence charSequence, String string) {
        return string == null || charSequence != null && charSequence.toString().equals(string);
    }

    private static boolean canShare(Collection<String> collection, String string) {
        return string == null || collection.contains(string);
    }

    private static boolean canShare(OnlineResource onlineResource, String string) {
        return string == null || onlineResource != null && MetadataReader.canShare(onlineResource.getLinkage().toString(), string);
    }

    private static boolean canShare(Address address, String string) {
        return string == null || address != null && MetadataReader.canShare(address.getElectronicMailAddresses(), string);
    }

    private URI createURI(String string) {
        if (string != null) {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.warning(uRISyntaxException);
            }
        }
        return null;
    }

    private OnlineResource createOnlineResource(String string) {
        URI uRI = this.createURI(string);
        if (uRI == null) {
            return null;
        }
        DefaultOnlineResource defaultOnlineResource = new DefaultOnlineResource(uRI);
        String string2 = uRI.getScheme();
        defaultOnlineResource.setProtocol(string2);
        if ("http".equalsIgnoreCase(string2) || "https".equalsIgnoreCase(string2)) {
            defaultOnlineResource.setApplicationProfile("web browser");
        }
        defaultOnlineResource.setFunction(OnLineFunction.INFORMATION);
        return defaultOnlineResource;
    }

    private static Address createAddress(String string) {
        if (string != null) {
            DefaultAddress defaultAddress = new DefaultAddress();
            defaultAddress.setElectronicMailAddresses(Collections.singleton(string));
            return defaultAddress;
        }
        return null;
    }

    private static Contact createContact(Address address, OnlineResource onlineResource) {
        if (address != null || onlineResource != null) {
            DefaultContact defaultContact = new DefaultContact();
            if (address != null) {
                defaultContact.setAddresses(Collections.singleton(address));
            }
            if (onlineResource != null) {
                defaultContact.setOnlineResources(Collections.singleton(onlineResource));
            }
            return defaultContact;
        }
        return null;
    }

    private ResponsibleParty createResponsibleParty(AttributeNames.Responsible responsible, boolean bl) {
        Role role;
        String string = this.stringValue(responsible.NAME);
        String string2 = this.stringValue(responsible.INSTITUTION);
        String string3 = this.stringValue(responsible.EMAIL);
        String string4 = this.stringValue(responsible.URL);
        if (string2 == null && bl) {
            string2 = this.stringValue("institution");
        }
        if (string == null && string2 == null && string3 == null && string4 == null) {
            return null;
        }
        if (string2 == null) {
            if (this.isOrganisation(responsible)) {
                string2 = string;
                string = null;
            }
        } else if (string2.equalsIgnoreCase(string)) {
            string = null;
        }
        if ((role = this.forCodeName(Role.class, this.stringValue(responsible.ROLE))) == null) {
            role = bl ? Role.POINT_OF_CONTACT : responsible.DEFAULT_ROLE;
        }
        ResponsibleParty responsibleParty = this.pointOfContact;
        Contact contact = null;
        Address address = null;
        OnlineResource onlineResource = null;
        if (responsibleParty != null) {
            contact = responsibleParty.getContactInfo();
            if (contact != null) {
                address = contact.getAddress();
                onlineResource = contact.getOnlineResource();
            }
            if (!MetadataReader.canShare(onlineResource, string4)) {
                onlineResource = null;
                contact = null;
                responsibleParty = null;
            }
            if (!MetadataReader.canShare(address, string3)) {
                address = null;
                contact = null;
                responsibleParty = null;
            }
            if (!(responsibleParty == null || MetadataReader.canShare((CharSequence)responsibleParty.getOrganisationName(), string2) && MetadataReader.canShare(responsibleParty.getIndividualName(), string))) {
                responsibleParty = null;
            }
        }
        if (responsibleParty == null) {
            if (contact == null) {
                if (address == null) {
                    address = MetadataReader.createAddress(string3);
                }
                if (onlineResource == null) {
                    onlineResource = this.createOnlineResource(string4);
                }
                contact = MetadataReader.createContact(address, onlineResource);
            }
            if (string != null || string2 != null || contact != null) {
                DefaultIndividual defaultIndividual = null;
                if (string != null) {
                    defaultIndividual = new DefaultIndividual((CharSequence)string, null, null);
                }
                if (string2 != null) {
                    defaultIndividual = new DefaultOrganisation((CharSequence)string2, null, defaultIndividual, null);
                }
                if (defaultIndividual == null) {
                    Object object = defaultIndividual = this.isOrganisation(responsible) ? new DefaultOrganisation() : new DefaultIndividual();
                }
                if (contact != null) {
                    defaultIndividual.setContactInfo(Collections.singleton(contact));
                }
                responsibleParty = new DefaultResponsibleParty(role);
                ((DefaultResponsibleParty)responsibleParty).setParties(Collections.singleton(defaultIndividual));
            }
        }
        return responsibleParty;
    }

    private boolean isOrganisation(AttributeNames.Responsible responsible) {
        String string = this.stringValue(responsible.TYPE);
        return "institution".equalsIgnoreCase(string) || "group".equalsIgnoreCase(string);
    }

    /*
     * WARNING - void declaration
     */
    private Set<InternationalString> addCitation() {
        void var2_4;
        String string = this.stringValue("title");
        if (string == null && (string = this.stringValue("full_name")) == null && (string = this.stringValue("name")) == null) {
            string = this.decoder.getTitle();
        }
        this.addTitle(string);
        this.addEdition(this.stringValue("product_version"));
        this.addOtherCitationDetails(this.stringValue("references"));
        this.addCitationDate(this.decoder.dateValue("metadata_creation"), DateType.CREATION, MetadataBuilder.Scope.ALL);
        this.addCitationDate(this.decoder.dateValue("date_metadata_modified"), DateType.REVISION, MetadataBuilder.Scope.ALL);
        this.addCitationDate(this.decoder.dateValue("date_created"), DateType.CREATION, MetadataBuilder.Scope.RESOURCE);
        this.addCitationDate(this.decoder.dateValue("date_modified"), DateType.REVISION, MetadataBuilder.Scope.RESOURCE);
        this.addCitationDate(this.decoder.dateValue("date_issued"), DateType.PUBLICATION, MetadataBuilder.Scope.RESOURCE);
        for (String string2 : this.searchPath) {
            this.decoder.setSearchPath(string2);
            ResponsibleParty responsibleParty = this.createResponsibleParty(AttributeNames.CREATOR, true);
            if (responsibleParty == this.pointOfContact) continue;
            this.addPointOfContact(responsibleParty, MetadataBuilder.Scope.ALL);
            if (this.pointOfContact != null) continue;
            this.pointOfContact = responsibleParty;
        }
        this.addCitedResponsibleParty(this.pointOfContact, Role.ORIGINATOR);
        Object var2_3 = null;
        for (String string3 : this.searchPath) {
            ResponsibleParty responsibleParty;
            this.decoder.setSearchPath(string3);
            ResponsibleParty responsibleParty2 = this.createResponsibleParty(AttributeNames.CONTRIBUTOR, false);
            if (responsibleParty2 != this.pointOfContact) {
                this.addCitedResponsibleParty(responsibleParty2, null);
            }
            if ((responsibleParty = this.createResponsibleParty(AttributeNames.PUBLISHER, false)) == null) continue;
            this.addDistributor(responsibleParty);
            Set<InternationalString> set2 = MetadataReader.addIfNonNull(var2_4, responsibleParty.getOrganisationName());
            set2 = MetadataReader.addIfNonNull(set2, MetadataReader.toInternationalString(responsibleParty.getIndividualName()));
        }
        this.decoder.setSearchPath(this.searchPath);
        return var2_4;
    }

    private void addIdentificationInfo(Set<InternationalString> set) {
        boolean bl = false;
        Set<String> set2 = null;
        Set<String> set3 = null;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : this.searchPath) {
            this.decoder.setSearchPath(string);
            linkedHashSet.addAll(MetadataReader.split(this.stringValue(AttributeNames.KEYWORDS.TEXT)));
            set3 = MetadataReader.addIfNonNull(set3, this.stringValue(AttributeNames.STANDARD_NAME.TEXT));
            set2 = MetadataReader.addIfNonNull(set2, this.stringValue("project"));
            for (String string2 : MetadataReader.split(this.stringValue("acces_constraint"))) {
                this.addAccessConstraint(this.forCodeName(Restriction.class, string2));
            }
            this.addTopicCategory(this.forCodeName(TopicCategory.class, this.stringValue("topic_category")));
            this.addSpatialRepresentation(this.forCodeName(SpatialRepresentationType.class, this.stringValue("cdm_data_type")));
            if (bl) continue;
            bl = this.addExtent();
        }
        this.decoder.setSearchPath(this.searchPath);
        this.addAbstract(this.stringValue("summary"));
        this.addPurpose(this.stringValue("purpose"));
        this.addSupplementalInformation(this.stringValue("comment"));
        this.addCredits(this.stringValue("acknowledgement"));
        this.addCredits(this.stringValue("acknowledgment"));
        this.addUseLimitation(this.stringValue("license"));
        this.addKeywords(set3, KeywordType.THEME, this.stringValue(AttributeNames.STANDARD_NAME.VOCABULARY));
        this.addKeywords(linkedHashSet, KeywordType.THEME, this.stringValue(AttributeNames.KEYWORDS.VOCABULARY));
        this.addKeywords(set2, KeywordType.valueOf((String)"PROJECT"), null);
        this.addKeywords(set, KeywordType.valueOf((String)"DATA_CENTRE"), null);
        String string = this.stringValue("geospatial_bounds");
        if (string != null) {
            this.addBoundingPolygon(new StoreFormat(this.decoder.geomlib, this.decoder.listeners).parseGeometry(string, this.stringValue("geospatial_bounds_crs"), this.stringValue("geospatial_bounds_vertical_crs")));
        }
    }

    private void addSpatialRepresentationInfo(GridGeometry gridGeometry) throws IOException, DataStoreException {
        Axis[] axisArray = gridGeometry.getAxes();
        int n = axisArray.length;
        while (n > 0) {
            AttributeNames.Dimension dimension;
            int n2 = axisArray.length - n;
            Axis axis = axisArray[--n];
            if (axis.sourceSizes.length >= 1) {
                this.setAxisLength(n2, axis.sourceSizes[0]);
            }
            if ((dimension = axis.attributeNames) == null) continue;
            this.setAxisName(n2, dimension.DEFAULT_NAME_TYPE);
            Number number = this.decoder.numericValue(dimension.RESOLUTION);
            if (number == null) continue;
            this.setAxisResolution(n2, number.doubleValue());
        }
        this.setCellGeometry(CellGeometry.AREA);
    }

    private boolean addExtent() {
        Date date;
        Object object;
        boolean bl;
        this.addExtent(this.stringValue("geographic_identifier"));
        Number number = this.decoder.numericValue(AttributeNames.LONGITUDE.MINIMUM);
        Number number2 = this.decoder.numericValue(AttributeNames.LONGITUDE.MAXIMUM);
        Number number3 = this.decoder.numericValue(AttributeNames.LATITUDE.MINIMUM);
        Number number4 = this.decoder.numericValue(AttributeNames.LATITUDE.MAXIMUM);
        Number number5 = this.decoder.numericValue(AttributeNames.VERTICAL.MINIMUM);
        Number number6 = this.decoder.numericValue(AttributeNames.VERTICAL.MAXIMUM);
        boolean bl2 = bl = number != null || number2 != null || number3 != null || number4 != null;
        if (bl) {
            object = this.getConverterTo(this.decoder.unitValue(AttributeNames.LONGITUDE.UNITS), Units.DEGREE);
            date = this.getConverterTo(this.decoder.unitValue(AttributeNames.LATITUDE.UNITS), Units.DEGREE);
            this.addExtent(new double[]{MetadataReader.valueOf(number, object), MetadataReader.valueOf(number2, object), MetadataReader.valueOf(number3, (UnitConverter)date), MetadataReader.valueOf(number4, (UnitConverter)date)}, 0);
        }
        if (number5 != null || number6 != null) {
            object = this.getConverterTo(this.decoder.unitValue(AttributeNames.VERTICAL.UNITS), Units.METRE);
            double d = MetadataReader.valueOf(number5, object);
            double d2 = MetadataReader.valueOf(number6, object);
            if ("down".equals(this.stringValue(AttributeNames.VERTICAL.POSITIVE))) {
                double d3 = d;
                d = -d2;
                d2 = -d3;
            }
            this.addVerticalExtent(d, d2, VERTICAL_CRS);
            bl = true;
        }
        object = this.decoder.dateValue(AttributeNames.TIME.MINIMUM);
        date = this.decoder.dateValue(AttributeNames.TIME.MAXIMUM);
        if (object == null && date == null) {
            String string;
            Number number7 = this.decoder.numericValue(AttributeNames.TIME.MINIMUM);
            Number number8 = this.decoder.numericValue(AttributeNames.TIME.MAXIMUM);
            if ((number7 != null || number8 != null) && (string = this.stringValue(AttributeNames.TIME.UNITS)) != null) {
                Date[] dateArray = this.decoder.numberToDate(string, number7, number8);
                object = dateArray[0];
                date = dateArray[1];
            }
        }
        if (object != null || date != null) {
            try {
                this.addTemporalExtent((Date)object, date);
                bl = true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.warning(unsupportedOperationException);
            }
        }
        return bl;
    }

    private UnitConverter getConverterTo(Unit<?> unit, Unit<?> unit2) {
        if (unit != null) {
            try {
                return unit.getConverterToAny(unit2);
            }
            catch (IncommensurableException incommensurableException) {
                this.warning((Exception)((Object)incommensurableException));
            }
        }
        return null;
    }

    private static double valueOf(Number number, UnitConverter unitConverter) {
        double d = Double.NaN;
        if (number != null) {
            d = number.doubleValue();
            if (unitConverter != null) {
                d = unitConverter.convert(d);
            }
        }
        return d;
    }

    private void addAcquisitionInfo() {
        AttributeNames.Term[] termArray = new AttributeNames.Term[]{AttributeNames.PROGRAM, AttributeNames.PLATFORM, AttributeNames.INSTRUMENT};
        for (int i = 0; i < termArray.length; ++i) {
            AttributeNames.Term term = termArray[i];
            String string = this.stringValue(term.VOCABULARY);
            for (String string2 : MetadataReader.split(this.stringValue(term.TEXT))) {
                switch (i) {
                    case 0: {
                        this.addAcquisitionOperation(string, string2);
                        break;
                    }
                    case 1: {
                        this.addPlatform(string, string2);
                        break;
                    }
                    case 2: {
                        this.addInstrument(string, string2);
                    }
                }
            }
        }
    }

    private void addContentInfo() {
        HashMap hashMap = new HashMap(4);
        for (Variable variable : this.decoder.getVariables()) {
            if (!variable.isCoverage(2)) continue;
            Object object = Arrays.asList(variable.getGridDimensionNames());
            CollectionsExt.addToMultiValuesMap(hashMap, object, (Object)variable);
        }
        String string = this.stringValue("processing_level");
        for (List list : hashMap.values()) {
            this.newCoverage(false);
            this.setProcessingLevelCode(null, string);
            for (Object object : list) {
                this.addSampleDimension((Variable)object);
                Object[] objectArray = ((Variable)object).getAttributeValues("flag_names", false);
                Object[] objectArray2 = ((Variable)object).getAttributeValues("flag_meanings", false);
                Object[] objectArray3 = ((Variable)object).getAttributeValues("flag_masks", true);
                Object[] objectArray4 = ((Variable)object).getAttributeValues("flag_values", true);
                int n = Math.max(objectArray3.length, Math.max(objectArray4.length, Math.max(objectArray.length, objectArray2.length)));
                for (int i = 0; i < n; ++i) {
                    this.addSampleValueDescription((Variable)object, i < objectArray.length ? (String)objectArray[i] : null, i < objectArray2.length ? (String)objectArray2[i] : null, i < objectArray3.length ? (Number)((Number)objectArray3[i]) : (Number)null, i < objectArray4.length ? (Number)((Number)objectArray4[i]) : (Number)null);
                }
            }
        }
    }

    private void addSampleDimension(Variable variable) {
        String string;
        String string2;
        Object[] objectArray;
        String string3;
        this.newSampleDimension();
        String string4 = MetadataReader.trim(variable.getName());
        if (string4 != null) {
            if (this.nameFactory == null) {
                this.nameFactory = (DefaultNameFactory)DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
            }
            this.setBandIdentifier(this.nameFactory.createMemberName(null, (CharSequence)string4, this.nameFactory.createTypeName(null, (CharSequence)variable.getDataTypeName())));
        }
        String string5 = string3 = (objectArray = variable.getAttributeValues("standard_name", false)).length == 1 ? MetadataReader.trim((String)objectArray[0]) : null;
        if (string3 != null && !string3.equals(string4)) {
            objectArray = variable.getAttributeValues("standard_name_vocabulary", false);
            this.addBandName(objectArray.length == 1 ? (String)objectArray[0] : null, string3);
        }
        if ((string2 = MetadataReader.trim(variable.getDescription())) != null && !string2.equals(string4) && !string2.equals(string3)) {
            this.addBandDescription(string2);
        }
        if ((string = variable.getUnitsString()) != null) {
            try {
                this.setSampleUnits(Units.valueOf((String)string));
            }
            catch (ClassCastException | ParserException throwable) {
                this.decoder.listeners.warning(this.errors().getString((short)3, (Object)string4, (Object)string), (Exception)throwable);
            }
        }
        double d = Double.NaN;
        double d2 = Double.NaN;
        objectArray = variable.getAttributeValues("scale_factor", true);
        if (objectArray.length == 1) {
            d = ((Number)objectArray[0]).doubleValue();
        }
        if ((objectArray = variable.getAttributeValues("add_offset", true)).length == 1) {
            d2 = ((Number)objectArray[0]).doubleValue();
        }
        this.setTransferFunction(d, d2);
        this.addContentType(this.forCodeName(CoverageContentType.class, this.stringValue("coverage_content_type")));
    }

    private void addSampleValueDescription(Variable variable, String string, String string2, Number number, Number number2) {
        this.addSampleValueDescription(string, string2);
    }

    private void addFileIdentifier() {
        String string;
        String string2 = this.stringValue(AttributeNames.IDENTIFIER.TEXT);
        if (string2 != null) {
            string = this.stringValue(AttributeNames.IDENTIFIER.VOCABULARY);
        } else {
            string2 = this.decoder.getId();
            if (string2 == null && (string2 = IOUtilities.filenameWithoutExtension(this.decoder.getFilename())) == null) {
                return;
            }
            string = null;
        }
        if (string == null) {
            this.addTitleOrIdentifier(string2, MetadataBuilder.Scope.ALL);
        } else {
            this.addIdentifier(string, string2, MetadataBuilder.Scope.ALL);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Metadata read() throws IOException, DataStoreException {
        void var5_10;
        String string;
        this.addResourceScope(ScopeCode.DATASET, null);
        Set<InternationalString> set = this.addCitation();
        this.addIdentificationInfo(set);
        for (String object : SERVICES) {
            string = this.stringValue(object);
            if (string == null) continue;
            this.addResourceScope(ScopeCode.SERVICE, string);
        }
        this.addAcquisitionInfo();
        this.addContentInfo();
        for (GridGeometry gridGeometry : this.decoder.getGridGeometries()) {
            if (gridGeometry.getSourceDimensions() < 2 || gridGeometry.getTargetDimensions() < 2) continue;
            this.addSpatialRepresentationInfo(gridGeometry);
        }
        this.addFileIdentifier();
        DefaultMetadata defaultMetadata = this.build(false);
        String[] stringArray = this.searchPath;
        int n = stringArray.length;
        boolean bl = false;
        while (var5_10 < n) {
            string = stringArray[var5_10];
            this.decoder.setSearchPath(string);
            DefaultLineage defaultLineage = null;
            String string2 = this.stringValue("history");
            if (string2 != null) {
                defaultLineage = new DefaultLineage();
                defaultLineage.setStatement((InternationalString)new SimpleInternationalString(string2));
            }
            if ((string2 = this.stringValue("source")) != null) {
                if (defaultLineage == null) {
                    defaultLineage = new DefaultLineage();
                }
                MetadataReader.addIfAbsent(defaultLineage.getSources(), new DefaultSource((CharSequence)string2));
            }
            if (defaultLineage != null) {
                DefaultDataQuality defaultDataQuality = new DefaultDataQuality(ScopeCode.DATASET);
                defaultDataQuality.setLineage((Lineage)defaultLineage);
                MetadataReader.addIfAbsent(defaultMetadata.getDataQualityInfo(), defaultDataQuality);
            }
            ++var5_10;
        }
        this.decoder.setSearchPath(this.searchPath);
        defaultMetadata.setMetadataStandards((Collection)Citations.ISO_19115);
        this.addCompleteMetadata(this.createURI(this.stringValue("metadata_link")));
        return defaultMetadata;
    }
}

