/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.any23.writer.FormatWriter;
import org.apache.any23.writer.TripleFormat;
import org.apache.any23.writer.TripleHandlerException;
import org.apache.any23.writer.TripleWriterHandler;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class URIListWriter
extends TripleWriterHandler
implements FormatWriter {
    private static final Charset charset = StandardCharsets.UTF_8;
    static final TripleFormat FORMAT = TripleFormat.of((String)"URIList", Collections.singleton("text/plain"), (Charset)charset, Collections.singleton("txt"), null, (TripleFormat.Capabilities)TripleFormat.NONSTANDARD);
    private final TreeSet<String> resources = new TreeSet();
    private PrintWriter writer;

    public URIListWriter(OutputStream outputStream) {
        this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, charset)));
    }

    public void writeTriple(Resource s, IRI p, Value o, Resource g) throws TripleHandlerException {
        String string;
        if (s instanceof IRI && this.resources.add(string = s.stringValue())) {
            this.writer.println(string);
        }
        if (o instanceof IRI && this.resources.add(string = o.stringValue())) {
            this.writer.println(string);
        }
    }

    public void writeNamespace(String prefix, String uri) throws TripleHandlerException {
    }

    @Override
    public void endDocument(IRI documentIRI) throws TripleHandlerException {
        this.writer.flush();
    }

    public void close() throws TripleHandlerException {
        this.writer.flush();
        this.writer = null;
        this.resources.clear();
    }

    public boolean isAnnotated() {
        return false;
    }

    public void setAnnotated(boolean f) {
    }
}

