/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.validator.rule;

import java.util.List;
import org.apache.any23.validator.DOMDocument;
import org.apache.any23.validator.Rule;
import org.apache.any23.validator.RuleContext;
import org.apache.any23.validator.ValidationReport;
import org.apache.any23.validator.ValidationReportBuilder;
import org.w3c.dom.Node;

public class MissingItemscopeAttributeValueRule
implements Rule {
    @Override
    public String getHRName() {
        return "missing-itemscope-value-rule";
    }

    @Override
    public boolean applyOn(DOMDocument document, RuleContext context, ValidationReportBuilder validationReportBuilder) {
        List<Node> itemNodes = document.getNodesWithAttribute("itemscope");
        boolean foundPrecondition = false;
        Node iNode = null;
        for (Node itemNode : itemNodes) {
            iNode = itemNode;
            String propertyNode = iNode.getAttributes().getNamedItem("itemscope").getNodeValue();
            if (propertyNode != null && !propertyNode.contentEquals("")) continue;
            foundPrecondition = true;
            break;
        }
        if (foundPrecondition) {
            validationReportBuilder.reportIssue(ValidationReport.IssueLevel.ERROR, "Located absence of an accompanying value for the the 'itemscope' attribute of element with hashcode: " + iNode.hashCode(), iNode);
            return true;
        }
        return false;
    }
}

