/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.validator.rule;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.any23.validator.DOMDocument;
import org.apache.any23.validator.Rule;
import org.apache.any23.validator.RuleContext;
import org.apache.any23.validator.ValidationReport;
import org.apache.any23.validator.ValidationReportBuilder;
import org.w3c.dom.Node;

public class AboutNotURIRule
implements Rule {
    public static final String NODES_WITH_INVALID_ABOUT = "nodes-with-invalid-about";

    @Override
    public String getHRName() {
        return "about-not-uri-rule";
    }

    @Override
    public boolean applyOn(DOMDocument document, RuleContext context, ValidationReportBuilder validationReportBuilder) {
        List<Node> nodesWithAbout = document.getNodesWithAttribute("about");
        ArrayList<Node> nodesWithInvalidAbout = new ArrayList<Node>();
        for (Node nodeWithAbout : nodesWithAbout) {
            if (this.aboutIsValid(nodeWithAbout)) continue;
            validationReportBuilder.reportIssue(ValidationReport.IssueLevel.ERROR, "Invalid about value for node, expected valid URL.", nodeWithAbout);
            nodesWithInvalidAbout.add(nodeWithAbout);
        }
        if (nodesWithInvalidAbout.isEmpty()) {
            return false;
        }
        context.putData(NODES_WITH_INVALID_ABOUT, nodesWithInvalidAbout);
        return true;
    }

    private boolean aboutIsValid(Node n) {
        String aboutContent = n.getAttributes().getNamedItem("about").getTextContent();
        if (this.isURL(aboutContent)) {
            return true;
        }
        char firstChar = aboutContent.charAt(0);
        return firstChar == '#' || firstChar == '/';
    }

    private boolean isURL(String candidateIRIStr) {
        try {
            new URL(candidateIRIStr);
        }
        catch (MalformedURLException murle) {
            return false;
        }
        return true;
    }
}

