/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.validator;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.any23.validator.DOMDocument;
import org.apache.any23.validator.DefaultDOMDocument;
import org.apache.any23.validator.DefaultRuleContext;
import org.apache.any23.validator.DefaultValidationReportBuilder;
import org.apache.any23.validator.Fix;
import org.apache.any23.validator.Rule;
import org.apache.any23.validator.ValidationReport;
import org.apache.any23.validator.Validator;
import org.apache.any23.validator.ValidatorException;
import org.apache.any23.validator.rule.AboutNotURIRule;
import org.apache.any23.validator.rule.MetaNameMisuseFix;
import org.apache.any23.validator.rule.MetaNameMisuseRule;
import org.apache.any23.validator.rule.MissingItemscopeAttributeValueFix;
import org.apache.any23.validator.rule.MissingItemscopeAttributeValueRule;
import org.apache.any23.validator.rule.MissingOpenGraphNamespaceRule;
import org.apache.any23.validator.rule.OpenGraphNamespaceFix;
import org.w3c.dom.Document;

public class DefaultValidator
implements Validator {
    private Map<Class<? extends Rule>, List<Class<? extends Fix>>> rulesToFixes = new HashMap<Class<? extends Rule>, List<Class<? extends Fix>>>();
    private List<Class<? extends Rule>> rulesOrder = new ArrayList<Class<? extends Rule>>();

    public DefaultValidator() {
        this.loadDefaultRules();
    }

    @Override
    public ValidationReport validate(DOMDocument document, boolean applyFix) throws ValidatorException {
        DefaultValidationReportBuilder validationReportBuilder = new DefaultValidationReportBuilder();
        for (Class<? extends Rule> cRule : this.rulesOrder) {
            boolean applyOn;
            Rule rule = this.newRuleInstance(cRule);
            DefaultRuleContext ruleContext = new DefaultRuleContext();
            try {
                applyOn = rule.applyOn(document, ruleContext, validationReportBuilder);
            }
            catch (Exception e) {
                validationReportBuilder.reportRuleError(rule, e, "Error while processing rule.");
                continue;
            }
            if (!applyFix || !applyOn) continue;
            validationReportBuilder.traceRuleActivation(rule);
            List<Class<? extends Fix>> cFixes = this.getFixes(cRule);
            for (Class<? extends Fix> cFix : cFixes) {
                Fix fix = this.newFixInstance(cFix);
                try {
                    fix.execute(rule, ruleContext, document);
                }
                catch (Exception e) {
                    validationReportBuilder.reportFixError(fix, e, "Error while processing fix.");
                }
            }
        }
        return validationReportBuilder.getReport();
    }

    @Override
    public ValidationReport validate(URI documentIRI, Document document, boolean applyFix) throws ValidatorException {
        return this.validate(new DefaultDOMDocument(documentIRI, document), applyFix);
    }

    @Override
    public synchronized void addRule(Class<? extends Rule> rule, Class<? extends Fix> fix) {
        List<Class<? extends Fix>> fixes = this.rulesToFixes.get(rule);
        if (fixes == null) {
            fixes = new ArrayList<Class<? extends Fix>>();
        }
        this.rulesOrder.add(rule);
        this.rulesToFixes.put(rule, fixes);
        if (fix != null) {
            fixes.add(fix);
        }
    }

    @Override
    public void addRule(Class<? extends Rule> rule) {
        this.addRule(rule, null);
    }

    @Override
    public synchronized void removeRule(Class<? extends Rule> rule) {
        this.rulesOrder.remove(rule);
        this.rulesToFixes.remove(rule);
    }

    @Override
    public List<Class<? extends Rule>> getAllRules() {
        return Collections.unmodifiableList(this.rulesOrder);
    }

    @Override
    public List<Class<? extends Fix>> getFixes(Class<? extends Rule> rule) {
        List<Class<? extends Fix>> fixes = this.rulesToFixes.get(rule);
        return fixes == null ? Collections.emptyList() : Collections.unmodifiableList(this.rulesToFixes.get(rule));
    }

    private void loadDefaultRules() {
        this.addRule(MetaNameMisuseRule.class, MetaNameMisuseFix.class);
        this.addRule(MissingOpenGraphNamespaceRule.class, OpenGraphNamespaceFix.class);
        this.addRule(AboutNotURIRule.class);
        this.addRule(MissingItemscopeAttributeValueRule.class, MissingItemscopeAttributeValueFix.class);
    }

    private Fix newFixInstance(Class<? extends Fix> cFix) throws ValidatorException {
        try {
            return cFix.newInstance();
        }
        catch (Exception e) {
            throw new ValidatorException("An error occurred while instantiating a fix.", e);
        }
    }

    private Rule newRuleInstance(Class<? extends Rule> cRule) throws ValidatorException {
        try {
            return cRule.newInstance();
        }
        catch (Exception e) {
            throw new ValidatorException("An error occurred while instantiating a rule.", e);
        }
    }
}

