/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.validator;

import java.net.URI;
import java.util.List;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.validator.DOMDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DefaultDOMDocument
implements DOMDocument {
    private URI documentIRI;
    private Document document;

    public DefaultDOMDocument(URI documentIRI, Document document) {
        if (documentIRI == null) {
            throw new NullPointerException("documentIRI cannot be null.");
        }
        if (document == null) {
            throw new NullPointerException("document cannot be null.");
        }
        this.documentIRI = documentIRI;
        this.document = document;
    }

    @Override
    public URI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public Document getOriginalDocument() {
        return this.document;
    }

    @Override
    public List<Node> getNodes(String xPath) {
        return DomUtils.findAll(this.document, xPath);
    }

    @Override
    public Node getNode(String xPath) {
        List<Node> nodes = DomUtils.findAll(this.document, xPath);
        if (nodes.size() == 0) {
            throw new IllegalArgumentException(String.format("Cannot find node at XPath '%s'", xPath));
        }
        if (nodes.size() > 1) {
            throw new IllegalArgumentException(String.format("The given XPath '%s' corresponds to more than one node.", xPath));
        }
        return nodes.get(0);
    }

    @Override
    public void addAttribute(String xPath, String attrName, String attrValue) {
        Node node = this.getNode(xPath);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Attr attr = this.document.createAttribute(attrName);
        attr.setNodeValue(attrValue);
        namedNodeMap.setNamedItem(attr);
    }

    @Override
    public List<Node> getNodesWithAttribute(String attrName) {
        return DomUtils.findAllByAttributeName(this.document, attrName);
    }
}

