/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.any23.util.StreamUtils;

public class FileUtils {
    public static File mv(File target, File dest) {
        if (!dest.isDirectory()) {
            throw new IllegalArgumentException("destination must be a directory.");
        }
        File newFile = new File(dest, target.getName());
        boolean success = target.renameTo(newFile);
        if (!success) {
            throw new IllegalStateException(String.format("Cannot move target file [%s] to destination [%s]", target, newFile));
        }
        return newFile;
    }

    public static void cp(InputStream is, File dest) {
        if (dest.exists()) {
            throw new IllegalArgumentException("Destination must not exist.");
        }
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int read;
            bis = new BufferedInputStream(is);
            FileOutputStream fos = new FileOutputStream(dest);
            bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[4096];
            while ((read = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Error while copying stream into file.", e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeGracefully(bis);
                StreamUtils.closeGracefully(bos);
                throw throwable;
            }
        }
        StreamUtils.closeGracefully(bis);
        StreamUtils.closeGracefully(bos);
    }

    public static void cp(File src, File dest) throws FileNotFoundException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(src);
            FileUtils.cp(fis, dest);
        }
        catch (Throwable throwable) {
            StreamUtils.closeGracefully(fis);
            throw throwable;
        }
        StreamUtils.closeGracefully(fis);
    }

    public static void dumpContent(File f, String content) throws IOException {
        FileWriter fw = new FileWriter(f);
        try {
            fw.write(content);
        }
        finally {
            StreamUtils.closeGracefully(fw);
        }
    }

    public static void dumpContent(File f, Throwable t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        t.printStackTrace(pw);
        pw.close();
        FileUtils.dumpContent(f, baos.toString());
    }

    public static String readResourceContent(Class clazz, String resource) throws IOException {
        return StreamUtils.asString(clazz.getResourceAsStream(resource));
    }

    public static String readResourceContent(String resource) throws IOException {
        return FileUtils.readResourceContent(FileUtils.class, resource);
    }

    public static String readFileContent(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        return StreamUtils.asString(fis, true);
    }

    public static String[] readFileLines(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        return StreamUtils.asLines(fis);
    }

    public static File[] listFilesRecursively(File dir, FilenameFilter filenameFilter) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " must be a directory.");
        }
        ArrayList<File> result = new ArrayList<File>();
        FileUtils.visitFilesRecursively(dir, filenameFilter, result);
        return result.toArray(new File[result.size()]);
    }

    private static void visitFilesRecursively(File dir, FilenameFilter filenameFilter, List<File> result) {
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) {
                if (filenameFilter != null && !filenameFilter.accept(dir, file.getName())) continue;
                result.add(file);
                continue;
            }
            FileUtils.visitFilesRecursively(file, filenameFilter, result);
        }
    }

    private FileUtils() {
    }
}

