/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.any23.util.StringUtils;

public class DiscoveryUtils {
    private static final String FILE_PREFIX = "file:";
    private static final String CLASS_SUFFIX = ".class";

    public static List<Class> getClassesInPackage(String packageName) {
        Enumeration<URL> resources;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        try {
            resources = classLoader.getResources(path);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error while retrieving internal resource path.", ioe);
        }
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            String fileNameDecoded;
            URL resource = resources.nextElement();
            String fileName = resource.getFile();
            try {
                fileNameDecoded = URLDecoder.decode(fileName, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalStateException("Error while decoding class file name.", uee);
            }
            dirs.add(new File(fileNameDecoded));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(DiscoveryUtils.findClasses(directory, packageName));
        }
        return classes;
    }

    public static List<Class> getClassesInPackage(String packageName, Class filter) {
        List<Class> classesInPackage = DiscoveryUtils.getClassesInPackage(packageName);
        ArrayList<Class> result = new ArrayList<Class>();
        for (Class clazz : classesInPackage) {
            Class superClazz;
            if (clazz.equals(filter) || ((superClazz = clazz.getSuperclass()) == null || !superClazz.equals(filter)) && !DiscoveryUtils.contains(clazz.getInterfaces(), filter)) continue;
            result.add(clazz);
        }
        return result;
    }

    private static List<Class> findClasses(File location, String packageName) {
        String locationPath = location.getPath();
        if (locationPath.indexOf(FILE_PREFIX) == 0) {
            return DiscoveryUtils.findClassesInJAR(locationPath);
        }
        return DiscoveryUtils.findClassesInDir(location, packageName);
    }

    private static List<Class> findClassesInJAR(String location) {
        String[] sections = location.split("!");
        if (sections.length != 2) {
            throw new IllegalArgumentException("Invalid JAR location.");
        }
        String jarLocation = sections[0].substring(FILE_PREFIX.length());
        String packagePath = sections[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarLocation);
            Enumeration<JarEntry> entries = jarFile.entries();
            ArrayList<Class> result = new ArrayList<Class>();
            while (entries.hasMoreElements()) {
                Class<?> clazz;
                JarEntry current = entries.nextElement();
                String entryName = current.getName();
                if (!StringUtils.isPrefix(packagePath, entryName) || !StringUtils.isSuffix(CLASS_SUFFIX, entryName) || entryName.contains("$")) continue;
                try {
                    String clazzName = entryName.substring(0, entryName.length() - CLASS_SUFFIX.length()).replaceAll("/", ".");
                    clazz = Class.forName(clazzName);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("Error while loading detected class.", cnfe);
                }
                result.add(clazz);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error while opening JAR file.", ioe);
        }
    }

    private static List<Class> findClassesInDir(File directory, String packageName) {
        File[] files;
        if (!directory.exists()) {
            return Collections.emptyList();
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File file : files = directory.listFiles()) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                assert (!fileName.contains("."));
                classes.addAll(DiscoveryUtils.findClassesInDir(file, packageName + "." + fileName));
                continue;
            }
            if (!fileName.endsWith(CLASS_SUFFIX) || fileName.contains("$")) continue;
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName(packageName + '.' + fileName.substring(0, fileName.length() - 6));
                }
                catch (ExceptionInInitializerError e) {
                    clazz = Class.forName(packageName + '.' + fileName.substring(0, fileName.length() - 6), false, Thread.currentThread().getContextClassLoader());
                }
                classes.add(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Error while loading detected class.", cnfe);
            }
        }
        return classes;
    }

    private static boolean contains(Object[] list, Object t) {
        for (Object o : list) {
            if (!o.equals(t)) continue;
            return true;
        }
        return false;
    }

    private DiscoveryUtils() {
    }
}

