/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.xpath;

import java.util.Map;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.xpath.TemplateGraph;
import org.apache.any23.extractor.xpath.TemplateObject;
import org.apache.any23.extractor.xpath.TemplatePredicate;
import org.apache.any23.extractor.xpath.TemplateSubject;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;

public class QuadTemplate {
    private final TemplateSubject subject;
    private final TemplatePredicate predicate;
    private final TemplateObject object;
    private final TemplateGraph graph;

    public QuadTemplate(TemplateSubject subject, TemplatePredicate predicate, TemplateObject object, TemplateGraph graph) {
        if (subject == null) {
            throw new NullPointerException("subject term cannot be null.");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate term cannot be null.");
        }
        if (object == null) {
            throw new NullPointerException("object term cannot be null.");
        }
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.graph = graph;
    }

    public QuadTemplate(TemplateSubject subject, TemplatePredicate predicate, TemplateObject object) {
        this(subject, predicate, object, null);
    }

    public TemplateSubject getSubject() {
        return this.subject;
    }

    public TemplatePredicate getPredicate() {
        return this.predicate;
    }

    public TemplateObject getObject() {
        return this.object;
    }

    public TemplateGraph getGraph() {
        return this.graph;
    }

    public void printOut(ExtractionResult er, Map<String, String> variableAssignment) {
        Resource s = (Resource)this.subject.getValue(variableAssignment);
        IRI p = (IRI)this.predicate.getValue(variableAssignment);
        Object o = this.object.getValue(variableAssignment);
        if (this.graph != null) {
            IRI g = (IRI)this.graph.getValue(variableAssignment);
            er.writeTriple(s, p, o, g);
        } else {
            er.writeTriple(s, p, o);
        }
    }

    public String toString() {
        return String.format("%s %s %s %s", this.subject, this.predicate, this.object, this.graph);
    }
}

