/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.rdfa;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.rdfa.RDFa11ParserException;
import org.apache.any23.rdf.RDFUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public class RDFa11Parser {
    private static final Logger logger = LoggerFactory.getLogger(RDFa11Parser.class);
    public static final String CURIE_SEPARATOR = ":";
    public static final char IRI_PREFIX_SEPARATOR = ':';
    public static final String IRI_SCHEMA_SEPARATOR = "://";
    public static final String IRI_PATH_SEPARATOR = "/";
    public static final String HEAD_TAG = "HEAD";
    public static final String BODY_TAG = "BODY";
    public static final String XMLNS_ATTRIBUTE = "xmlns";
    public static final String XML_LANG_ATTRIBUTE = "xml:lang";
    public static final String REL_ATTRIBUTE = "rel";
    public static final String REV_ATTRIBUTE = "rev";
    public static final String ABOUT_ATTRIBUTE = "about";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    public static final String SRC_ATTRIBUTE = "src";
    public static final String HREF_ATTRIBUTE = "href";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String ATTRIBUTE_CSS = "text/css";
    public static final String[] SUBJECT_ATTRIBUTES = new String[]{"about", "src", "resource", "href"};
    public static final String PREFIX_ATTRIBUTE = "prefix";
    public static final String TYPEOF_ATTRIBUTE = "typeof";
    public static final String PROPERTY_ATTRIBUTE = "property";
    public static final String DATATYPE_ATTRIBUTE = "datatype";
    public static final String CONTENT_ATTRIBUTE = "content";
    public static final String VOCAB_ATTRIBUTE = "vocab";
    public static final String PROFILE_ATTRIBUTE = "profile";
    public static final String XML_LITERAL_DATATYPE = "rdf:XMLLiteral";
    public static final String XMLNS_DEFAULT = "http://www.w3.org/1999/xhtml";
    private IssueReport issueReport;
    private URL documentBase;
    private final Stack<IRIMapping> IRIMappingStack = new Stack();
    private final Stack<Vocabulary> vocabularyStack = new Stack();
    private final List<IncompleteTriple> listOfIncompleteTriples = new ArrayList<IncompleteTriple>();
    private final Stack<EvaluationContext> evaluationContextStack = new Stack();

    protected static URL getDocumentBase(URL documentURL, Document document) throws MalformedURLException {
        String base = DomUtils.find(document, "/HTML/HEAD/BASE/@href");
        if (!"".equals(base)) {
            return new URL(base);
        }
        base = DomUtils.find(document, "//*/h:head/h:base[position()=1]/@href");
        if (!"".equals(base)) {
            return new URL(base);
        }
        return documentURL;
    }

    protected static String[] extractPrefixSections(String prefixesDeclaration) {
        String[] parts = prefixesDeclaration.split("\\s");
        ArrayList<String> out = new ArrayList<String>();
        int i = 0;
        while (i < parts.length) {
            String part = parts[i];
            if (part.length() == 0) {
                ++i;
                continue;
            }
            if (part.charAt(part.length() - 1) == ':') {
                ++i;
                while (i < parts.length && parts[i].length() == 0) {
                    ++i;
                }
                out.add(part + (i < parts.length ? parts[i] : ""));
                ++i;
                continue;
            }
            out.add(parts[i]);
            ++i;
        }
        return out.toArray(new String[out.size()]);
    }

    protected static boolean isAbsoluteIRI(String iri) {
        return iri.contains(IRI_SCHEMA_SEPARATOR);
    }

    protected static boolean isCURIE(String curie) {
        if (curie == null) {
            throw new NullPointerException("curie string cannot be null.");
        }
        if (curie.trim().length() == 0) {
            return false;
        }
        if (curie.charAt(0) != '[' || curie.charAt(curie.length() - 1) != ']') {
            return false;
        }
        int separatorIndex = curie.indexOf(CURIE_SEPARATOR);
        return separatorIndex > 0 && curie.indexOf(CURIE_SEPARATOR, separatorIndex + 1) == -1;
    }

    protected static boolean isCURIEBNode(String curie) {
        return RDFa11Parser.isCURIE(curie) && curie.substring(1, curie.length() - 1).split(CURIE_SEPARATOR)[0].equals("_");
    }

    protected static boolean isRelativeNode(Node node) {
        if (ATTRIBUTE_CSS.equals(DomUtils.readAttribute(node, TYPE_ATTRIBUTE))) {
            return false;
        }
        return DomUtils.hasAttribute(node, REL_ATTRIBUTE) || DomUtils.hasAttribute(node, REV_ATTRIBUTE);
    }

    protected static Literal getAsPlainLiteral(Node node, String currentLanguage) {
        String content = DomUtils.readAttribute(node, CONTENT_ATTRIBUTE, null);
        if (content != null) {
            return RDFUtils.literal(content, currentLanguage);
        }
        if (!node.hasChildNodes()) {
            return RDFUtils.literal("", currentLanguage);
        }
        String nodeTextContent = node.getTextContent();
        return nodeTextContent == null ? null : RDFUtils.literal(nodeTextContent.trim(), currentLanguage);
    }

    protected static Literal getAsXMLLiteral(Node node) throws IOException, TransformerException {
        String datatype = DomUtils.readAttribute(node, DATATYPE_ATTRIBUTE, null);
        if (!XML_LITERAL_DATATYPE.equals(datatype)) {
            return null;
        }
        String xmlSerializedNode = DomUtils.serializeToXML(node, false);
        return RDFUtils.literal(xmlSerializedNode, RDF.XMLLITERAL);
    }

    protected static boolean isXMLNSDeclared(Document document) {
        String attributeValue = document.getDocumentElement().getAttribute(XMLNS_ATTRIBUTE);
        if (attributeValue.length() == 0) {
            return false;
        }
        return XMLNS_DEFAULT.equals(attributeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocument(URL documentURL, Document document, ExtractionResult extractionResult) throws RDFa11ParserException {
        try {
            this.issueReport = extractionResult;
            if (!RDFa11Parser.isXMLNSDeclared(document)) {
                this.reportError(document.getDocumentElement(), String.format("The default %s namespace is expected to be declared and equal to '%s' .", XMLNS_ATTRIBUTE, XMLNS_DEFAULT));
            }
            try {
                this.documentBase = RDFa11Parser.getDocumentBase(documentURL, document);
            }
            catch (MalformedURLException murle) {
                throw new RDFa11ParserException("Invalid document base URL.", murle);
            }
            this.pushContext(document, new EvaluationContext(this.documentBase));
            this.depthFirstNode(document, extractionResult);
            assert (this.listOfIncompleteTriples.isEmpty()) : "The list of incomplete triples is expected to be empty at the end of processing.";
        }
        finally {
            this.reset();
        }
    }

    public void reset() {
        this.issueReport = null;
        this.documentBase = null;
        this.IRIMappingStack.clear();
        this.listOfIncompleteTriples.clear();
        this.evaluationContextStack.clear();
    }

    protected void updateVocabulary(Node currentNode) {
        String vocabularyStr = DomUtils.readAttribute(currentNode, VOCAB_ATTRIBUTE, null);
        if (vocabularyStr == null) {
            return;
        }
        try {
            this.pushVocabulary(currentNode, RDFUtils.iri(vocabularyStr));
        }
        catch (Exception e) {
            this.reportError(currentNode, String.format("Invalid vocabulary [%s], must be a IRI.", vocabularyStr));
        }
    }

    protected void updateIRIMapping(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (null == attributes) {
            return;
        }
        ArrayList<PrefixMap> prefixMapList = new ArrayList<PrefixMap>();
        String namespacePrefix = "xmlns:";
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node attribute = attributes.item(a);
            if (!attribute.getNodeName().startsWith("xmlns:")) continue;
            prefixMapList.add(new PrefixMap(attribute.getNodeName().substring("xmlns:".length()), this.resolveIRI(attribute.getNodeValue())));
        }
        this.extractPrefixes(node, prefixMapList);
        if (prefixMapList.size() == 0) {
            return;
        }
        this.pushMappings(node, prefixMapList);
    }

    protected IRI getMapping(String prefix) {
        for (IRIMapping IRIMapping2 : this.IRIMappingStack) {
            IRI mapping = IRIMapping2.map.get(prefix);
            if (mapping == null) continue;
            return mapping;
        }
        return null;
    }

    protected IRI[] resolveCIRIeOrIRIList(Node n, String curieOrIRIList, boolean termAllowed) throws URISyntaxException {
        if (curieOrIRIList == null || curieOrIRIList.trim().length() == 0) {
            return new IRI[0];
        }
        String[] curieOrIRIListParts = curieOrIRIList.split("\\s");
        ArrayList<IRI> result = new ArrayList<IRI>();
        for (String curieORIRIListPart : curieOrIRIListParts) {
            Resource curieOrIRI = this.resolveCURIEOrIRI(curieORIRIListPart, termAllowed);
            if (curieOrIRI != null && curieOrIRI instanceof IRI) {
                result.add((IRI)curieOrIRI);
                continue;
            }
            this.reportError(n, String.format("Invalid CURIE '%s' : expected IRI, found BNode.", curieORIRIListPart));
        }
        return result.toArray(new IRI[result.size()]);
    }

    protected IRI resolveIRI(String iriStr) {
        return RDFa11Parser.isAbsoluteIRI(iriStr) ? RDFUtils.iri(iriStr) : RDFUtils.iri(this.documentBase.toExternalForm(), iriStr);
    }

    protected Resource resolveCURIEOrIRI(String curieOrIRI, boolean termAllowed) {
        if (RDFa11Parser.isCURIE(curieOrIRI)) {
            return this.resolveNamespacedIRI(curieOrIRI.substring(1, curieOrIRI.length() - 1), ResolutionPolicy.NSRequired);
        }
        if (RDFa11Parser.isAbsoluteIRI(curieOrIRI)) {
            return this.resolveIRI(curieOrIRI);
        }
        return this.resolveNamespacedIRI(curieOrIRI, termAllowed ? ResolutionPolicy.TermAllowed : ResolutionPolicy.NSNotRequired);
    }

    private void pushContext(Node current, EvaluationContext ec) {
        ec.node = current;
        this.evaluationContextStack.push(ec);
    }

    private EvaluationContext getContext() {
        return this.evaluationContextStack.peek();
    }

    private void popContext(Node current) {
        Node peekNode = this.evaluationContextStack.peek().node;
        if (DomUtils.isAncestorOf(peekNode, current)) {
            this.evaluationContextStack.pop();
        }
    }

    private void pushVocabulary(Node currentNode, IRI vocab) {
        this.vocabularyStack.push(new Vocabulary(currentNode, vocab));
    }

    private IRI getVocabulary() {
        if (this.vocabularyStack.isEmpty()) {
            return null;
        }
        return this.vocabularyStack.peek().prefix;
    }

    private void popVocabulary(Node current) {
        if (this.vocabularyStack.isEmpty()) {
            return;
        }
        if (DomUtils.isAncestorOf(current, this.vocabularyStack.peek().originatingNode)) {
            this.vocabularyStack.pop();
        }
    }

    private void purgeIncompleteTriples(Node current) {
        ArrayList<IncompleteTriple> toBePurged = new ArrayList<IncompleteTriple>();
        for (IncompleteTriple incompleteTriple : this.listOfIncompleteTriples) {
            if (!DomUtils.isAncestorOf(current, incompleteTriple.originatingNode, true)) continue;
            toBePurged.add(incompleteTriple);
        }
        this.listOfIncompleteTriples.removeAll(toBePurged);
        toBePurged.clear();
    }

    private void reportError(Node n, String msg) {
        String errorMsg = String.format("Error while processing node [%s] : '%s'", DomUtils.getXPathForNode(n), msg);
        int[] errorLocation = DomUtils.getNodeLocation(n);
        this.issueReport.notifyIssue(IssueReport.IssueLevel.WARNING, errorMsg, errorLocation == null ? -1L : (long)errorLocation[0], errorLocation == null ? -1L : (long)errorLocation[1]);
    }

    private void depthFirstNode(Node node, ExtractionResult extractionResult) {
        try {
            this.processNode(node, extractionResult);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error while processing node.", (Throwable)e);
            }
            this.reportError(node, e.getMessage());
        }
        this.depthFirstChildren(node.getChildNodes(), extractionResult);
        this.purgeIncompleteTriples(node);
    }

    private void depthFirstChildren(NodeList nodeList, ExtractionResult extractionResult) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            this.depthFirstNode(child, extractionResult);
            this.popMappings(child);
            this.popVocabulary(child);
            this.popContext(child);
        }
    }

    private void writeTriple(Resource s, IRI p, Value o, ExtractionResult extractionResult) {
        assert (s != null) : "subject   is null.";
        assert (p != null) : "predicate is null.";
        assert (o != null) : "object    is null.";
        extractionResult.writeTriple(s, p, o);
    }

    private void processNode(Node currentElement, ExtractionResult extractionResult) throws Exception {
        EvaluationContext currentEvaluationContext = this.getContext();
        try {
            IRI[] types;
            if (currentElement.getNodeType() != 9 && currentElement.getNodeType() != 1) {
                return;
            }
            this.updateVocabulary(currentElement);
            this.updateIRIMapping(currentElement);
            this.updateLanguage(currentElement, currentEvaluationContext);
            if (!RDFa11Parser.isRelativeNode(currentElement)) {
                this.establishNewSubject(currentElement, currentEvaluationContext);
            } else {
                this.establishNewSubjectCurrentObjectResource(currentElement, currentEvaluationContext);
            }
            if (currentEvaluationContext.newSubject == null) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("newSubject: " + currentEvaluationContext.newSubject);
            }
            for (IRI type : types = this.getTypes(currentElement)) {
                this.writeTriple(currentEvaluationContext.newSubject, RDF.TYPE, (Value)type, extractionResult);
            }
            IRI[] rels = this.getRels(currentElement);
            IRI[] revs = this.getRevs(currentElement);
            if (currentEvaluationContext.currentObjectResource != null) {
                for (IRI rel : rels) {
                    this.writeTriple(currentEvaluationContext.newSubject, rel, (Value)currentEvaluationContext.currentObjectResource, extractionResult);
                }
                for (IRI rev : revs) {
                    this.writeTriple(currentEvaluationContext.currentObjectResource, rev, (Value)currentEvaluationContext.newSubject, extractionResult);
                }
            } else {
                for (IRI rel : rels) {
                    this.listOfIncompleteTriples.add(new IncompleteTriple(currentElement, currentEvaluationContext.newSubject, rel, IncompleteTripleDirection.Forward));
                }
                for (IRI rev : revs) {
                    this.listOfIncompleteTriples.add(new IncompleteTriple(currentElement, currentEvaluationContext.newSubject, rev, IncompleteTripleDirection.Reverse));
                }
            }
            Value currentObject = this.getCurrentObject(currentElement);
            IRI[] predicates = this.getPredicate(currentElement);
            if (currentObject != null && predicates != null) {
                for (IRI predicate : predicates) {
                    this.writeTriple(currentEvaluationContext.newSubject, predicate, currentObject, extractionResult);
                }
            }
            if (!currentEvaluationContext.skipElem && currentEvaluationContext.newSubject != null) {
                for (IncompleteTriple incompleteTriple : this.listOfIncompleteTriples) {
                    incompleteTriple.produceTriple(currentElement, currentEvaluationContext.newSubject, extractionResult);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (currentEvaluationContext.recourse) {
                EvaluationContext newEvaluationContext = new EvaluationContext(currentEvaluationContext.base);
                if (currentEvaluationContext.skipElem) {
                    newEvaluationContext.language = currentEvaluationContext.language;
                } else {
                    newEvaluationContext.base = currentEvaluationContext.base;
                    if (currentEvaluationContext.newSubject != null) {
                        newEvaluationContext.parentSubject = currentEvaluationContext.newSubject;
                    } else {
                        newEvaluationContext.parentSubject = currentEvaluationContext.parentSubject;
                    }
                    if (currentEvaluationContext.currentObjectResource != null) {
                        newEvaluationContext.parentObject = (Value)currentEvaluationContext.currentObjectResource;
                    } else if (currentEvaluationContext.newSubject != null) {
                        newEvaluationContext.parentObject = (Value)currentEvaluationContext.newSubject;
                    } else {
                        newEvaluationContext.parentObject = (Value)currentEvaluationContext.parentSubject;
                    }
                    newEvaluationContext.language = currentEvaluationContext.language;
                }
                this.pushContext(currentElement, newEvaluationContext);
            }
        }
    }

    private void extractPrefixes(Node node, List<PrefixMap> prefixMapList) {
        String[] prefixParts;
        String prefixAttribute = DomUtils.readAttribute(node, PREFIX_ATTRIBUTE, null);
        if (prefixAttribute == null) {
            return;
        }
        for (String prefixPart : prefixParts = RDFa11Parser.extractPrefixSections(prefixAttribute)) {
            IRI iri;
            int splitPoint = prefixPart.indexOf(58);
            String prefix = prefixPart.substring(0, splitPoint);
            if (prefix.length() == 0) {
                this.reportError(node, String.format("Invalid prefix length in prefix attribute '%s'", prefixAttribute));
                continue;
            }
            String iriStr = prefixPart.substring(splitPoint + 1);
            try {
                iri = this.resolveIRI(iriStr);
            }
            catch (Exception e) {
                this.reportError(node, String.format("Resolution of prefix '%s' defines an invalid IRI: '%s'", prefixAttribute, iriStr));
                continue;
            }
            prefixMapList.add(new PrefixMap(prefix, iri));
        }
    }

    private void updateLanguage(Node node, EvaluationContext currentEvaluationContext) {
        String candidateLanguage = DomUtils.readAttribute(node, XML_LANG_ATTRIBUTE, null);
        if (candidateLanguage != null) {
            currentEvaluationContext.language = candidateLanguage;
        }
    }

    private void establishNewSubject(Node node, EvaluationContext currentEvaluationContext) throws URISyntaxException {
        for (String subjectAttribute : SUBJECT_ATTRIBUTES) {
            String candidateIRIOrCURIE = DomUtils.readAttribute(node, subjectAttribute, null);
            if (candidateIRIOrCURIE == null) continue;
            currentEvaluationContext.newSubject = this.resolveCURIEOrIRI(candidateIRIOrCURIE, false);
            return;
        }
        if (node.getNodeName().equalsIgnoreCase(HEAD_TAG) || node.getNodeName().equalsIgnoreCase(BODY_TAG)) {
            currentEvaluationContext.newSubject = (Resource)this.resolveIRI(currentEvaluationContext.base.toString());
            return;
        }
        if (DomUtils.hasAttribute(node, TYPEOF_ATTRIBUTE)) {
            currentEvaluationContext.newSubject = (Resource)RDFUtils.bnode();
            return;
        }
        if (DomUtils.hasAttribute(node, PROPERTY_ATTRIBUTE)) {
            currentEvaluationContext.skipElem = true;
        }
        if (currentEvaluationContext.parentObject != null) {
            currentEvaluationContext.newSubject = (Resource)currentEvaluationContext.parentObject;
            return;
        }
        currentEvaluationContext.newSubject = null;
    }

    private void establishNewSubjectCurrentObjectResource(Node node, EvaluationContext currentEvaluationContext) throws URISyntaxException {
        String candidateIRIOrCURIE = DomUtils.readAttribute(node, ABOUT_ATTRIBUTE, null);
        if (candidateIRIOrCURIE != null) {
            currentEvaluationContext.newSubject = this.resolveCURIEOrIRI(candidateIRIOrCURIE, false);
        } else {
            candidateIRIOrCURIE = DomUtils.readAttribute(node, SRC_ATTRIBUTE, null);
            if (candidateIRIOrCURIE != null) {
                currentEvaluationContext.newSubject = (Resource)this.resolveIRI(candidateIRIOrCURIE);
            } else if (node.getNodeName().equalsIgnoreCase(HEAD_TAG) || node.getNodeName().equalsIgnoreCase(BODY_TAG)) {
                currentEvaluationContext.newSubject = (Resource)this.resolveIRI(currentEvaluationContext.base.toString());
            } else if (DomUtils.hasAttribute(node, TYPEOF_ATTRIBUTE)) {
                currentEvaluationContext.newSubject = (Resource)RDFUtils.bnode();
            } else if (currentEvaluationContext.parentObject != null) {
                currentEvaluationContext.newSubject = (Resource)currentEvaluationContext.parentObject;
            }
        }
        candidateIRIOrCURIE = DomUtils.readAttribute(node, RESOURCE_ATTRIBUTE, null);
        if (candidateIRIOrCURIE != null) {
            currentEvaluationContext.currentObjectResource = this.resolveCURIEOrIRI(candidateIRIOrCURIE, false);
            return;
        }
        candidateIRIOrCURIE = DomUtils.readAttribute(node, HREF_ATTRIBUTE, null);
        if (candidateIRIOrCURIE != null) {
            currentEvaluationContext.currentObjectResource = (Resource)this.resolveIRI(candidateIRIOrCURIE);
            return;
        }
        currentEvaluationContext.currentObjectResource = null;
    }

    private IRI[] getTypes(Node node) throws URISyntaxException {
        String typeOf = DomUtils.readAttribute(node, TYPEOF_ATTRIBUTE, null);
        return this.resolveCIRIeOrIRIList(node, typeOf, true);
    }

    private IRI[] getRels(Node node) throws URISyntaxException {
        String rel = DomUtils.readAttribute(node, REL_ATTRIBUTE, null);
        return this.resolveCIRIeOrIRIList(node, rel, true);
    }

    private IRI[] getRevs(Node node) throws URISyntaxException {
        String rev = DomUtils.readAttribute(node, REV_ATTRIBUTE, null);
        return this.resolveCIRIeOrIRIList(node, rev, true);
    }

    private IRI[] getPredicate(Node node) throws URISyntaxException {
        String candidateIRI = DomUtils.readAttribute(node, PROPERTY_ATTRIBUTE, null);
        if (candidateIRI == null) {
            return null;
        }
        return this.resolveCIRIeOrIRIList(node, candidateIRI, true);
    }

    private Value getCurrentObject(Node node) throws URISyntaxException, IOException, TransformerException {
        String candidateObject = DomUtils.readAttribute(node, HREF_ATTRIBUTE, null);
        if (candidateObject != null) {
            return this.resolveIRI(candidateObject);
        }
        return this.gerCurrentObjectLiteral(node);
    }

    private Literal gerCurrentObjectLiteral(Node node) throws URISyntaxException, IOException, TransformerException {
        EvaluationContext currentEvaluationContext = this.getContext();
        Literal literal = this.getAsTypedLiteral(node);
        if (literal != null) {
            return literal;
        }
        literal = RDFa11Parser.getAsXMLLiteral(node);
        if (literal != null) {
            currentEvaluationContext.recourse = false;
            return literal;
        }
        literal = RDFa11Parser.getAsPlainLiteral(node, currentEvaluationContext.language);
        if (literal != null) {
            return literal;
        }
        return null;
    }

    private static String getNodeContent(Node node) {
        String candidateContent = DomUtils.readAttribute(node, CONTENT_ATTRIBUTE, null);
        if (candidateContent != null) {
            return candidateContent;
        }
        return node.getTextContent();
    }

    private Literal getAsTypedLiteral(Node node) throws URISyntaxException {
        String datatype = DomUtils.readAttribute(node, DATATYPE_ATTRIBUTE, null);
        if (datatype == null || datatype.trim().length() == 0 || XML_LITERAL_DATATYPE.equals(datatype.trim())) {
            return null;
        }
        Resource curieOrIRI = this.resolveCURIEOrIRI(datatype, true);
        return RDFUtils.literal(RDFa11Parser.getNodeContent(node), curieOrIRI instanceof IRI ? (IRI)curieOrIRI : null);
    }

    private void pushMappings(Node sourceNode, List<PrefixMap> prefixMapList) {
        HashMap<String, IRI> mapping = new HashMap<String, IRI>();
        for (PrefixMap prefixMap : prefixMapList) {
            mapping.put(prefixMap.prefix, prefixMap.IRI);
        }
        this.IRIMappingStack.push(new IRIMapping(sourceNode, mapping));
    }

    private void popMappings(Node node) {
        if (this.IRIMappingStack.isEmpty()) {
            return;
        }
        IRIMapping peek = this.IRIMappingStack.peek();
        if (!DomUtils.isAncestorOf(peek.sourceNode, node)) {
            this.IRIMappingStack.pop();
        }
    }

    private Resource resolveNamespacedIRI(String mapping, ResolutionPolicy resolutionPolicy) {
        URI candidateCURIE;
        int prefixSeparatorIndex;
        if (mapping.indexOf(IRI_PATH_SEPARATOR) == 0) {
            mapping = mapping.substring(1);
        }
        if ((prefixSeparatorIndex = mapping.indexOf(58)) == -1) {
            IRI currentVocabulary;
            if (resolutionPolicy == ResolutionPolicy.NSRequired) {
                throw new IllegalArgumentException(String.format("Invalid mapping string [%s], must declare a prefix.", mapping));
            }
            if (resolutionPolicy == ResolutionPolicy.TermAllowed && (currentVocabulary = this.getVocabulary()) != null) {
                return this.resolveIRI(currentVocabulary.toString() + mapping);
            }
            return this.resolveIRI(this.documentBase.toString() + mapping);
        }
        String prefix = mapping.substring(0, prefixSeparatorIndex);
        IRI curieMapping = this.getMapping(prefix);
        if (curieMapping == null) {
            throw new IllegalArgumentException(String.format("Cannot map prefix '%s'", prefix));
        }
        String candidateCURIEStr = curieMapping.toString() + mapping.substring(prefixSeparatorIndex + 1);
        try {
            candidateCURIE = new URI(candidateCURIEStr);
        }
        catch (URISyntaxException IRIse) {
            throw new IllegalArgumentException(String.format("Invalid CURIE '%s'", candidateCURIEStr));
        }
        return this.resolveIRI(candidateCURIE.isAbsolute() ? candidateCURIE.toString() : this.documentBase.toString() + candidateCURIE.toString());
    }

    private class Vocabulary {
        final Node originatingNode;
        final IRI prefix;

        public Vocabulary(Node originatingNode, IRI prefix) {
            this.originatingNode = originatingNode;
            this.prefix = prefix;
        }
    }

    private class IncompleteTriple {
        final Node originatingNode;
        final Resource subject;
        final IRI predicate;
        final IncompleteTripleDirection direction;

        public IncompleteTriple(Node originatingNode, Resource subject, IRI predicate, IncompleteTripleDirection direction) {
            if (originatingNode == null || subject == null || predicate == null || direction == null) {
                throw new IllegalArgumentException();
            }
            this.originatingNode = originatingNode;
            this.subject = subject;
            this.predicate = predicate;
            this.direction = direction;
        }

        public boolean produceTriple(Node resourceNode, Resource r, ExtractionResult extractionResult) {
            if (!DomUtils.isAncestorOf(this.originatingNode, resourceNode, true)) {
                return false;
            }
            if (r == null) {
                throw new IllegalArgumentException();
            }
            switch (this.direction) {
                case Forward: {
                    extractionResult.writeTriple(this.subject, this.predicate, (Value)r);
                    break;
                }
                case Reverse: {
                    extractionResult.writeTriple(r, this.predicate, (Value)this.subject);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return true;
        }
    }

    private static enum IncompleteTripleDirection {
        Forward,
        Reverse;

    }

    private class IRIMapping {
        final Node sourceNode;
        final Map<String, IRI> map;

        public IRIMapping(Node sourceNode, Map<String, IRI> map) {
            this.sourceNode = sourceNode;
            this.map = map;
        }
    }

    private class PrefixMap {
        final String prefix;
        final IRI IRI;

        public PrefixMap(String prefix, IRI IRI2) {
            this.prefix = prefix;
            this.IRI = IRI2;
        }
    }

    private class EvaluationContext {
        private Node node;
        private URL base;
        private Resource parentSubject;
        private Value parentObject;
        private String language;
        private boolean recourse;
        private boolean skipElem;
        private Resource newSubject;
        private Resource currentObjectResource;

        EvaluationContext(URL base) {
            this.base = base;
            this.parentSubject = RDFa11Parser.this.resolveIRI(base.toExternalForm());
            this.parentObject = null;
            this.language = null;
            this.recourse = true;
            this.skipElem = false;
            this.newSubject = null;
            this.currentObjectResource = null;
        }
    }

    static enum ResolutionPolicy {
        NSNotRequired,
        NSRequired,
        TermAllowed;

    }
}

