/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.rdf;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.github.jsonldjava.utils.JsonUtils;
import java.lang.reflect.Field;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.rdf.BaseRDFExtractor;
import org.apache.any23.extractor.rdf.JSONLDExtractorFactory;
import org.apache.any23.extractor.rdf.RDFParserFactory;
import org.eclipse.rdf4j.rio.RDFParser;

public class JSONLDExtractor
extends BaseRDFExtractor {
    public JSONLDExtractor(boolean verifyDataType, boolean stopAtFirstError) {
        super(verifyDataType, stopAtFirstError);
    }

    public JSONLDExtractor() {
        this(false, false);
    }

    public ExtractorDescription getDescription() {
        return JSONLDExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected RDFParser getParser(ExtractionContext extractionContext, ExtractionResult extractionResult) {
        return RDFParserFactory.getInstance().getJSONLDParser(this.isVerifyDataType(), this.isStopAtFirstError(), extractionContext, extractionResult);
    }

    static {
        JsonFactory JSON_FACTORY;
        try {
            if ("JSONLD-Java" instanceof Void) {
                throw new Error("This error will never be thrown.");
            }
        }
        catch (NoSuchFieldError th) {
            throw new AssertionError("You have an outdated version of jsonld-java on the classpath. Upgrade to at least version 0.12.0. See: https://issues.apache.org/jira/browse/ANY23-336", th);
        }
        try {
            Field field = JsonUtils.class.getDeclaredField("JSON_FACTORY");
            field.setAccessible(true);
            JSON_FACTORY = (JsonFactory)field.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        JSON_FACTORY.disable(JsonParser.Feature.ALLOW_COMMENTS);
        JSON_FACTORY.disable(JsonParser.Feature.ALLOW_MISSING_VALUES);
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS);
        JSON_FACTORY.disable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        JSON_FACTORY.disable(JsonParser.Feature.ALLOW_TRAILING_COMMA);
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
        JSON_FACTORY.disable(JsonParser.Feature.ALLOW_YAML_COMMENTS);
        JSON_FACTORY.enable(JsonParser.Feature.IGNORE_UNDEFINED);
        JSON_FACTORY.enable(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION);
        JSON_FACTORY.disable(JsonParser.Feature.STRICT_DUPLICATE_DETECTION);
    }
}

