/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.microdata;

import org.apache.any23.extractor.html.DomUtils;
import org.w3c.dom.Node;

public class MicrodataParserException
extends Exception {
    private String errorPath;
    private int[] errorLocation;

    public MicrodataParserException(String message, Node errorNode) {
        super(message);
        this.setErrorNode(errorNode);
    }

    public MicrodataParserException(String message, Throwable cause, Node errorNode) {
        super(message, cause);
        this.setErrorNode(errorNode);
    }

    public String getErrorPath() {
        return this.errorPath;
    }

    public int getErrorLocationBeginRow() {
        return this.errorLocation == null ? -1 : this.errorLocation[0];
    }

    public int getErrorLocationBeginCol() {
        return this.errorLocation == null ? -1 : this.errorLocation[1];
    }

    public int getErrorLocationEndRow() {
        return this.errorLocation == null ? -1 : this.errorLocation[2];
    }

    public int getErrorLocationEndCol() {
        return this.errorLocation == null ? -1 : this.errorLocation[3];
    }

    public String toJSON() {
        return String.format("{ \"message\" : \"%s\", \"path\" : \"%s\", \"begin_row\" : %d, \"begin_col\" : %d, \"end_row\" : %d, \"end_col\" : %d }", this.getMessage().replaceAll("\"", ""), this.getErrorPath(), this.getErrorLocationBeginRow(), this.getErrorLocationBeginCol(), this.getErrorLocationEndRow(), this.getErrorLocationEndCol());
    }

    @Override
    public String toString() {
        return this.toJSON();
    }

    protected void setErrorNode(Node n) {
        if (n == null) {
            this.errorPath = null;
            this.errorLocation = null;
            return;
        }
        this.errorPath = DomUtils.getXPathForNode(n);
        this.errorLocation = DomUtils.getNodeLocation(n);
    }
}

