/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.microdata;

import org.apache.any23.extractor.microdata.Item;
import org.apache.any23.extractor.microdata.ItemPropValue;

public class ItemProp
extends Item {
    private final String name;
    private final ItemPropValue value;
    final boolean reverse;

    public ItemProp(String xpath, String name, ItemPropValue value) {
        this(xpath, name, value, false);
    }

    ItemProp(String xpath, String name, ItemPropValue value, boolean reverse) {
        super(xpath);
        if (name == null) {
            throw new NullPointerException("name cannot be null.");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("invalid property name '" + name + "'");
        }
        if (value == null) {
            throw new NullPointerException("value cannot be null.");
        }
        this.name = name;
        this.value = value;
        this.reverse = reverse;
    }

    public String getName() {
        return this.name;
    }

    public ItemPropValue getValue() {
        return this.value;
    }

    @Override
    public String toJSON() {
        return String.format("{ \"xpath\" : \"%s\", \"name\" : \"%s\", \"value\" : %s }", this.getXpath(), this.name, this.value.toJSON());
    }

    public String toString() {
        return this.toJSON();
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() * this.value.hashCode() * 3;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemProp) {
            ItemProp other = (ItemProp)obj;
            return this.name.equals(other.name) && this.value.equals(other.value);
        }
        return false;
    }
}

