/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html.microformats2;

import java.util.List;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.microformats2.HCardExtractorFactory;
import org.apache.any23.vocab.HCard;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HCardExtractor
extends EntityBasedMicroformatExtractor {
    private static final HCard vCARD = HCard.getInstance();
    private static final String[] cardFields = new String[]{"name", "honorific-prefix", "given-name", "additional-name", "family-name", "sort-string", "honorific-suffix", "nickname", "email", "logo", "photo", "url", "uid", "category", "tel", "note", "bday", "key", "org", "job-title", "role", "impp", "sex", "gender-identity", "anniversary", "adr", "geo"};
    private static final String[] addressFields = new String[]{"street-address", "extended-address", "locality", "region", "postal-code", "country-name", "geo"};
    private static final String[] geoFields = new String[]{"latitude", "longitude", "altitude"};

    @Override
    public ExtractorDescription getDescription() {
        return HCardExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "h-card";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        BNode card = this.getBlankNodeFor(node);
        this.conditionallyAddResourceProperty((Resource)card, RDF.TYPE, HCardExtractor.vCARD.Card);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addName(fragment, card);
        this.addHonorificPrefix(fragment, card);
        this.addGivenName(fragment, card);
        this.addAdditionalName(fragment, card);
        this.addFamilyName(fragment, card);
        this.addSortString(fragment, card);
        this.addHonorificSuffix(fragment, card);
        this.addNickname(fragment, card);
        this.addEmails(fragment, card);
        this.addLogo(fragment, card);
        this.addPhoto(fragment, card);
        this.addURLs(fragment, card);
        this.addUID(fragment, card);
        this.addCategories(fragment, card);
        this.addTelephones(fragment, card);
        this.addNotes(fragment, card);
        this.addBday(fragment, card);
        this.addKey(fragment, card);
        this.addOrg(fragment, card);
        this.addJobTitle(fragment, card);
        this.addRole(fragment, card);
        this.addImpp(fragment, card);
        this.addSex(fragment, card);
        this.addGenderIdentity(fragment, card);
        this.addAnniversary(fragment, card);
        this.addGeo(fragment, (Resource)card);
        this.addAdr(fragment, (Resource)card);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)out;
        tser.addResourceRoot(DomUtils.getXPathListForNode(node), (Resource)card, this.getClass());
        return true;
    }

    public Resource extractEntityAsEmbeddedProperty(HTMLDocument fragment, BNode card, ExtractionResult out) throws ExtractionException {
        this.setCurrentExtractionResult(out);
        this.addName(fragment, card);
        this.addHonorificPrefix(fragment, card);
        this.addGivenName(fragment, card);
        this.addAdditionalName(fragment, card);
        this.addFamilyName(fragment, card);
        this.addSortString(fragment, card);
        this.addHonorificSuffix(fragment, card);
        this.addNickname(fragment, card);
        this.addEmails(fragment, card);
        this.addLogo(fragment, card);
        this.addPhoto(fragment, card);
        this.addURLs(fragment, card);
        this.addUID(fragment, card);
        this.addCategories(fragment, card);
        this.addTelephones(fragment, card);
        this.addNotes(fragment, card);
        this.addBday(fragment, card);
        this.addKey(fragment, card);
        this.addOrg(fragment, card);
        this.addJobTitle(fragment, card);
        this.addRole(fragment, card);
        this.addImpp(fragment, card);
        this.addSex(fragment, card);
        this.addGenderIdentity(fragment, card);
        this.addAnniversary(fragment, card);
        this.addGeo(fragment, (Resource)card);
        this.addAdr(fragment, (Resource)card);
        return card;
    }

    private void mapFieldWithProperty(HTMLDocument fragment, BNode card, String fieldClass, IRI property) {
        HTMLDocument.TextField title = fragment.getSingularTextField(fieldClass);
        this.conditionallyAddStringProperty(title.source(), (Resource)card, property, title.value());
    }

    private void addName(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[0], HCardExtractor.vCARD.name);
    }

    private void addHonorificPrefix(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[1], HCardExtractor.vCARD.honorific_prefix);
    }

    private void addGivenName(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[2], HCardExtractor.vCARD.given_name);
    }

    private void addAdditionalName(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[3], HCardExtractor.vCARD.additional_name);
    }

    private void addFamilyName(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[4], HCardExtractor.vCARD.family_name);
    }

    private void addSortString(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[5], HCardExtractor.vCARD.sort_string);
    }

    private void addHonorificSuffix(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[6], HCardExtractor.vCARD.honorific_suffix);
    }

    private void addNickname(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[7], HCardExtractor.vCARD.nickname);
    }

    private void addEmails(HTMLDocument fragment, BNode card) throws ExtractionException {
        HTMLDocument.TextField[] emails;
        for (HTMLDocument.TextField email : emails = fragment.getPluralUrlField("u-" + cardFields[8])) {
            this.addIRIProperty((Resource)card, HCardExtractor.vCARD.email, fragment.resolveIRI(email.value()));
        }
    }

    private void addLogo(HTMLDocument fragment, BNode card) throws ExtractionException {
        HTMLDocument.TextField logo = fragment.getSingularUrlField("u-" + cardFields[9]);
        if (logo.source() == null) {
            return;
        }
        this.addIRIProperty((Resource)card, HCardExtractor.vCARD.logo, fragment.resolveIRI(logo.value()));
    }

    private void addPhoto(HTMLDocument fragment, BNode card) throws ExtractionException {
        HTMLDocument.TextField photo = fragment.getSingularUrlField("u-" + cardFields[10]);
        if (photo.source() == null) {
            return;
        }
        this.addIRIProperty((Resource)card, HCardExtractor.vCARD.photo, fragment.resolveIRI(photo.value()));
    }

    private void addURLs(HTMLDocument fragment, BNode card) throws ExtractionException {
        HTMLDocument.TextField[] urls;
        for (HTMLDocument.TextField url : urls = fragment.getPluralUrlField("u-" + cardFields[11])) {
            this.addIRIProperty((Resource)card, HCardExtractor.vCARD.url, fragment.resolveIRI(url.value()));
        }
    }

    private void addUID(HTMLDocument fragment, BNode card) throws ExtractionException {
        HTMLDocument.TextField uid = fragment.getSingularUrlField("u-" + cardFields[12]);
        if (uid.source() == null) {
            return;
        }
        this.addIRIProperty((Resource)card, HCardExtractor.vCARD.uid, fragment.resolveIRI(uid.value()));
    }

    private void addCategories(HTMLDocument fragment, BNode entry) {
        HTMLDocument.TextField[] categories;
        for (HTMLDocument.TextField category : categories = fragment.getPluralTextField("p-" + cardFields[13])) {
            this.conditionallyAddStringProperty(category.source(), (Resource)entry, HCardExtractor.vCARD.category, category.value());
        }
    }

    private void addTelephones(HTMLDocument fragment, BNode card) {
        HTMLDocument.TextField[] telephones;
        for (HTMLDocument.TextField tel : telephones = fragment.getPluralTextField("p-" + cardFields[14])) {
            Node attribute = tel.source().getAttributes().getNamedItem("value");
            if (attribute == null) {
                this.conditionallyAddStringProperty(tel.source(), (Resource)card, HCardExtractor.vCARD.tel, tel.value());
                continue;
            }
            this.conditionallyAddStringProperty(tel.source(), (Resource)card, HCardExtractor.vCARD.tel, attribute.getNodeValue());
        }
    }

    private void addNotes(HTMLDocument fragment, BNode entry) {
        HTMLDocument.TextField[] categories;
        for (HTMLDocument.TextField category : categories = fragment.getPluralTextField("p-" + cardFields[15])) {
            this.conditionallyAddStringProperty(category.source(), (Resource)entry, HCardExtractor.vCARD.note, category.value());
        }
    }

    private void addBday(HTMLDocument fragment, BNode card) {
        HTMLDocument.TextField bday = fragment.getSingularTextField("dt-" + cardFields[16]);
        if (bday.source() == null) {
            return;
        }
        Node attribute = bday.source().getAttributes().getNamedItem("datetime");
        if (attribute == null) {
            this.conditionallyAddStringProperty(bday.source(), (Resource)card, HCardExtractor.vCARD.bday, bday.value());
        } else {
            this.conditionallyAddStringProperty(bday.source(), (Resource)card, HCardExtractor.vCARD.bday, attribute.getNodeValue());
        }
    }

    private void addKey(HTMLDocument fragment, BNode card) throws ExtractionException {
        HTMLDocument.TextField uid = fragment.getSingularTextField("u-" + cardFields[17]);
        if (uid.source() == null) {
            return;
        }
        this.addIRIProperty((Resource)card, HCardExtractor.vCARD.key, fragment.resolveIRI(uid.value()));
    }

    private void addOrg(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[18], HCardExtractor.vCARD.org);
    }

    private void addJobTitle(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[19], HCardExtractor.vCARD.job_title);
    }

    private void addRole(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[20], HCardExtractor.vCARD.role);
    }

    private void addImpp(HTMLDocument fragment, BNode card) throws ExtractionException {
        HTMLDocument.TextField impp = fragment.getSingularTextField("u-" + cardFields[21]);
        if (impp.source() == null) {
            return;
        }
        this.addIRIProperty((Resource)card, HCardExtractor.vCARD.impp, fragment.resolveIRI(impp.value()));
    }

    private void addSex(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[22], HCardExtractor.vCARD.sex);
    }

    private void addGenderIdentity(HTMLDocument fragment, BNode card) {
        this.mapFieldWithProperty(fragment, card, "p-" + cardFields[23], HCardExtractor.vCARD.gender_identity);
    }

    private void addAnniversary(HTMLDocument fragment, BNode card) {
        HTMLDocument.TextField anniversary = fragment.getSingularTextField("dt-" + cardFields[24]);
        if (anniversary.source() == null) {
            return;
        }
        Node attribute = anniversary.source().getAttributes().getNamedItem("datetime");
        if (attribute == null) {
            this.conditionallyAddStringProperty(anniversary.source(), (Resource)card, HCardExtractor.vCARD.bday, anniversary.value());
        } else {
            this.conditionallyAddStringProperty(anniversary.source(), (Resource)card, HCardExtractor.vCARD.bday, attribute.getNodeValue());
        }
    }

    private void addAdr(HTMLDocument doc, Resource card) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + cardFields[25] + " " + "h-" + cardFields[25]);
        if (nodes.isEmpty()) {
            return;
        }
        for (Node node : nodes) {
            BNode location = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)location, RDF.TYPE, HCardExtractor.vCARD.Address);
            HTMLDocument fragment = new HTMLDocument(node);
            for (String field : addressFields) {
                HTMLDocument.TextField[] values;
                for (HTMLDocument.TextField val : values = fragment.getPluralTextField("p-" + field)) {
                    if (!field.equals("geo")) {
                        this.conditionallyAddStringProperty(val.source(), (Resource)location, vCARD.getProperty(field), val.value());
                        continue;
                    }
                    this.addGeo(new HTMLDocument(node), card);
                }
            }
        }
    }

    private void addGeo(HTMLDocument doc, Resource card) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + cardFields[26] + " " + "h-" + cardFields[26]);
        if (nodes.isEmpty()) {
            return;
        }
        for (Node node : nodes) {
            BNode location = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)location, RDF.TYPE, HCardExtractor.vCARD.Geo);
            HTMLDocument fragment = new HTMLDocument(node);
            for (String field : geoFields) {
                HTMLDocument.TextField[] values;
                for (HTMLDocument.TextField val : values = fragment.getPluralTextField("p-" + field)) {
                    Node attribute = val.source().getAttributes().getNamedItem("title");
                    if (attribute == null) {
                        this.conditionallyAddStringProperty(val.source(), (Resource)location, vCARD.getProperty(field), val.value());
                        continue;
                    }
                    this.conditionallyAddStringProperty(val.source(), (Resource)location, vCARD.getProperty(field), attribute.getNodeValue());
                }
            }
        }
    }
}

