/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.TitleExtractorFactory;
import org.apache.any23.rdf.Any23ValueFactoryWrapper;
import org.apache.any23.vocab.DCTerms;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.w3c.dom.Document;

public class TitleExtractor
implements Extractor.TagSoupDOMExtractor {
    private static final DCTerms vDCTERMS = DCTerms.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, Document in, ExtractionResult out) throws IOException, ExtractionException {
        Any23ValueFactoryWrapper valueFactory = new Any23ValueFactoryWrapper((ValueFactory)SimpleValueFactory.getInstance(), (IssueReport)out, extractionContext.getDefaultLanguage());
        try {
            String title = DomUtils.find(in, "/HTML/HEAD/TITLE/text()").trim();
            if (title != null && title.length() != 0) {
                out.writeTriple((Resource)extractionContext.getDocumentIRI(), TitleExtractor.vDCTERMS.title, (Value)valueFactory.createLiteral(title));
            }
        }
        finally {
            valueFactory.setIssueReport(null);
        }
    }

    public ExtractorDescription getDescription() {
        return TitleExtractorFactory.getDescriptionInstance();
    }
}

