/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.any23.extractor.html.DocumentReport;
import org.apache.any23.extractor.html.TagSoupParsingConfiguration;
import org.apache.any23.validator.DefaultValidator;
import org.apache.any23.validator.ValidatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class TagSoupParser {
    public static final String ELEMENT_LOCATION = "Element-Location";
    private static final Logger logger = LoggerFactory.getLogger(TagSoupParser.class);
    private final InputStream input;
    private final String documentIRI;
    private final String encoding;
    private final TagSoupParsingConfiguration config;
    private Document result = null;

    public TagSoupParser(InputStream input, String documentIRI) {
        this.input = input;
        this.documentIRI = documentIRI;
        this.encoding = null;
        this.config = TagSoupParsingConfiguration.getDefault();
    }

    public TagSoupParser(InputStream input, String documentIRI, String encoding) {
        if (encoding != null && !Charset.isSupported(encoding)) {
            throw new UnsupportedCharsetException(String.format("Charset %s is not supported", encoding));
        }
        this.input = input;
        this.documentIRI = documentIRI;
        this.encoding = encoding;
        this.config = TagSoupParsingConfiguration.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDOM() throws IOException {
        if (this.result == null) {
            long startTime = System.currentTimeMillis();
            try {
                this.result = this.config.parse(this.input, this.documentIRI, this.encoding);
            }
            finally {
                long elapsed = System.currentTimeMillis() - startTime;
                logger.debug("Parsed " + this.documentIRI + " with " + this.config.name() + ", " + elapsed + "ms");
            }
        }
        this.result.setDocumentURI(this.documentIRI);
        return this.result;
    }

    public DocumentReport getValidatedDOM(boolean applyFix) throws IOException, ValidatorException {
        URI dIRI;
        try {
            dIRI = new URI(this.documentIRI);
        }
        catch (IllegalArgumentException | URISyntaxException urise) {
            throw new ValidatorException("Error while performing validation, invalid document IRI.", urise);
        }
        DefaultValidator validator = new DefaultValidator();
        Document document = this.getDOM();
        return new DocumentReport(validator.validate(dIRI, document, applyFix), document);
    }

    public static class ElementLocation {
        private int beginLineNumber;
        private int beginColumnNumber;
        private int endLineNumber;
        private int endColumnNumber;

        private ElementLocation(int beginLineNumber, int beginColumnNumber, int endLineNumber, int endColumnNumber) {
            this.beginLineNumber = beginLineNumber;
            this.beginColumnNumber = beginColumnNumber;
            this.endLineNumber = endLineNumber;
            this.endColumnNumber = endColumnNumber;
        }

        public int getBeginLineNumber() {
            return this.beginLineNumber;
        }

        public int getBeginColumnNumber() {
            return this.beginColumnNumber;
        }

        public int getEndLineNumber() {
            return this.endLineNumber;
        }

        public int getEndColumnNumber() {
            return this.endColumnNumber;
        }
    }
}

