/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.LicenseExtractorFactory;
import org.apache.any23.vocab.XHTML;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LicenseExtractor
implements Extractor.TagSoupDOMExtractor {
    private static final XHTML vXHTML = XHTML.getInstance();

    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, Document in, ExtractionResult out) throws IOException, ExtractionException {
        HTMLDocument document = new HTMLDocument(in);
        IRI documentIRI = extractionContext.getDocumentIRI();
        for (Node node : DomUtils.findAll(in, "//A[@rel='license']/@href")) {
            String link = node.getNodeValue();
            if ("".equals(link)) {
                out.notifyIssue(IssueReport.IssueLevel.WARNING, String.format("Invalid license link detected within document %s.", documentIRI.toString()), 0L, 0L);
                continue;
            }
            out.writeTriple((Resource)documentIRI, LicenseExtractor.vXHTML.license, (Value)document.resolveIRI(link));
        }
    }

    public ExtractorDescription getDescription() {
        return LicenseExtractorFactory.getDescriptionInstance();
    }
}

