/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.text.ParseException;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.HCalendarExtractorFactory;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.MicroformatExtractor;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.vocab.ICAL;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HCalendarExtractor
extends MicroformatExtractor {
    private static final ICAL vICAL = ICAL.getInstance();
    private static final String[] Components = new String[]{"Vevent", "Vtodo", "Vjournal", "Vfreebusy"};
    private static final String DATE_FORMAT = "yyyyMMdd'T'HHmm'Z'";
    private String[] textSingularProps = new String[]{"summary", "class", "transp", "description", "status", "location"};
    private String[] textDateProps = new String[]{"dtstart", "dtstamp", "dtend"};

    @Override
    public ExtractorDescription getDescription() {
        return HCalendarExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected boolean extract() throws ExtractionException {
        HTMLDocument document = this.getHTMLDocument();
        List<Node> calendars = document.findAllByClassName("vcalendar");
        if (calendars.size() == 0 && document.findAllByClassName("vevent").size() > 0) {
            calendars.add(document.getDocument());
        }
        boolean foundAny = false;
        for (Node node : calendars) {
            foundAny |= this.extractCalendar(node);
        }
        return foundAny;
    }

    private boolean extractCalendar(Node node) throws ExtractionException {
        IRI cal = this.getDocumentIRI();
        this.addIRIProperty((Resource)cal, RDF.TYPE, HCalendarExtractor.vICAL.Vcalendar);
        return this.addComponents(node, (Resource)cal);
    }

    private boolean addComponents(Node node, Resource cal) throws ExtractionException {
        boolean foundAny = false;
        for (String component : Components) {
            List<Node> events = DomUtils.findAllByClassName(node, component);
            if (events.size() == 0) continue;
            for (Node evtNode : events) {
                foundAny |= this.extractComponent(evtNode, cal, component);
            }
        }
        return foundAny;
    }

    private boolean extractComponent(Node node, Resource cal, String component) throws ExtractionException {
        HTMLDocument compoNode = new HTMLDocument(node);
        BNode evt = this.valueFactory.createBNode();
        this.addIRIProperty((Resource)evt, RDF.TYPE, vICAL.getClass(component));
        this.addTextProps(compoNode, (Resource)evt);
        this.addUrl(compoNode, (Resource)evt);
        this.addRRule(compoNode, (Resource)evt);
        this.addOrganizer(compoNode, (Resource)evt);
        this.addUid(compoNode, (Resource)evt);
        this.addBNodeProperty(cal, HCalendarExtractor.vICAL.component, evt);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)this.getCurrentExtractionResult();
        tser.addResourceRoot(compoNode.getPathToLocalRoot(), (Resource)evt, this.getClass());
        return true;
    }

    private void addUid(HTMLDocument compoNode, Resource evt) {
        HTMLDocument.TextField url = compoNode.getSingularUrlField("uid");
        this.conditionallyAddStringProperty(compoNode.getDocument(), evt, HCalendarExtractor.vICAL.uid, url.value());
    }

    private void addUrl(HTMLDocument compoNode, Resource evt) throws ExtractionException {
        HTMLDocument.TextField url = compoNode.getSingularUrlField("url");
        if ("".equals(url.value())) {
            return;
        }
        this.addIRIProperty(evt, HCalendarExtractor.vICAL.url, this.getHTMLDocument().resolveIRI(url.value()));
    }

    private void addRRule(HTMLDocument compoNode, Resource evt) {
        for (Node rule : compoNode.findAllByClassName("rrule")) {
            BNode rrule = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)rrule, RDF.TYPE, HCalendarExtractor.vICAL.DomainOf_rrule);
            HTMLDocument.TextField freq = new HTMLDocument(rule).getSingularTextField("freq");
            this.conditionallyAddStringProperty(freq.source(), (Resource)rrule, HCalendarExtractor.vICAL.freq, freq.value());
            this.addBNodeProperty(rule, evt, HCalendarExtractor.vICAL.rrule, rrule);
        }
    }

    private void addOrganizer(HTMLDocument compoNode, Resource evt) {
        for (Node organizer : compoNode.findAllByClassName("organizer")) {
            BNode blank = this.valueFactory.createBNode();
            HTMLDocument.TextField mail = new HTMLDocument(organizer).getSingularUrlField("organizer");
            this.conditionallyAddStringProperty(compoNode.getDocument(), (Resource)blank, HCalendarExtractor.vICAL.calAddress, mail.value());
            this.addBNodeProperty(organizer, evt, HCalendarExtractor.vICAL.organizer, blank);
        }
    }

    private void addTextProps(HTMLDocument node, Resource evt) {
        HTMLDocument.TextField[] values;
        HTMLDocument.TextField val2;
        for (String date : this.textSingularProps) {
            val2 = node.getSingularTextField(date);
            this.conditionallyAddStringProperty(val2.source(), evt, vICAL.getProperty(date), val2.value());
        }
        for (String date : this.textDateProps) {
            val2 = node.getSingularTextField(date);
            try {
                this.conditionallyAddStringProperty(val2.source(), evt, vICAL.getProperty(date), RDFUtils.getXSDDate(val2.value(), DATE_FORMAT));
            }
            catch (ParseException e) {
                this.conditionallyAddStringProperty(val2.source(), evt, vICAL.getProperty(date), val2.value());
            }
            catch (DatatypeConfigurationException e) {
                this.conditionallyAddStringProperty(val2.source(), evt, vICAL.getProperty(date), val2.value());
            }
        }
        for (HTMLDocument.TextField val2 : values = node.getPluralTextField("category")) {
            this.conditionallyAddStringProperty(val2.source(), evt, HCalendarExtractor.vICAL.categories, val2.value());
        }
    }
}

