/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.any23.configuration.Configuration;
import org.apache.any23.configuration.DefaultConfiguration;
import org.apache.any23.encoding.EncodingDetector;
import org.apache.any23.encoding.TikaEncodingDetector;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractionResultImpl;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorFactory;
import org.apache.any23.extractor.ExtractorGroup;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.SingleDocumentExtractionReport;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.DocumentReport;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.MicroformatExtractor;
import org.apache.any23.extractor.html.TagSoupParser;
import org.apache.any23.mime.MIMEType;
import org.apache.any23.mime.MIMETypeDetector;
import org.apache.any23.rdf.Any23ValueFactoryWrapper;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.source.DocumentSource;
import org.apache.any23.source.LocalCopyFactory;
import org.apache.any23.source.MemCopyFactory;
import org.apache.any23.validator.EmptyValidationReport;
import org.apache.any23.validator.ValidatorException;
import org.apache.any23.vocab.SINDICE;
import org.apache.any23.writer.CompositeTripleHandler;
import org.apache.any23.writer.CountingTripleHandler;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDocumentExtraction {
    private static final SINDICE vSINDICE = SINDICE.getInstance();
    private static final Logger log = LoggerFactory.getLogger(SingleDocumentExtraction.class);
    private final Configuration configuration;
    private final DocumentSource in;
    private IRI documentIRI;
    private final ExtractorGroup extractors;
    private final TripleHandler output;
    private final EncodingDetector encoderDetector;
    private LocalCopyFactory copyFactory = null;
    private DocumentSource localDocumentSource = null;
    private MIMETypeDetector detector = null;
    private ExtractorGroup matchingExtractors = null;
    private MIMEType detectedMIMEType = null;
    private DocumentReport documentReport = null;
    private ExtractionParameters tagSoupDOMRelatedParameters = null;
    private String parserEncoding = null;

    public SingleDocumentExtraction(Configuration configuration, DocumentSource in, ExtractorGroup extractors, TripleHandler output) {
        if (configuration == null) {
            throw new NullPointerException("configuration cannot be null.");
        }
        if (in == null) {
            throw new NullPointerException("in cannot be null.");
        }
        this.configuration = configuration;
        this.in = in;
        this.extractors = extractors;
        ArrayList<TripleHandler> tripleHandlers = new ArrayList<TripleHandler>();
        tripleHandlers.add(output);
        tripleHandlers.add(new CountingTripleHandler());
        this.output = new CompositeTripleHandler(tripleHandlers);
        this.encoderDetector = new TikaEncodingDetector();
    }

    public SingleDocumentExtraction(Configuration configuration, DocumentSource in, ExtractorFactory<?> factory, TripleHandler output) {
        this(configuration, in, new ExtractorGroup(Collections.singletonList(factory)), output);
        this.setMIMETypeDetector(null);
    }

    public SingleDocumentExtraction(DocumentSource in, ExtractorFactory<?> factory, TripleHandler output) {
        this((Configuration)DefaultConfiguration.singleton(), in, new ExtractorGroup(Collections.singletonList(factory)), output);
        this.setMIMETypeDetector(null);
    }

    public void setLocalCopyFactory(LocalCopyFactory copyFactory) {
        this.copyFactory = copyFactory;
    }

    public void setMIMETypeDetector(MIMETypeDetector detector) {
        this.detector = detector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleDocumentExtractionReport run(ExtractionParameters extractionParameters) throws ExtractionException, IOException {
        HashMap<String, Collection<IssueReport.Issue>> extractorToIssues;
        block25: {
            if (extractionParameters == null) {
                extractionParameters = ExtractionParameters.newDefault((Configuration)this.configuration);
            }
            String contextIRI = extractionParameters.getProperty("any23.extraction.context.iri");
            this.ensureHasLocalCopy();
            try {
                this.documentIRI = new Any23ValueFactoryWrapper((ValueFactory)SimpleValueFactory.getInstance()).createIRI("?".equals(contextIRI) ? this.in.getDocumentIRI() : contextIRI);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid IRI: " + this.in.getDocumentIRI(), ex);
            }
            if (log.isDebugEnabled()) {
                log.debug("Processing " + this.documentIRI);
            }
            this.filterExtractorsByMIMEType();
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("Extractors ");
                for (ExtractorFactory factory : this.matchingExtractors) {
                    sb.append(factory.getExtractorName());
                    sb.append(' ');
                }
                sb.append("match ").append(this.documentIRI);
                log.debug(sb.toString());
            }
            ArrayList<TagSoupExtractionResult.ResourceRoot> resourceRoots = new ArrayList<TagSoupExtractionResult.ResourceRoot>();
            ArrayList<TagSoupExtractionResult.PropertyPath> propertyPaths = new ArrayList<TagSoupExtractionResult.PropertyPath>();
            extractorToIssues = new HashMap<String, Collection<IssueReport.Issue>>();
            try {
                this.output.startDocument(this.documentIRI);
            }
            catch (TripleHandlerException e) {
                log.error(String.format("Error starting document with IRI %s", this.documentIRI));
                throw new ExtractionException(String.format("Error starting document with IRI %s", this.documentIRI), (Throwable)e);
            }
            try {
                String documentLanguage;
                this.output.setContentLength(this.in.getContentLength());
                try {
                    documentLanguage = this.extractDocumentLanguage(extractionParameters);
                    ArrayList<ExtractorFactory> filteredList = new ArrayList<ExtractorFactory>(this.matchingExtractors.getNumOfExtractors());
                    boolean mimeTypeIsTooGeneric = SingleDocumentExtraction.isTooGeneric(this.detectedMIMEType);
                    ArrayList intersectionOfRdfMimetypes = null;
                    for (ExtractorFactory factory : this.matchingExtractors) {
                        Extractor extractor = factory.createExtractor();
                        SingleExtractionReport er = this.runExtractor(extractionParameters, documentLanguage, extractor);
                        if (mimeTypeIsTooGeneric) {
                            List rdfMimetypes = factory.getSupportedMIMETypes().stream().filter(mt -> !SingleDocumentExtraction.isTooGeneric(mt)).map(MIMEType::getFullType).collect(Collectors.toList());
                            if (er.touched) {
                                if (intersectionOfRdfMimetypes == null) {
                                    intersectionOfRdfMimetypes = new ArrayList(rdfMimetypes);
                                } else {
                                    intersectionOfRdfMimetypes.retainAll(rdfMimetypes);
                                }
                            } else if (!rdfMimetypes.isEmpty()) continue;
                        }
                        resourceRoots.addAll(er.resourceRoots);
                        propertyPaths.addAll(er.propertyPaths);
                        filteredList.add(factory);
                        extractorToIssues.put(factory.getExtractorName(), er.issues);
                    }
                    this.matchingExtractors = new ExtractorGroup(filteredList);
                    if (intersectionOfRdfMimetypes != null && !intersectionOfRdfMimetypes.isEmpty()) {
                        this.detectedMIMEType = MIMEType.parse((String)((String)intersectionOfRdfMimetypes.get(0)));
                    }
                }
                catch (ValidatorException ve) {
                    throw new ExtractionException("An error occurred during the validation phase.", (Throwable)ve);
                }
                boolean addDomainTriples = extractionParameters.getFlag("any23.extraction.metadata.domain.per.entity");
                ExtractionContext consolidationContext = extractionParameters.getFlag("any23.extraction.metadata.nesting") ? this.consolidateResources(resourceRoots, propertyPaths, addDomainTriples, this.output, documentLanguage) : this.consolidateResources(resourceRoots, addDomainTriples, this.output, documentLanguage);
                if (!extractionParameters.getFlag("any23.extraction.metadata.timesize")) break block25;
                try {
                    this.addExtractionTimeSizeMetaTriples(consolidationContext);
                }
                catch (TripleHandlerException e) {
                    throw new ExtractionException(String.format("Error while adding extraction metadata triples document with IRI %s", this.documentIRI), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.output.endDocument(this.documentIRI);
                }
                catch (TripleHandlerException e) {
                    log.error(String.format("Error ending document with IRI %s", this.documentIRI));
                    throw new ExtractionException(String.format("Error ending document with IRI %s", this.documentIRI), (Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            this.output.endDocument(this.documentIRI);
        }
        catch (TripleHandlerException e) {
            log.error(String.format("Error ending document with IRI %s", this.documentIRI));
            throw new ExtractionException(String.format("Error ending document with IRI %s", this.documentIRI), (Throwable)e);
        }
        return new SingleDocumentExtractionReport(this.documentReport == null ? EmptyValidationReport.getInstance() : this.documentReport.getReport(), extractorToIssues);
    }

    private static boolean isTooGeneric(MIMEType type) {
        if (type == null || type.isAnySubtype()) {
            return true;
        }
        String mt = type.getFullType();
        return mt.equals("text/plain") || mt.equals("application/octet-stream") || mt.equals("application/xml");
    }

    public SingleDocumentExtractionReport run() throws IOException, ExtractionException {
        return this.run(ExtractionParameters.newDefault((Configuration)this.configuration));
    }

    public String getDetectedMIMEType() throws IOException {
        this.filterExtractorsByMIMEType();
        return this.detectedMIMEType == null ? null : this.detectedMIMEType.toString();
    }

    public boolean hasMatchingExtractors() throws IOException {
        this.filterExtractorsByMIMEType();
        return !this.matchingExtractors.isEmpty();
    }

    public List<Extractor> getMatchingExtractors() {
        ArrayList<Extractor> extractorsList = new ArrayList<Extractor>();
        for (ExtractorFactory extractorFactory : this.matchingExtractors) {
            extractorsList.add(extractorFactory.createExtractor());
        }
        return extractorsList;
    }

    public String getParserEncoding() {
        if (this.parserEncoding == null) {
            this.parserEncoding = this.detectEncoding();
        }
        return this.parserEncoding;
    }

    public void setParserEncoding(String encoding) {
        this.parserEncoding = encoding;
        this.documentReport = null;
    }

    private boolean isHTMLDocument() throws IOException {
        this.filterExtractorsByMIMEType();
        return !this.matchingExtractors.filterByMIMEType(MIMEType.parse((String)"text/html")).isEmpty();
    }

    private String extractDocumentLanguage(ExtractionParameters extractionParameters) throws IOException, ValidatorException {
        HTMLDocument document;
        if (!this.isHTMLDocument()) {
            return null;
        }
        try {
            document = new HTMLDocument(this.getTagSoupDOM(extractionParameters).getDocument());
        }
        catch (IOException ioe) {
            log.debug("Cannot extract language from document.", (Throwable)ioe);
            return null;
        }
        return document.getDefaultLanguage();
    }

    private void filterExtractorsByMIMEType() throws IOException {
        if (this.matchingExtractors != null) {
            return;
        }
        if (this.detector == null || this.extractors.allExtractorsSupportAllContentTypes()) {
            this.matchingExtractors = this.extractors;
            return;
        }
        this.ensureHasLocalCopy();
        this.detectedMIMEType = this.detector.guessMIMEType(URI.create(this.in.getDocumentIRI()).getPath(), this.localDocumentSource.openInputStream(), MIMEType.parse((String)this.localDocumentSource.getContentType()));
        log.debug("detected media type: " + this.detectedMIMEType);
        this.matchingExtractors = this.extractors.filterByMIMEType(this.detectedMIMEType);
    }

    private SingleExtractionReport runExtractor(ExtractionParameters extractionParameters, String documentLanguage, Extractor<?> extractor) throws ExtractionException, IOException, ValidatorException {
        if (log.isDebugEnabled()) {
            log.debug("Running {} on {}", (Object)extractor.getDescription().getExtractorName(), (Object)this.documentIRI);
        }
        long startTime = System.currentTimeMillis();
        ExtractionContext extractionContext = new ExtractionContext(extractor.getDescription().getExtractorName(), this.documentIRI, documentLanguage);
        ExtractionResultImpl extractionResult = new ExtractionResultImpl(extractionContext, extractor, this.output);
        try {
            Object tagSoupDOMExtractor;
            if (extractor instanceof Extractor.BlindExtractor) {
                Extractor.BlindExtractor blindExtractor = (Extractor.BlindExtractor)extractor;
                blindExtractor.run(extractionParameters, extractionContext, (Object)this.documentIRI, (ExtractionResult)extractionResult);
            } else if (extractor instanceof Extractor.ContentExtractor) {
                this.ensureHasLocalCopy();
                Extractor.ContentExtractor contentExtractor = (Extractor.ContentExtractor)extractor;
                contentExtractor.run(extractionParameters, extractionContext, (Object)this.localDocumentSource.openInputStream(), (ExtractionResult)extractionResult);
            } else if (extractor instanceof Extractor.TagSoupDOMExtractor) {
                tagSoupDOMExtractor = (Extractor.TagSoupDOMExtractor)extractor;
                DocumentReport documentReport = this.getTagSoupDOM(extractionParameters);
                tagSoupDOMExtractor.run(extractionParameters, extractionContext, (Object)documentReport.getDocument(), (ExtractionResult)extractionResult);
            } else {
                throw new IllegalStateException("Extractor type not supported: " + extractor.getClass());
            }
            tagSoupDOMExtractor = new SingleExtractionReport(extractionResult.getIssues(), new ArrayList<TagSoupExtractionResult.ResourceRoot>(extractionResult.getResourceRoots()), new ArrayList<TagSoupExtractionResult.PropertyPath>(extractionResult.getPropertyPaths()), extractionResult.wasTouched());
            return tagSoupDOMExtractor;
        }
        catch (ExtractionException ex) {
            if (log.isDebugEnabled()) {
                log.debug(extractor.getDescription().getExtractorName() + ": " + ex.getMessage());
            }
            throw ex;
        }
        finally {
            if (log.isDebugEnabled() && extractionResult.hasIssues()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                extractionResult.printReport(new PrintStream(baos));
                log.debug(baos.toString());
            }
            extractionResult.close();
            long elapsed = System.currentTimeMillis() - startTime;
            if (log.isDebugEnabled()) {
                log.debug("Completed " + extractor.getDescription().getExtractorName() + ", " + elapsed + "ms");
            }
        }
    }

    private void ensureHasLocalCopy() throws IOException {
        if (this.localDocumentSource != null) {
            return;
        }
        if (this.in.isLocal()) {
            this.localDocumentSource = this.in;
            return;
        }
        if (this.copyFactory == null) {
            this.copyFactory = new MemCopyFactory();
        }
        this.localDocumentSource = this.copyFactory.createLocalCopy(this.in);
    }

    private DocumentReport getTagSoupDOM(ExtractionParameters extractionParameters) throws IOException, ValidatorException {
        if (this.documentReport == null || !extractionParameters.equals((Object)this.tagSoupDOMRelatedParameters)) {
            this.ensureHasLocalCopy();
            BufferedInputStream is = new BufferedInputStream(this.localDocumentSource.openInputStream());
            ((InputStream)is).mark(Integer.MAX_VALUE);
            String candidateEncoding = this.getParserEncoding();
            ((InputStream)is).reset();
            TagSoupParser tagSoupParser = new TagSoupParser(is, this.documentIRI.stringValue(), candidateEncoding);
            this.documentReport = extractionParameters.isValidate() ? tagSoupParser.getValidatedDOM(extractionParameters.isFix()) : new DocumentReport(EmptyValidationReport.getInstance(), tagSoupParser.getDOM());
            this.tagSoupDOMRelatedParameters = extractionParameters;
        }
        return this.documentReport;
    }

    private String detectEncoding() {
        try {
            this.ensureHasLocalCopy();
            BufferedInputStream is = new BufferedInputStream(this.localDocumentSource.openInputStream());
            String encoding = this.encoderDetector.guessEncoding((InputStream)is, this.localDocumentSource.getContentType());
            ((InputStream)is).close();
            return encoding;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while trying to detect the input encoding.", e);
        }
    }

    private boolean subPath(String[] list, String[] candidateSub) {
        if (candidateSub.length > list.length) {
            return false;
        }
        for (int i = 0; i < candidateSub.length; ++i) {
            if (candidateSub[i].equals(list[i])) continue;
            return false;
        }
        return true;
    }

    private void addDomainTriplesPerResourceRoots(List<TagSoupExtractionResult.ResourceRoot> resourceRoots, ExtractionContext context) throws ExtractionException {
        try {
            String domain;
            try {
                domain = new URI(this.in.getDocumentIRI()).getHost();
            }
            catch (URISyntaxException urise) {
                throw new IllegalArgumentException("An error occurred while extracting the host from the document IRI.", urise);
            }
            if (domain != null) {
                for (TagSoupExtractionResult.ResourceRoot resourceRoot : resourceRoots) {
                    this.output.receiveTriple(resourceRoot.getRoot(), vSINDICE.getProperty("domain"), (Value)SimpleValueFactory.getInstance().createLiteral(domain), null, context);
                }
            }
        }
        catch (TripleHandlerException e) {
            throw new ExtractionException("Error while writing triple triple.", (Throwable)e);
        }
        finally {
            try {
                this.output.closeContext(context);
            }
            catch (TripleHandlerException e) {
                throw new ExtractionException("Error while closing context.", (Throwable)e);
            }
        }
    }

    private ExtractionContext createExtractionContext(String defaultLanguage) {
        return new ExtractionContext("consolidation-extractor", this.documentIRI, defaultLanguage, UUID.randomUUID().toString());
    }

    private void addNestingRelationship(List<TagSoupExtractionResult.ResourceRoot> resourceRoots, List<TagSoupExtractionResult.PropertyPath> propertyPaths, ExtractionContext context) throws TripleHandlerException {
        for (int r = 0; r < resourceRoots.size(); ++r) {
            TagSoupExtractionResult.ResourceRoot currentResourceRoot = resourceRoots.get(r);
            for (int p = 0; p < propertyPaths.size(); ++p) {
                Class<? extends MicroformatExtractor> currentPropertyPathExtractor;
                TagSoupExtractionResult.PropertyPath currentPropertyPath = propertyPaths.get(p);
                Class<? extends MicroformatExtractor> currentResourceRootExtractor = currentResourceRoot.getExtractor();
                if (currentResourceRootExtractor.equals(currentPropertyPathExtractor = currentPropertyPath.getExtractor()) || MicroformatExtractor.includes(currentPropertyPathExtractor, currentResourceRootExtractor) || !this.subPath(currentResourceRoot.getPath(), currentPropertyPath.getPath())) continue;
                this.createNestingRelationship(currentPropertyPath, currentResourceRoot, this.output, context);
            }
        }
    }

    private ExtractionContext consolidateResources(List<TagSoupExtractionResult.ResourceRoot> resourceRoots, List<TagSoupExtractionResult.PropertyPath> propertyPaths, boolean addDomainTriples, TripleHandler output, String defaultLanguage) throws ExtractionException {
        ExtractionContext context = this.createExtractionContext(defaultLanguage);
        try {
            output.openContext(context);
        }
        catch (TripleHandlerException e) {
            throw new ExtractionException(String.format("Error starting document with IRI %s", this.documentIRI), (Throwable)e);
        }
        try {
            if (addDomainTriples) {
                this.addDomainTriplesPerResourceRoots(resourceRoots, context);
            }
            this.addNestingRelationship(resourceRoots, propertyPaths, context);
        }
        catch (TripleHandlerException the) {
            throw new ExtractionException("Error while writing triple triple.", (Throwable)the);
        }
        finally {
            try {
                output.closeContext(context);
            }
            catch (TripleHandlerException e) {
                throw new ExtractionException("Error while closing context.", (Throwable)e);
            }
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtractionContext consolidateResources(List<TagSoupExtractionResult.ResourceRoot> resourceRoots, boolean addDomainTriples, TripleHandler output, String defaultLanguage) throws ExtractionException {
        ExtractionContext context = this.createExtractionContext(defaultLanguage);
        try {
            output.openContext(context);
        }
        catch (TripleHandlerException e) {
            throw new ExtractionException(String.format("Error starting document with IRI %s", this.documentIRI), (Throwable)e);
        }
        try {
            if (addDomainTriples) {
                this.addDomainTriplesPerResourceRoots(resourceRoots, context);
            }
        }
        finally {
            try {
                output.closeContext(context);
            }
            catch (TripleHandlerException the) {
                throw new ExtractionException("Error while closing context.", (Throwable)the);
            }
        }
        return context;
    }

    private void addExtractionTimeSizeMetaTriples(ExtractionContext context) throws TripleHandlerException {
        String xsdDateTimeNow = RDFUtils.toXSDDateTime(new Date());
        this.output.receiveTriple((Resource)SimpleValueFactory.getInstance().createIRI(this.documentIRI.toString()), vSINDICE.getProperty("date"), (Value)SimpleValueFactory.getInstance().createLiteral(xsdDateTimeNow), null, context);
        int numberOfTriples = 0;
        CompositeTripleHandler cth = (CompositeTripleHandler)this.output;
        for (TripleHandler th : cth.getChilds()) {
            if (!(th instanceof CountingTripleHandler)) continue;
            numberOfTriples = ((CountingTripleHandler)th).getCount();
        }
        this.output.receiveTriple((Resource)SimpleValueFactory.getInstance().createIRI(this.documentIRI.toString()), vSINDICE.getProperty("size"), (Value)SimpleValueFactory.getInstance().createLiteral(numberOfTriples + 1), null, context);
    }

    private void createNestingRelationship(TagSoupExtractionResult.PropertyPath from, TagSoupExtractionResult.ResourceRoot to, TripleHandler th, ExtractionContext ec) throws TripleHandlerException {
        BNode fromObject = from.getObject();
        String bNodeHash = from.getProperty().stringValue() + (fromObject == null ? "" : fromObject.getID());
        BNode bnode = RDFUtils.getBNode(bNodeHash);
        th.receiveTriple((Resource)bnode, vSINDICE.getProperty("nesting_original"), (Value)from.getProperty(), null, ec);
        th.receiveTriple((Resource)bnode, vSINDICE.getProperty("nesting_structured"), (Value)(from.getObject() == null ? to.getRoot() : from.getObject()), null, ec);
        th.receiveTriple(from.getSubject(), vSINDICE.getProperty("nesting"), (Value)bnode, null, ec);
    }

    private static class SingleExtractionReport {
        private final Collection<IssueReport.Issue> issues;
        private final List<TagSoupExtractionResult.ResourceRoot> resourceRoots;
        private final List<TagSoupExtractionResult.PropertyPath> propertyPaths;
        private final boolean touched;

        public SingleExtractionReport(Collection<IssueReport.Issue> issues, List<TagSoupExtractionResult.ResourceRoot> resourceRoots, List<TagSoupExtractionResult.PropertyPath> propertyPaths, boolean wasTouched) {
            this.issues = issues;
            this.resourceRoots = resourceRoots;
            this.propertyPaths = propertyPaths;
            this.touched = wasTouched;
        }
    }
}

