/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorFactory;
import org.apache.any23.extractor.ExtractorRegistryImpl;
import org.apache.any23.extractor.SingleDocumentExtraction;
import org.apache.any23.source.MemCopyFactory;
import org.apache.any23.source.StringDocumentSource;
import org.apache.any23.writer.TripleHandlerException;
import org.apache.any23.writer.TurtleWriter;

public class ExampleInputOutput {
    private final ExtractorFactory<?> factory;

    public ExampleInputOutput(String extractorName) {
        this(ExtractorRegistryImpl.getInstance().getFactory(extractorName));
    }

    public ExampleInputOutput(ExtractorFactory<?> factory) {
        this.factory = factory;
    }

    public String getExampleInput() throws IOException {
        if (this.factory.getExampleInput() == null) {
            return null;
        }
        if (this.isBlindExtractor()) {
            return null;
        }
        InputStream in = this.factory.createExtractor().getClass().getResourceAsStream(this.factory.getExampleInput());
        if (in == null) {
            throw new IllegalArgumentException("Example input resource not found for extractor " + this.factory.getExtractorName() + ": " + this.factory.getExampleInput());
        }
        return new String(MemCopyFactory.toByteArray(in), "utf-8");
    }

    public String getExampleIRI() {
        if (this.factory.getExampleInput() == null) {
            return null;
        }
        if (this.isBlindExtractor()) {
            return this.factory.getExampleInput();
        }
        return "http://example.com/";
    }

    public String getExampleOutput() throws IOException, ExtractionException {
        if (this.factory.getExampleInput() == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TurtleWriter writer = new TurtleWriter(out);
        new SingleDocumentExtraction(new StringDocumentSource(this.getExampleInput(), this.getExampleIRI()), this.factory, writer).run();
        try {
            writer.close();
        }
        catch (TripleHandlerException e) {
            throw new ExtractionException("Error while closing the triple handler", (Throwable)e);
        }
        return out.toString("utf-8");
    }

    private boolean isBlindExtractor() {
        return this.factory.createExtractor() instanceof Extractor.BlindExtractor;
    }
}

