/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.any23.Any23;
import org.apache.any23.cli.BaseTool;
import org.apache.any23.cli.Tool;
import org.apache.any23.plugin.Any23PluginManager;

public final class ToolRunner {
    public static final File DEFAULT_PLUGIN_DIR = new File(new File(System.getProperty("user.home")), ".any23/plugins");
    private static final PrintStream infoStream = System.err;
    @Parameter(names={"-h", "--help"}, description="Display help information.")
    private boolean printHelp;
    @Parameter(names={"-v", "--version"}, description="Display version information.")
    private boolean showVersion;
    @Parameter(names={"-X", "--verbose"}, description="Produce execution verbose output.")
    private boolean verbose;
    @Parameter(names={"--plugins-dir"}, description="The Any23 plugins directory.", converter=FileConverter.class)
    private File pluginsDir = DEFAULT_PLUGIN_DIR;

    public static void main(String[] args) throws Exception {
        System.exit(new ToolRunner().execute(args));
    }

    public int execute(String ... args) throws Exception {
        return this.execute(false, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int execute(boolean concise, String ... args) throws Exception {
        File pluginsDirOption;
        JCommander commander = new JCommander((Object)this);
        commander.setProgramName(System.getProperty("app.name"));
        try {
            pluginsDirOption = ToolRunner.parsePluginDirOption(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return 1;
        }
        if (pluginsDirOption != null) {
            this.pluginsDir = pluginsDirOption;
        }
        Iterator<Tool> tools = this.getToolsInClasspath();
        while (tools.hasNext()) {
            Tool tool = tools.next();
            commander.addCommand((Object)tool);
        }
        commander.parse(args);
        Map commands = commander.getCommands();
        String parsedCommand = commander.getParsedCommand();
        if (this.printHelp) {
            commander.usage();
            return 0;
        }
        if (this.showVersion) {
            ToolRunner.printVersionInfo();
            return 0;
        }
        if (parsedCommand == null) {
            infoStream.println("A command must be specified.");
            commander.usage();
            return 1;
        }
        long start = System.currentTimeMillis();
        int exit = 0;
        Throwable error = null;
        infoStream.println();
        infoStream.println("------------------------------------------------------------------------");
        infoStream.printf("Apache Any23 :: %s%n", parsedCommand);
        infoStream.println("------------------------------------------------------------------------");
        infoStream.println();
        try {
            Tool tool = (Tool)Tool.class.cast(((JCommander)commands.get(parsedCommand)).getObjects().get(0));
            if (tool instanceof BaseTool) {
                ((BaseTool)tool).run(concise);
            } else {
                tool.run();
            }
            infoStream.println();
            infoStream.println("------------------------------------------------------------------------");
        }
        catch (Throwable t) {
            try {
                exit = 1;
                error = t;
                infoStream.println();
                infoStream.println("------------------------------------------------------------------------");
            }
            catch (Throwable throwable) {
                infoStream.println();
                infoStream.println("------------------------------------------------------------------------");
                infoStream.printf("Apache Any23 %s%n", exit != 0 ? "FAILURE" : "SUCCESS");
                if (exit != 0) {
                    infoStream.println();
                    if (this.verbose) {
                        System.err.println("Execution terminated with errors:");
                        error.printStackTrace(infoStream);
                    } else {
                        infoStream.printf("Execution terminated with errors: %s%n", error.getMessage());
                    }
                    infoStream.println();
                }
                infoStream.printf("Total time: %ss%n", (System.currentTimeMillis() - start) / 1000L);
                infoStream.printf("Finished at: %s%n", new Date());
                Runtime runtime = Runtime.getRuntime();
                int megaUnit = 0x100000;
                infoStream.printf("Final Memory: %sM/%sM%n", (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L, runtime.totalMemory() / 0x100000L);
                infoStream.println("------------------------------------------------------------------------");
                throw throwable;
            }
            infoStream.printf("Apache Any23 %s%n", exit != 0 ? "FAILURE" : "SUCCESS");
            if (exit != 0) {
                infoStream.println();
                if (this.verbose) {
                    System.err.println("Execution terminated with errors:");
                    error.printStackTrace(infoStream);
                } else {
                    infoStream.printf("Execution terminated with errors: %s%n", error.getMessage());
                }
                infoStream.println();
            }
            infoStream.printf("Total time: %ss%n", (System.currentTimeMillis() - start) / 1000L);
            infoStream.printf("Finished at: %s%n", new Date());
            Runtime runtime = Runtime.getRuntime();
            int megaUnit = 0x100000;
            infoStream.printf("Final Memory: %sM/%sM%n", (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L, runtime.totalMemory() / 0x100000L);
            infoStream.println("------------------------------------------------------------------------");
        }
        infoStream.printf("Apache Any23 %s%n", exit != 0 ? "FAILURE" : "SUCCESS");
        if (exit != 0) {
            infoStream.println();
            if (this.verbose) {
                System.err.println("Execution terminated with errors:");
                error.printStackTrace(infoStream);
            } else {
                infoStream.printf("Execution terminated with errors: %s%n", error.getMessage());
            }
            infoStream.println();
        }
        infoStream.printf("Total time: %ss%n", (System.currentTimeMillis() - start) / 1000L);
        infoStream.printf("Finished at: %s%n", new Date());
        Runtime runtime = Runtime.getRuntime();
        int megaUnit = 0x100000;
        infoStream.printf("Final Memory: %sM/%sM%n", (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L, runtime.totalMemory() / 0x100000L);
        infoStream.println("------------------------------------------------------------------------");
        return exit;
    }

    Iterator<Tool> getToolsInClasspath() throws IOException {
        Any23PluginManager pluginManager = Any23PluginManager.getInstance();
        if (this.pluginsDir.exists() && this.pluginsDir.isDirectory()) {
            pluginManager.loadJARDir(this.pluginsDir);
        }
        return pluginManager.getTools();
    }

    private static void printVersionInfo() {
        Properties properties = new Properties();
        InputStream input = ToolRunner.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.any23/any23-core/pom.properties");
        if (input != null) {
            try {
                properties.load(input);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        infoStream.printf("Apache Any23 %s%n", Any23.VERSION);
        infoStream.printf("Java version: %s, vendor: %s%n", System.getProperty("java.version"), System.getProperty("java.vendor"));
        infoStream.printf("Java home: %s%n", System.getProperty("java.home"));
        infoStream.printf("Default locale: %s_%s, platform encoding: %s%n", System.getProperty("user.language"), System.getProperty("user.country"), System.getProperty("sun.jnu.encoding"));
        infoStream.printf("OS name: \"%s\", version: \"%s\", arch: \"%s\", family: \"%s\"%n", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), ToolRunner.getOsFamily());
    }

    private static final String getOsFamily() {
        String osName = System.getProperty("os.name").toLowerCase();
        String pathSep = System.getProperty("path.separator");
        if (osName.contains("windows")) {
            return "windows";
        }
        if (osName.contains("os/2")) {
            return "os/2";
        }
        if (osName.contains("z/os") || osName.contains("os/390")) {
            return "z/os";
        }
        if (osName.contains("os/400")) {
            return "os/400";
        }
        if (";".equals(pathSep)) {
            return "dos";
        }
        if (osName.contains("mac")) {
            if (osName.endsWith("x")) {
                return "mac";
            }
            return "unix";
        }
        if (osName.contains("nonstop_kernel")) {
            return "tandem";
        }
        if (osName.contains("openvms")) {
            return "openvms";
        }
        if (":".equals(pathSep)) {
            return "unix";
        }
        return "undefined";
    }

    private static File parsePluginDirOption(String[] args) {
        int optionIndex = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!"--plugins-dir".equals(args[i])) continue;
            optionIndex = i;
        }
        if (optionIndex == -1) {
            return null;
        }
        if (optionIndex == args.length - 1) {
            throw new IllegalArgumentException("Missing argument for --plugins-dir option.");
        }
        File pluginsDir = new File(args[optionIndex + 1]);
        if (!pluginsDir.isDirectory()) {
            throw new IllegalArgumentException("Expected a directory for --plugins-dir option value.");
        }
        return pluginsDir;
    }
}

