/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.IdentityTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

public class TransformSeparator {
    protected final MathTransform transform;
    protected int[] sourceDimensions;
    protected int[] targetDimensions;
    protected final MathTransformFactory factory;

    public TransformSeparator(MathTransform mathTransform) {
        this(mathTransform, DefaultFactories.forBuildin(MathTransformFactory.class));
    }

    public TransformSeparator(MathTransform mathTransform, MathTransformFactory mathTransformFactory) {
        ArgumentChecks.ensureNonNull("transform", mathTransform);
        ArgumentChecks.ensureNonNull("factory", mathTransformFactory);
        this.transform = mathTransform;
        this.factory = mathTransformFactory;
    }

    public void clear() {
        this.sourceDimensions = null;
        this.targetDimensions = null;
    }

    private static int[] insert(int[] nArray, int n) throws IllegalArgumentException {
        if (nArray == null) {
            return new int[]{n};
        }
        assert (ArraysExt.isSorted(nArray, true));
        int n2 = Arrays.binarySearch(nArray, n);
        if (n2 < 0) {
            nArray = ArraysExt.insert(nArray, n2 ^= 0xFFFFFFFF, 1);
            nArray[n2] = n;
        }
        assert (Arrays.binarySearch(nArray, n) == n2);
        return nArray;
    }

    private static int[] add(int[] nArray, int[] nArray2, int n) throws IllegalArgumentException {
        int n2 = 0;
        int n3 = -1;
        if (nArray != null && (n2 = nArray.length) != 0) {
            n3 = nArray[n2 - 1];
            nArray = Arrays.copyOf(nArray, n2 + nArray2.length);
            System.arraycopy(nArray2, 0, nArray, n2, nArray2.length);
        } else {
            nArray = (int[])nArray2.clone();
        }
        for (int i = n2; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if (n4 <= n3 || n4 >= n) {
                throw new IllegalArgumentException(Errors.format((short)166, "dimensions[" + (i - n2) + ']', n3 + 1, n - 1, n4));
            }
            n3 = n4;
        }
        return nArray;
    }

    private static int[] add(int[] nArray, int n, int n2, int n3) throws IllegalArgumentException {
        boolean bl;
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException(Errors.format((short)60, n, n2));
        }
        int n4 = 0;
        int n5 = 0;
        if (nArray != null && (n5 = nArray.length) != 0) {
            n4 = nArray[n5 - 1] + 1;
        }
        boolean bl2 = bl = n2 > n3;
        if (bl || n < n4) {
            throw new IllegalArgumentException(Errors.format((short)166, bl ? "upper" : "lower", n4, n3 - 1, bl ? n2 : n));
        }
        if (n5 == 0) {
            nArray = TransformSeparator.series(n, n2);
        } else {
            nArray = Arrays.copyOf(nArray, (n5 -= n) + n2);
            for (int i = n; i < n2; ++i) {
                nArray[n5 + i] = i;
            }
        }
        assert (TransformSeparator.containsAll(nArray, n, n2));
        return nArray;
    }

    private static int[] series(int n, int n2) throws IllegalArgumentException {
        int[] nArray = new int[n2 - n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i + n;
        }
        return nArray;
    }

    public void addSourceDimensions(int ... nArray) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("dimensions", nArray);
        this.sourceDimensions = TransformSeparator.add(this.sourceDimensions, nArray, this.transform.getSourceDimensions());
    }

    public void addSourceDimensionRange(int n, int n2) throws IllegalArgumentException {
        this.sourceDimensions = TransformSeparator.add(this.sourceDimensions, n, n2, this.transform.getSourceDimensions());
    }

    public int[] getSourceDimensions() throws IllegalStateException {
        if (this.sourceDimensions != null) {
            return (int[])this.sourceDimensions.clone();
        }
        throw new IllegalStateException(Resources.format((short)69));
    }

    public void addTargetDimensions(int ... nArray) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("dimensions", nArray);
        this.targetDimensions = TransformSeparator.add(this.targetDimensions, nArray, this.transform.getTargetDimensions());
    }

    public void addTargetDimensionRange(int n, int n2) throws IllegalArgumentException {
        this.targetDimensions = TransformSeparator.add(this.targetDimensions, n, n2, this.transform.getTargetDimensions());
    }

    public int[] getTargetDimensions() throws IllegalStateException {
        if (this.targetDimensions != null) {
            return (int[])this.targetDimensions.clone();
        }
        throw new IllegalStateException(Resources.format((short)69));
    }

    public MathTransform separate() throws FactoryException {
        MathTransform mathTransform = this.transform;
        if (this.sourceDimensions == null || TransformSeparator.containsAll(this.sourceDimensions, 0, mathTransform.getSourceDimensions())) {
            if (this.targetDimensions != null && !TransformSeparator.containsAll(this.targetDimensions, 0, mathTransform.getTargetDimensions())) {
                mathTransform = this.filterTargetDimensions(mathTransform, this.targetDimensions);
            }
            if (this.sourceDimensions == null) {
                this.sourceDimensions = TransformSeparator.series(0, this.transform.getSourceDimensions());
            }
            if (this.targetDimensions == null) {
                this.targetDimensions = TransformSeparator.series(0, this.transform.getTargetDimensions());
            }
        } else {
            int[] nArray = this.targetDimensions;
            mathTransform = this.filterSourceDimensions(mathTransform, this.sourceDimensions);
            assert (ArraysExt.isSorted(this.targetDimensions, true)) : "targetDimensions";
            if (nArray != null) {
                int[] nArray2 = this.targetDimensions;
                this.targetDimensions = nArray;
                int[] nArray3 = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    int n2 = Arrays.binarySearch(nArray2, n);
                    if (n2 < 0) {
                        throw new FactoryException(Resources.format((short)7, n));
                    }
                    nArray3[i] = n2;
                }
                mathTransform = this.filterTargetDimensions(mathTransform, nArray3);
            }
        }
        int n = 0;
        int n3 = this.sourceDimensions.length;
        int n4 = mathTransform.getSourceDimensions();
        if (n4 == n3) {
            n = 1;
            n3 = this.targetDimensions.length;
            n4 = mathTransform.getTargetDimensions();
            if (n4 == n3) {
                return mathTransform;
            }
        }
        throw new FactoryException(Resources.format((short)37, n, n3, n4));
    }

    protected MathTransform filterSourceDimensions(MathTransform mathTransform, int[] nArray) throws FactoryException {
        int n;
        int n2;
        int n3;
        int n4;
        PassThroughTransform passThroughTransform;
        if (nArray.length == 0) {
            return IdentityTransform.create(0);
        }
        int n5 = mathTransform.getSourceDimensions();
        int n6 = mathTransform.getTargetDimensions();
        int n7 = nArray[0];
        int n8 = nArray[nArray.length - 1] + 1;
        if (n7 == 0 && n8 == n5 && nArray.length == n5) {
            this.targetDimensions = TransformSeparator.series(0, n6);
            return mathTransform;
        }
        if (mathTransform.isIdentity()) {
            this.targetDimensions = nArray;
            return IdentityTransform.create(nArray.length);
        }
        if (mathTransform instanceof ConcatenatedTransform) {
            ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)mathTransform;
            MathTransform mathTransform2 = this.filterSourceDimensions(concatenatedTransform.transform1, nArray);
            MathTransform mathTransform3 = this.filterSourceDimensions(concatenatedTransform.transform2, this.targetDimensions);
            return this.factory.createConcatenatedTransform(mathTransform2, mathTransform3);
        }
        if (mathTransform instanceof PassThroughTransform) {
            passThroughTransform = (PassThroughTransform)mathTransform;
            n4 = passThroughTransform.subTransform.getSourceDimensions();
            n3 = passThroughTransform.subTransform.getTargetDimensions() - n4;
            n2 = passThroughTransform.firstAffectedOrdinate;
            int n9 = n2 + n4;
            int[] nArray2 = new int[nArray.length];
            this.targetDimensions = null;
            n = 0;
            for (int n10 : nArray) {
                if (n10 >= n2) {
                    if (n10 < n9) {
                        nArray2[n++] = n10 - n2;
                        continue;
                    }
                    n10 += n3;
                }
                this.targetDimensions = TransformSeparator.insert(this.targetDimensions, n10);
            }
            nArray2 = ArraysExt.resize(nArray2, n);
            if (n == 0) {
                return IdentityTransform.create(nArray.length);
            }
            int[] nArray3 = this.targetDimensions;
            MathTransform mathTransform4 = this.filterSourceDimensions(passThroughTransform.subTransform, nArray2);
            for (int n11 : this.targetDimensions) {
                nArray3 = TransformSeparator.insert(nArray3, n11 + n2);
            }
            this.targetDimensions = nArray3;
            if (TransformSeparator.containsAll(nArray, n7, n2) && TransformSeparator.containsAll(nArray, n9, n8)) {
                return this.factory.createPassThroughTransform(n2 - n7, mathTransform4, Math.max(0, n8 - n9));
            }
        }
        if ((passThroughTransform = MathTransforms.getMatrix(mathTransform)) != null) {
            this.targetDimensions = null;
            n4 = 0;
            n3 = 0;
            n2 = nArray.length + 1;
            double[] dArray = new double[(n6 + 1) * n2];
            block2: for (int i = 0; i <= n6; ++i) {
                n = 0;
                for (int j = 0; j < n5; ++j) {
                    double d = passThroughTransform.getElement(i, j);
                    if (n < nArray.length && nArray[n] == j) {
                        dArray[n4 + n++] = d;
                        continue;
                    }
                    if (d != 0.0) continue block2;
                }
                dArray[n4 + n++] = passThroughTransform.getElement(i, n5);
                assert (n == n2) : n;
                n4 += n2;
                if (i == n6) {
                    n3 = 1;
                    continue;
                }
                this.targetDimensions = TransformSeparator.insert(this.targetDimensions, i);
            }
            if (n3 != 0) {
                dArray = ArraysExt.resize(dArray, n4);
                return this.factory.createAffineTransform((Matrix)Matrices.create(n4 / n2, n2, dArray));
            }
        }
        throw new FactoryException(Resources.format((short)59));
    }

    protected MathTransform filterTargetDimensions(MathTransform mathTransform, int[] nArray) throws FactoryException {
        int n;
        int n2;
        LenientComparable lenientComparable;
        int n3 = mathTransform.getSourceDimensions();
        int n4 = mathTransform.getTargetDimensions();
        int n5 = nArray[0];
        int n6 = nArray[nArray.length - 1];
        if (n5 == 0 && n6 == n4 && nArray.length == n4) {
            return mathTransform;
        }
        int n7 = 0;
        int n8 = 0;
        if (mathTransform instanceof PassThroughTransform) {
            lenientComparable = (PassThroughTransform)mathTransform;
            n2 = lenientComparable.firstAffectedOrdinate;
            n = lenientComparable.subTransform.getTargetDimensions();
            if (!TransformSeparator.containsAny(nArray, n2, n2 + n)) {
                n4 = n3;
                mathTransform = IdentityTransform.create(n4);
                n7 = n2;
                n8 = n - lenientComparable.subTransform.getSourceDimensions();
            }
        }
        lenientComparable = Matrices.createZero(nArray.length + 1, n4 + 1);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n >= n7) {
                n -= n8;
            }
            lenientComparable.setElement(n2, n, 1.0);
        }
        lenientComparable.setElement(nArray.length, n4, 1.0);
        return this.factory.createConcatenatedTransform(mathTransform, this.factory.createAffineTransform((Matrix)lenientComparable));
    }

    private static boolean containsAll(int[] nArray, int n, int n2) {
        if (n >= n2) {
            return true;
        }
        if (nArray != null) {
            assert (ArraysExt.isSorted(nArray, true));
            int n3 = Arrays.binarySearch(nArray, n);
            if (n3 >= 0 && (n3 += --n2 - n) >= 0 && n3 < nArray.length) {
                return nArray[n3] == n2;
            }
        }
        return false;
    }

    private static boolean containsAny(int[] nArray, int n, int n2) {
        if (n2 == n) {
            return true;
        }
        if (nArray != null) {
            assert (ArraysExt.isSorted(nArray, true));
            int n3 = Arrays.binarySearch(nArray, n);
            if (n3 >= 0) {
                return true;
            }
            return (n3 ^= 0xFFFFFFFF) < nArray.length && nArray[n3] < n2;
        }
        return false;
    }
}

