/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.Line;
import org.apache.sis.math.Plane;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.operation.builder.TransformBuilder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

public class LinearTransformBuilder
extends TransformBuilder {
    private final int[] gridSize;
    private double[][] sources;
    private double[][] targets;
    final int gridLength;
    private int numPoints;
    private transient LinearTransform transform;
    private transient double[] correlation;
    @Deprecated
    private transient DirectPosition[] pendingSources;
    @Deprecated
    private transient DirectPosition[] pendingTargets;

    public LinearTransformBuilder() {
        this.gridSize = null;
        this.gridLength = 0;
    }

    public LinearTransformBuilder(int ... nArray) {
        ArgumentChecks.ensureNonNull("gridSize", nArray);
        if (nArray.length == 0) {
            this.gridSize = null;
            this.gridLength = 0;
        } else {
            nArray = (int[])nArray.clone();
            long l = 1L;
            for (int n : nArray) {
                ArgumentChecks.ensureStrictlyPositive("gridSize", n);
                l = JDK8.multiplyExact(l, (long)n);
            }
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(Errors.format((short)166, "\u220fgridSize", 1, Integer.MAX_VALUE, l));
            }
            this.gridSize = nArray;
            this.gridLength = (int)l;
        }
    }

    final int gridSize(int n) {
        return this.gridSize[n];
    }

    private void allocate(int n) {
        for (double[] dArray : this.targets = new double[n][this.gridLength]) {
            Arrays.fill(dArray, Double.NaN);
        }
    }

    private static void resize(double[][] dArray, int n) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ArraysExt.resize(dArray[i], n);
        }
    }

    private int search(int[] nArray) {
        assert (this.gridSize == null);
        block0: for (int i = 0; i < this.numPoints; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                if ((double)nArray[j] != this.sources[j][i]) continue block0;
            }
            return i;
        }
        return -1;
    }

    private int flatIndex(int[] nArray) {
        assert (this.sources == null);
        int n = 0;
        int n2 = this.gridSize.length;
        while (n2 != 0) {
            int n3 = this.gridSize[--n2];
            int n4 = nArray[n2];
            if (n4 < 0 || n4 >= n3) {
                throw new IllegalArgumentException(Errors.format((short)166, "source", 0, n3 - 1, n4));
            }
            n = n * n3 + n4;
        }
        return n;
    }

    private int flatIndex(DirectPosition directPosition) {
        assert (this.sources == null);
        int n = 0;
        int n2 = this.gridSize.length;
        while (n2 != 0) {
            int n3 = this.gridSize[--n2];
            double d = directPosition.getOrdinate(n2);
            int n4 = (int)d;
            if ((double)n4 != d) {
                throw new IllegalArgumentException(Errors.format((short)171, d));
            }
            if (n4 < 0 || n4 >= n3) {
                throw new IllegalArgumentException(Errors.format((short)166, "source", 0, n3 - 1, n4));
            }
            n = n * n3 + n4;
        }
        return n;
    }

    private void verifySourceDimension(int n) {
        int n2;
        if (this.gridSize != null) {
            n2 = this.gridSize.length;
        } else if (this.sources != null) {
            n2 = this.sources.length;
        } else {
            return;
        }
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format((short)81, "source", n2, n));
        }
    }

    private String mismatchedDimension(String string, int n, int n2) {
        return Errors.format((short)81, string + '[' + this.numPoints + ']', n, n2);
    }

    private static String noData() {
        return Errors.format((short)89, "sourceToTarget");
    }

    public int getSourceDimensions() {
        if (this.gridSize != null) {
            return this.gridSize.length;
        }
        if (this.sources != null) {
            return this.sources.length;
        }
        throw new IllegalStateException(LinearTransformBuilder.noData());
    }

    public int getTargetDimensions() {
        if (this.targets != null) {
            return this.targets.length;
        }
        throw new IllegalStateException(LinearTransformBuilder.noData());
    }

    private static DirectPosition position(Position position) {
        return position != null ? position.getDirectPosition() : null;
    }

    public void setControlPoints(Map<? extends Position, ? extends Position> map) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("sourceToTarget", map);
        this.pendingSources = null;
        this.pendingTargets = null;
        this.transform = null;
        this.correlation = null;
        this.sources = null;
        this.targets = null;
        this.numPoints = 0;
        int n = 0;
        int n2 = 0;
        for (Map.Entry<? extends Position, ? extends Position> entry : map.entrySet()) {
            int n3;
            int n4;
            int n5;
            DirectPosition directPosition;
            DirectPosition directPosition2 = LinearTransformBuilder.position(entry.getKey());
            if (directPosition2 == null || (directPosition = LinearTransformBuilder.position(entry.getValue())) == null) continue;
            if (this.targets == null) {
                n2 = directPosition.getDimension();
                if (n2 <= 0) {
                    throw new MismatchedDimensionException(this.mismatchedDimension("target", 2, n2));
                }
                if (this.gridSize == null) {
                    n = directPosition2.getDimension();
                    if (n <= 0) {
                        throw new MismatchedDimensionException(this.mismatchedDimension("source", 2, n));
                    }
                    n5 = map.size();
                    this.sources = new double[n][n5];
                    this.targets = new double[n2][n5];
                } else {
                    n = this.gridSize.length;
                    this.allocate(n2);
                }
            }
            if ((n5 = directPosition2.getDimension()) != n) {
                throw new MismatchedDimensionException(this.mismatchedDimension("source", n, n5));
            }
            n5 = directPosition.getDimension();
            if (n5 != n2) {
                throw new MismatchedDimensionException(this.mismatchedDimension("target", n2, n5));
            }
            if (this.gridSize != null) {
                n4 = this.flatIndex(directPosition2);
            } else {
                n4 = this.numPoints;
                for (n3 = 0; n3 < n; ++n3) {
                    this.sources[n3][n4] = directPosition2.getOrdinate(n3);
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.targets[n3][n4] = directPosition.getOrdinate(n3);
            }
            ++this.numPoints;
        }
    }

    public void setControlPoint(int[] nArray, double[] dArray) {
        int n;
        int n2;
        ArgumentChecks.ensureNonNull("source", nArray);
        ArgumentChecks.ensureNonNull("target", dArray);
        this.verifySourceDimension(nArray.length);
        int n3 = dArray.length;
        if (this.targets != null && n3 != this.targets.length) {
            throw new MismatchedDimensionException(Errors.format((short)81, "target", this.targets.length, n3));
        }
        if (this.gridSize != null) {
            n2 = this.flatIndex(nArray);
            if (this.targets == null) {
                this.allocate(n3);
            }
        } else {
            int n4;
            n = nArray.length;
            if (this.targets == null) {
                this.targets = new double[n3][20];
                this.sources = new double[n][20];
            }
            if ((n2 = this.search(nArray)) < 0) {
                n2 = this.numPoints++;
                if (this.numPoints >= this.targets[0].length) {
                    n4 = JDK8.multiplyExact(this.numPoints, 2);
                    LinearTransformBuilder.resize(this.sources, n4);
                    LinearTransformBuilder.resize(this.targets, n4);
                }
            }
            for (n4 = 0; n4 < n; ++n4) {
                this.sources[n4][n2] = nArray[n4];
            }
        }
        for (n = 0; n < n3; ++n) {
            this.targets[n][n2] = dArray[n];
        }
    }

    public double[] getControlPoint(int[] nArray) {
        int n;
        this.processPendings();
        ArgumentChecks.ensureNonNull("source", nArray);
        this.verifySourceDimension(nArray.length);
        if (this.targets == null) {
            return null;
        }
        if (this.gridSize != null) {
            n = this.flatIndex(nArray);
        } else {
            n = this.search(nArray);
            if (n < 0) {
                return null;
            }
        }
        boolean bl = true;
        double[] dArray = new double[this.targets.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.targets[i][n];
            bl &= Double.isNaN(dArray[i]);
        }
        return bl ? null : dArray;
    }

    final void getControlPoint2D(int[] nArray, double[] dArray) {
        assert (this.gridSize != null);
        int n = this.flatIndex(nArray);
        int n2 = this.targets.length;
        for (int i = 0; i < n2; ++i) {
            dArray[i] = this.targets[i][n];
        }
    }

    @Deprecated
    public void setSourcePoints(DirectPosition ... directPositionArray) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("points", directPositionArray);
        this.transform = null;
        this.correlation = null;
        this.sources = null;
        this.targets = null;
        this.numPoints = 0;
        this.pendingSources = (DirectPosition[])directPositionArray.clone();
    }

    @Deprecated
    public void setTargetPoints(DirectPosition ... directPositionArray) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("points", directPositionArray);
        this.transform = null;
        this.correlation = null;
        this.sources = null;
        this.targets = null;
        this.numPoints = 0;
        this.pendingTargets = (DirectPosition[])directPositionArray.clone();
    }

    @Deprecated
    private void processPendings() {
        if (this.pendingSources != null || this.pendingTargets != null) {
            if (this.pendingSources == null || this.pendingTargets == null) {
                throw new IllegalStateException(Errors.format((short)89, this.pendingSources == null ? "sources" : "targets"));
            }
            int n = this.pendingSources.length;
            if (this.pendingTargets.length != n) {
                throw new IllegalStateException(Errors.format((short)77));
            }
            HashMap<DirectPosition, DirectPosition> hashMap = new HashMap<DirectPosition, DirectPosition>(n);
            for (int i = 0; i < n; ++i) {
                hashMap.put(this.pendingSources[i], this.pendingTargets[i]);
            }
            this.setControlPoints(hashMap);
        }
    }

    @Deprecated
    public LinearTransform create() {
        try {
            return this.create(null);
        }
        catch (FactoryException factoryException) {
            throw new RuntimeException(factoryException);
        }
    }

    @Override
    public LinearTransform create(MathTransformFactory mathTransformFactory) throws FactoryException {
        if (this.transform == null) {
            this.processPendings();
            double[][] dArray = this.sources;
            double[][] dArray2 = this.targets;
            if (dArray2 == null) {
                throw new FactoryException(LinearTransformBuilder.noData());
            }
            int n = dArray != null ? dArray.length : this.gridSize.length;
            int n2 = dArray2.length;
            this.correlation = new double[n2];
            final MatrixSIS matrixSIS = Matrices.create(n2 + 1, n + 1, ExtendedPrecisionMatrix.ZERO);
            matrixSIS.setElement(n2, n, 1.0);
            for (int i = 0; i < n2; ++i) {
                double d;
                switch (n) {
                    case 1: {
                        final int n3 = i;
                        Cloneable cloneable = new Line(){

                            @Override
                            public void setEquation(Number number, Number number2) {
                                super.setEquation(number, number2);
                                matrixSIS.setNumber(n3, 0, number);
                                matrixSIS.setNumber(n3, 1, number2);
                            }
                        };
                        if (dArray != null) {
                            d = ((Line)cloneable).fit(this.vector(dArray[0]), this.vector(dArray2[i]));
                            break;
                        }
                        d = ((Line)cloneable).fit(Vector.createSequence(0, 1, this.gridSize[0]), Vector.create(dArray2[i], false));
                        break;
                    }
                    case 2: {
                        final int n3 = i;
                        Cloneable cloneable = new Plane(){

                            @Override
                            public void setEquation(Number number, Number number2, Number number3) {
                                super.setEquation(number, number2, number3);
                                matrixSIS.setNumber(n3, 0, number);
                                matrixSIS.setNumber(n3, 1, number2);
                                matrixSIS.setNumber(n3, 2, number3);
                            }
                        };
                        if (dArray != null) {
                            d = ((Plane)cloneable).fit(this.vector(dArray[0]), this.vector(dArray[1]), this.vector(dArray2[i]));
                            break;
                        }
                        try {
                            d = ((Plane)cloneable).fit(this.gridSize[0], this.gridSize[1], Vector.create(dArray2[i], false));
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new FactoryException(LinearTransformBuilder.noData(), (Throwable)illegalArgumentException);
                        }
                    }
                    default: {
                        throw new FactoryException(Errors.format((short)37, n));
                    }
                }
                this.correlation[i] = d;
            }
            this.transform = (LinearTransform)LinearTransformBuilder.nonNull(mathTransformFactory).createAffineTransform((Matrix)matrixSIS);
        }
        return this.transform;
    }

    private Vector vector(double[] dArray) {
        assert (this.gridSize == null);
        return Vector.create(dArray, false).subList(0, this.numPoints);
    }

    public double[] correlation() {
        return this.correlation != null ? (double[])this.correlation.clone() : null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(this)).append('[');
        if (this.sources != null) {
            stringBuilder.append(this.sources[0].length).append(" points");
        }
        stringBuilder.append(']');
        if (this.transform != null) {
            String string = System.lineSeparator();
            stringBuilder.append(':').append(string);
            TableAppender tableAppender = new TableAppender(stringBuilder, " ");
            tableAppender.setMultiLinesCells(true);
            tableAppender.append(Matrices.toString(this.transform.getMatrix())).nextColumn();
            tableAppender.append(string).append("  ").append(Vocabulary.format((short)19)).append(" =").nextColumn();
            tableAppender.append(Matrices.create(this.correlation.length, 1, this.correlation).toString());
            try {
                tableAppender.flush();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
        return stringBuilder.toString();
    }
}

