/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.SignReversalComment;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.InternationalString;

@XmlTransient
final class InverseOperationMethod
extends DefaultOperationMethod {
    private static final long serialVersionUID = 6395008927817202180L;
    private final OperationMethod inverse;

    private InverseOperationMethod(Map<String, ?> map, OperationMethod operationMethod) {
        super(map, operationMethod.getTargetDimensions(), operationMethod.getSourceDimensions(), operationMethod.getParameters());
        this.inverse = operationMethod;
    }

    private static boolean isInvertible(OperationMethod operationMethod) {
        return operationMethod instanceof AbstractProvider && ((AbstractProvider)operationMethod).isInvertible();
    }

    static OperationMethod create(OperationMethod operationMethod) {
        if (operationMethod instanceof InverseOperationMethod) {
            return ((InverseOperationMethod)operationMethod).inverse;
        }
        if (!InverseOperationMethod.isInvertible(operationMethod)) {
            Object object;
            boolean bl = false;
            ReferenceIdentifier referenceIdentifier = operationMethod.getParameters().descriptors().iterator();
            while (referenceIdentifier.hasNext() && (bl = (object = (GeneralParameterDescriptor)referenceIdentifier.next()).getRemarks() instanceof SignReversalComment)) {
            }
            if (!bl) {
                referenceIdentifier = operationMethod.getName();
                referenceIdentifier = new ImmutableIdentifier(null, null, "Inverse of " + referenceIdentifier.getCode());
                object = new HashMap(6);
                object.put("name", referenceIdentifier);
                object.put("formula", operationMethod.getFormula());
                object.put("remarks", operationMethod.getRemarks());
                if (operationMethod instanceof Deprecable) {
                    object.put("deprecated", ((Deprecable)operationMethod).isDeprecated());
                }
                return new InverseOperationMethod((Map<String, ?>)object, operationMethod);
            }
        }
        return operationMethod;
    }

    static void properties(SingleOperation singleOperation, Map<String, Object> map) {
        map.put("domainOfValidity", singleOperation.getDomainOfValidity());
        Collection collection = singleOperation.getCoordinateOperationAccuracy();
        if (!Containers.isNullOrEmpty(collection)) {
            map.put("coordinateOperationAccuracy", collection.toArray(new PositionalAccuracy[collection.size()]));
        }
        ParameterValueGroup parameterValueGroup = singleOperation.getParameterValues();
        ParameterValueGroup parameterValueGroup2 = parameterValueGroup.getDescriptor().createValue();
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            ParameterDescriptor parameterDescriptor;
            InternationalString internationalString;
            ParameterValue parameterValue;
            Object object;
            if (generalParameterValue instanceof ParameterValue && (object = (parameterValue = (ParameterValue)generalParameterValue).getValue()) instanceof Number && (internationalString = (parameterDescriptor = parameterValue.getDescriptor()).getRemarks()) != SignReversalComment.SAME) {
                if (internationalString != SignReversalComment.OPPOSITE) {
                    return;
                }
                ParameterValue parameterValue2 = parameterValueGroup2.parameter(parameterDescriptor.getName().getCode());
                Unit unit = parameterValue.getUnit();
                if (unit != null) {
                    parameterValue2.setValue(-parameterValue.doubleValue(), unit);
                    continue;
                }
                if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
                    parameterValue2.setValue(-parameterValue.intValue());
                    continue;
                }
                parameterValue2.setValue(-parameterValue.doubleValue());
                continue;
            }
            parameterValueGroup2.values().add(generalParameterValue);
        }
        map.put("parameters", parameterValueGroup2);
    }
}

