/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.referencing.CC_Conversion;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.ConversionKeys;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

@XmlType(name="AbstractGeneralDerivedCRSType")
@XmlRootElement(name="AbstractGeneralDerivedCRS")
@XmlSeeAlso(value={DefaultDerivedCRS.class, DefaultProjectedCRS.class})
abstract class AbstractDerivedCRS<C extends Conversion>
extends AbstractCRS
implements GeneralDerivedCRS {
    private static final long serialVersionUID = -175151161496419854L;
    private C conversionFromBase;

    AbstractDerivedCRS(Map<String, ?> map, SingleCRS singleCRS, Conversion conversion, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        super(map, coordinateSystem);
        ArgumentChecks.ensureNonNull("baseCRS", singleCRS);
        ArgumentChecks.ensureNonNull("conversion", conversion);
        MathTransform mathTransform = conversion.getMathTransform();
        if (mathTransform != null) {
            ArgumentChecks.ensureDimensionMatches("baseCRS", mathTransform.getSourceDimensions(), (CoordinateReferenceSystem)singleCRS);
            ArgumentChecks.ensureDimensionMatches("derivedCS", mathTransform.getTargetDimensions(), coordinateSystem);
        }
        this.conversionFromBase = this.createConversionFromBase(map, singleCRS, conversion);
    }

    AbstractDerivedCRS(Map<String, ?> map, SingleCRS singleCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        super(map, coordinateSystem);
        ArgumentChecks.ensureNonNull("baseCRS", singleCRS);
        ArgumentChecks.ensureNonNull("method", operationMethod);
        ArgumentChecks.ensureNonNull("baseToDerived", mathTransform);
        this.conversionFromBase = new DefaultConversion(ConversionKeys.unprefix(map), (CoordinateReferenceSystem)singleCRS, this, coordinateReferenceSystem, operationMethod, mathTransform);
    }

    AbstractDerivedCRS(GeneralDerivedCRS generalDerivedCRS) {
        super((CoordinateReferenceSystem)generalDerivedCRS);
        this.conversionFromBase = this.createConversionFromBase(null, (SingleCRS)generalDerivedCRS.getBaseCRS(), generalDerivedCRS.getConversionFromBase());
    }

    private C createConversionFromBase(Map<String, ?> map, SingleCRS singleCRS, Conversion conversion) {
        MathTransformFactory mathTransformFactory = null;
        if (map != null) {
            mathTransformFactory = (MathTransformFactory)map.get("mtFactory");
        }
        if (mathTransformFactory == null) {
            mathTransformFactory = DefaultFactories.forBuildin(MathTransformFactory.class);
        }
        try {
            return DefaultConversion.castOrCopy(conversion).specialize(this.getConversionType(), (CoordinateReferenceSystem)singleCRS, this, mathTransformFactory);
        }
        catch (FactoryException factoryException) {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)45, "conversion", conversion.getName()), factoryException);
        }
    }

    abstract Class<C> getConversionType();

    public abstract Class<? extends GeneralDerivedCRS> getInterface();

    @Override
    public abstract Datum getDatum();

    @XmlElement(name="conversion", required=true)
    public C getConversionFromBase() {
        return this.conversionFromBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            boolean bl;
            boolean bl2 = bl = comparisonMode == ComparisonMode.STRICT;
            if (Semaphores.queryAndSet(4)) {
                return true;
            }
            try {
                boolean bl3 = Utilities.deepEquals(bl ? this.conversionFromBase : this.getConversionFromBase(), bl ? ((AbstractDerivedCRS)object).conversionFromBase : ((GeneralDerivedCRS)object).getConversionFromBase(), comparisonMode);
                return bl3;
            }
            finally {
                Semaphores.clear(4);
            }
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.conversionFromBase.getSourceCRS().hashCode()) + (long)(37 * this.conversionFromBase.getMathTransform().hashCode());
    }

    AbstractDerivedCRS() {
    }

    private void setConversionFromBase(C c) {
        if (this.conversionFromBase == null) {
            this.conversionFromBase = c;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractDerivedCRS.class, "setConversionFromBase", "conversion");
        }
    }

    final void setBaseCRS(String string, SingleCRS singleCRS) {
        if (this.conversionFromBase != null) {
            SingleCRS singleCRS2 = CC_Conversion.setBaseCRS(this.conversionFromBase, singleCRS);
            if (singleCRS2 != null) {
                CC_Conversion.setBaseCRS(this.conversionFromBase, singleCRS2);
                MetadataUtilities.propertyAlreadySet(AbstractDerivedCRS.class, "setBaseCRS", string);
            }
        } else {
            throw new IllegalStateException(Errors.format((short)85, this.getInterface(), "conversion"));
        }
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object object) throws ValidationException {
        String string = "conversion";
        if (this.conversionFromBase != null) {
            SingleCRS singleCRS = CC_Conversion.setBaseCRS(this.conversionFromBase, null);
            string = "coordinateSystem";
            if (super.getCoordinateSystem() != null) {
                string = "baseCRS";
                if (singleCRS != null) {
                    this.conversionFromBase = this.createConversionFromBase(null, singleCRS, (Conversion)this.conversionFromBase);
                    return;
                }
            }
        }
        throw new ValidationException(Errors.format((short)89, string));
    }
}

