/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.owl;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.semanticweb.owlapi.formats.LabelFunctionalDocumentFormat;
import org.semanticweb.owlapi.functional.renderer.FunctionalSyntaxObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.AbstractOWLStorer;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.StringComparator;

@ParametersAreNonnullByDefault
public class LabelFunctionalSyntaxStorer
extends AbstractOWLStorer {
    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return ontologyFormat instanceof LabelFunctionalDocumentFormat;
    }

    protected void storeOntology(OWLOntology ontology, PrintWriter writer, OWLDocumentFormat format) throws OWLOntologyStorageException {
        try {
            FunctionalSyntaxObjectRenderer renderer = new FunctionalSyntaxObjectRenderer(ontology, (Writer)writer);
            renderer.setPrefixManager((PrefixManager)new LabelPrefixManager(ontology));
            ontology.accept((OWLObjectVisitor)renderer);
            writer.flush();
        }
        catch (OWLRuntimeException e) {
            throw new OWLOntologyStorageException((Throwable)e);
        }
    }

    static class LabelPrefixManager
    implements PrefixManager {
        private final OWLOntology ontology;
        private final PrefixManager delegate;

        LabelPrefixManager(OWLOntology ontology) {
            this.ontology = ontology;
            OWLDocumentFormat ontologyFormat = ontology.getFormat();
            this.delegate = ontologyFormat instanceof PrefixManager ? (PrefixManager)ontologyFormat : new DefaultPrefixManager();
        }

        @Nullable
        public String getPrefixIRI(IRI iri) {
            for (OWLAnnotationAssertionAxiom annotation : OWLAPIStreamUtils.asList((Stream)this.ontology.annotationAssertionAxioms((OWLAnnotationSubject)iri))) {
                OWLAnnotationValue value;
                if (!((OWLAnnotationProperty)annotation.getProperty()).isLabel() || !((value = annotation.getValue()) instanceof OWLLiteral)) continue;
                return '<' + ((OWLLiteral)value).getLiteral() + '>';
            }
            return this.delegate.getPrefixIRI(iri);
        }

        @Nullable
        public String getDefaultPrefix() {
            return this.delegate.getDefaultPrefix();
        }

        public void setDefaultPrefix(@Nullable String defaultPrefix) {
        }

        public boolean containsPrefixMapping(String prefixName) {
            return this.delegate.containsPrefixMapping(prefixName);
        }

        @Nullable
        public String getPrefix(String prefixName) {
            return this.delegate.getPrefix(prefixName);
        }

        public Map<String, String> getPrefixName2PrefixMap() {
            return this.delegate.getPrefixName2PrefixMap();
        }

        public IRI getIRI(String prefixIRI) {
            return this.delegate.getIRI(prefixIRI);
        }

        public Stream<String> prefixNames() {
            return this.delegate.prefixNames();
        }

        public StringComparator getPrefixComparator() {
            return this.delegate.getPrefixComparator();
        }

        public void setPrefixComparator(StringComparator comparator) {
            this.delegate.setPrefixComparator(comparator);
        }

        public void setPrefix(String prefixName, String prefix) {
        }

        public void copyPrefixesFrom(PrefixManager from) {
        }

        public void copyPrefixesFrom(Map<String, String> from) {
        }

        public void unregisterNamespace(String namespace) {
        }

        public void clear() {
        }
    }
}

