/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.CASAdminException;
import org.apache.uima.cas.impl.BuiltinTypeKinds;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.impl.Constants;

public class TypeImpl
implements Type,
Comparable<TypeImpl> {
    private final String name;
    private final String shortName;
    private final String jcasClassName;
    private final short typeCode;
    private short depthFirstCode;
    private short depthFirstNextSibling;
    private final TypeSystemImpl tsi;
    final SlotKinds.SlotKind slotKind;
    protected Class<?> javaClass;
    protected boolean isFeatureFinal;
    protected boolean isInheritanceFinal;
    protected final boolean isLongOrDouble;
    protected boolean isBuiltIn;
    int nbrOfLongOrDoubleFeatures = 0;
    protected final boolean isCreatableAndNotBuiltinArray;
    public final boolean isRefType;
    boolean hasRefFeature;
    private final TypeImpl superType;
    private final TypeImpl[] allSuperTypes;
    private final List<TypeImpl> directSubtypes = new ArrayList<TypeImpl>();
    private final Map<String, FeatureImpl> staticMergedFeatures = new LinkedHashMap<String, FeatureImpl>(1);
    private FeatureImpl[] staticMergedFeaturesList = null;
    private final List<FeatureImpl> staticMergedFeaturesIntroducedByThisType = new ArrayList<FeatureImpl>(0);
    private FeatureImpl[] staticMergedIntFeaturesList;
    private FeatureImpl[] staticMergedRefFeaturesList;
    private FeatureImpl[] staticMergedNonSofaFsRefs;
    int nbrOfUsedIntDataSlots = -1;
    int nbrOfUsedRefDataSlots = -1;
    int highestOffset = -1;
    public static final TypeImpl singleton = new TypeImpl();
    private long hashCodeLong = 0L;
    private final long hashCodeNameLong;
    private boolean hasHashCodeLong = false;

    private TypeImpl() {
        this.name = null;
        this.shortName = null;
        this.jcasClassName = null;
        this.superType = null;
        this.isInheritanceFinal = false;
        this.isFeatureFinal = false;
        this.isLongOrDouble = false;
        this.isCreatableAndNotBuiltinArray = false;
        this.tsi = null;
        this.typeCode = 0;
        this.isRefType = false;
        this.javaClass = null;
        this.slotKind = TypeSystemImpl.getSlotKindFromType(this);
        this.allSuperTypes = null;
        this.hashCodeNameLong = Misc.hashStringLong(this.name);
    }

    TypeImpl(String name, TypeSystemImpl tsi, TypeImpl supertype) {
        this(name, tsi, supertype, supertype.javaClass);
    }

    TypeImpl(String name, TypeSystemImpl tsi, TypeImpl supertype, Class<?> javaClass) {
        if (this.isStringSubtype() && supertype == tsi.stringType) {
            tsi.newTypeCheckNoInheritanceFinalCheck(name, supertype);
        } else {
            tsi.newTypeChecks(name, supertype);
        }
        this.name = name;
        this.jcasClassName = Misc.typeName2ClassName(name);
        int pos = this.name.lastIndexOf(46);
        this.shortName = pos >= 0 ? this.name.substring(pos + 1) : name;
        this.superType = supertype;
        this.isInheritanceFinal = false;
        this.isFeatureFinal = false;
        this.isLongOrDouble = name.equals("uima.cas.Long") || name.equals("uima.cas.Double");
        this.tsi = tsi;
        if (tsi.types.size() > Short.MAX_VALUE) {
            throw new RuntimeException("Too many types declared, max is 32767.");
        }
        this.typeCode = (short)tsi.types.size();
        tsi.types.add(this);
        TypeImpl node = supertype;
        ArrayList<TypeImpl> a = new ArrayList<TypeImpl>();
        while (node != null) {
            a.add(node);
            node = node.superType;
        }
        this.allSuperTypes = a.toArray(new TypeImpl[a.size()]);
        if (null != this.superType) {
            this.superType.directSubtypes.add(this);
            if (this.superType.staticMergedFeatures != null) {
                this.staticMergedFeatures.putAll(this.superType.staticMergedFeatures);
            }
        }
        this.isCreatableAndNotBuiltinArray = (tsi.stringType == null || supertype != tsi.stringType) && !BuiltinTypeKinds.nonCreatableTypesAndBuiltinArrays_contains(name);
        this.isRefType = tsi.classifyAsRefType(name, supertype);
        this.javaClass = javaClass;
        tsi.typeName2TypeImpl.put(name, this);
        this.slotKind = TypeSystemImpl.getSlotKindFromType(this);
        this.hasRefFeature = name.equals("uima.cas.FSArray");
        this.hashCodeNameLong = Misc.hashStringLong(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getJCasClassName() {
        return this.jcasClassName;
    }

    public TypeImpl getSuperType() {
        return this.superType;
    }

    public int getCode() {
        return this.typeCode;
    }

    public String toString() {
        return this.getName();
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " [name: ").append(this.name).append(", superType: ").append(this.superType == null ? "<null>" : this.superType.getName()).append(", ");
        this.prettyPrintList(sb, "directSubtypes", this.directSubtypes, (sbx, ti) -> sbx.append(ti.getName()));
        sb.append(", ");
        this.appendIntroFeats(sb, indent);
        return sb.toString();
    }

    private <T> void prettyPrintList(StringBuilder sb, String title, List<T> items, BiConsumer<StringBuilder, T> appender) {
        sb.append(title).append(": ");
        Misc.addElementsToStringBuilder(sb, items, appender);
    }

    public void prettyPrint(StringBuilder sb, int indent) {
        Misc.indent(sb, indent).append(this.name).append(": super: ").append(null == this.superType ? "<null>" : this.superType.getName());
        if (this.staticMergedFeaturesIntroducedByThisType.size() > 0) {
            sb.append(", ");
            this.appendIntroFeats(sb, indent);
        }
        sb.append('\n');
    }

    public void prettyPrintWithSubTypes(StringBuilder sb, int indent) {
        this.prettyPrint(sb, indent);
        int nextIndent = indent + 2;
        this.directSubtypes.stream().forEachOrdered(ti -> ti.prettyPrint(sb, nextIndent));
    }

    private void appendIntroFeats(StringBuilder sb, int indent) {
        this.prettyPrintList(sb, "FeaturesIntroduced/Range/multiRef", this.staticMergedFeaturesIntroducedByThisType, (sbx, fi) -> Misc.indent(sbx.append('\n'), indent + 2).append(fi.getShortName()).append('/').append(fi.getRange().getName()).append('/').append(fi.isMultipleReferencesAllowed() ? (char)'T' : (char)'F'));
    }

    @Override
    @Deprecated
    public Vector<Feature> getAppropriateFeatures() {
        return new Vector<Feature>(this.getFeatures());
    }

    @Override
    public int getNumberOfFeatures() {
        return this.staticMergedFeatures.size();
    }

    public boolean isAppropriateFeature(Feature feature) {
        TypeImpl domain = (TypeImpl)feature.getDomain();
        return domain.subsumes(this);
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isAnnotationBaseType() {
        return false;
    }

    public boolean isCreatableAndNotBuiltinArray() {
        return this.isCreatableAndNotBuiltinArray;
    }

    public TypeSystemImpl getTypeSystem() {
        return this.tsi;
    }

    @Override
    public FeatureImpl getFeatureByBaseName(String featureShortName) {
        return this.staticMergedFeatures.get(featureShortName);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public boolean isFeatureFinal() {
        return this.isFeatureFinal;
    }

    @Override
    public boolean isInheritanceFinal() {
        return this.isInheritanceFinal;
    }

    void setFeatureFinal() {
        this.isFeatureFinal = true;
    }

    void setInheritanceFinal() {
        this.isInheritanceFinal = true;
    }

    void setBuiltIn() {
        this.isBuiltIn = true;
    }

    public boolean isLongOrDouble() {
        return this.isLongOrDouble;
    }

    @Deprecated
    public Feature getFeature(String featureName) {
        return this.getFeatureByBaseName(featureName);
    }

    @Override
    public List<Feature> getFeatures() {
        return new ArrayList<Feature>(Arrays.asList(this.getFeatureImpls()));
    }

    public FeatureImpl[] getFeatureImpls() {
        if (!this.tsi.isCommitted()) {
            int nbrOfFeats = this.staticMergedFeatures.size();
            if (this.staticMergedFeaturesList == null || nbrOfFeats != this.staticMergedFeaturesList.length) {
                this.computeStaticMergedFeaturesList();
            }
        }
        return this.staticMergedFeaturesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeStaticMergedFeaturesList() {
        List<FeatureImpl> list = this.staticMergedFeaturesIntroducedByThisType;
        synchronized (list) {
            if (null == this.superType) {
                this.staticMergedFeaturesList = Constants.EMPTY_FEATURE_ARRAY;
                return;
            }
            int length1 = this.superType.getFeatureImpls().length;
            int length2 = this.staticMergedFeaturesIntroducedByThisType.size();
            this.staticMergedFeaturesList = new FeatureImpl[length1 + length2];
            System.arraycopy(this.superType.getFeatureImpls(), 0, this.staticMergedFeaturesList, 0, length1);
            int i = length1;
            for (FeatureImpl fi : this.staticMergedFeaturesIntroducedByThisType) {
                this.staticMergedFeaturesList[i++] = fi;
            }
        }
    }

    private void computeHasXxx() {
        this.nbrOfLongOrDoubleFeatures = this.superType.getNbrOfLongOrDoubleFeatures();
        if (this.superType.hasRefFeature) {
            this.hasRefFeature = true;
        }
        for (FeatureImpl fi : this.staticMergedFeaturesIntroducedByThisType) {
            if (!this.hasRefFeature && fi.getRangeImpl().isRefType) {
                this.hasRefFeature = true;
            }
            if (!fi.getRangeImpl().isLongOrDouble) continue;
            ++this.nbrOfLongOrDoubleFeatures;
        }
    }

    public Stream<FeatureImpl> getFeaturesAsStream() {
        return Arrays.stream(this.getFeatureImpls());
    }

    public List<FeatureImpl> getMergedStaticFeaturesIntroducedByThisType() {
        return this.staticMergedFeaturesIntroducedByThisType;
    }

    void addFeature(FeatureImpl fi) {
        this.checkAndAdjustFeatureInSubtypes(this, fi);
        this.staticMergedFeatures.put(fi.getShortName(), fi);
        this.staticMergedFeaturesIntroducedByThisType.add(fi);
    }

    private void checkAndAdjustFeatureInSubtypes(TypeImpl ti, FeatureImpl fi) {
        String featShortName = fi.getShortName();
        for (TypeImpl subti : ti.directSubtypes) {
            this.removeEqualFeatureNameMatch(subti.staticMergedFeaturesIntroducedByThisType, featShortName);
            FeatureImpl existing = subti.staticMergedFeatures.get(featShortName);
            this.checkExistingFeatureCompatible(existing, fi.getRange());
            if (existing == null) {
                subti.staticMergedFeatures.put(featShortName, fi);
            }
            this.checkAndAdjustFeatureInSubtypes(subti, fi);
        }
    }

    private void removeEqualFeatureNameMatch(List<FeatureImpl> fiList, String aName) {
        Iterator<FeatureImpl> it = fiList.iterator();
        while (it.hasNext()) {
            FeatureImpl fi = it.next();
            if (!fi.getShortName().equals(aName)) continue;
            it.remove();
            break;
        }
    }

    void checkExistingFeatureCompatible(FeatureImpl existingFi, Type range) {
        if (existingFi != null && existingFi.getRange() != range) {
            throw new CASAdminException("DUPLICATE_FEATURE", existingFi.getShortName(), this.getName(), range.getName(), existingFi.getDomain().getName(), existingFi.getRange().getName());
        }
    }

    TypeImpl consolidateType(TypeImpl topType, TypeImpl fsArrayType) {
        if (!this.isPrimitive()) {
            return topType;
        }
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    boolean isHeapStoredArray() {
        return false;
    }

    boolean isAuxStoredArray() {
        return false;
    }

    @Override
    public boolean isStringSubtype() {
        return false;
    }

    @Override
    public boolean isStringOrStringSubtype() {
        return false;
    }

    @Override
    public TypeImpl getComponentType() {
        return null;
    }

    public SlotKinds.SlotKind getComponentSlotKind() {
        return null;
    }

    Stream<TypeImpl> getAllSubtypes() {
        return this.directSubtypes.stream().flatMap(ti -> Stream.concat(Stream.of(ti), ti.getAllSubtypes()));
    }

    List<TypeImpl> getDirectSubtypes() {
        return this.directSubtypes;
    }

    boolean hasSupertype(TypeImpl supertype) {
        for (TypeImpl st : this.allSuperTypes) {
            if (st != supertype) continue;
            return true;
        }
        return false;
    }

    TypeImpl[] getAllSuperTypes() {
        return this.allSuperTypes;
    }

    public boolean subsumes(TypeImpl ti) {
        if (this.depthFirstCode <= ti.depthFirstCode && ti.depthFirstCode < this.depthFirstNextSibling) {
            return true;
        }
        if (this.depthFirstNextSibling != 0) {
            return false;
        }
        return this.getTypeSystem().subsumes(this, ti);
    }

    public boolean subsumesStrictly(TypeImpl ti) {
        if (this.depthFirstCode < ti.depthFirstCode && ti.depthFirstCode < this.depthFirstNextSibling) {
            return true;
        }
        if (this.depthFirstNextSibling != 0) {
            return false;
        }
        if (this.equals(ti)) {
            return false;
        }
        return this.getTypeSystem().subsumes(this, ti);
    }

    public boolean subsumesValue(Object v) {
        return v == null && (this.isRefType || this.isStringOrStringSubtype()) || v instanceof String && this.isStringOrStringSubtype() || v instanceof FeatureStructureImplC && this.subsumes(((FeatureStructureImplC)v)._getTypeImpl());
    }

    int computeDepthFirstCode(int level) {
        if (level != 1) {
            this.getFeatureImpls();
            this.computeHasXxx();
        }
        this.depthFirstCode = (short)level++;
        for (TypeImpl subti : this.directSubtypes) {
            level = subti.computeDepthFirstCode(level);
        }
        this.depthFirstNextSibling = (short)level;
        return level;
    }

    Class<?> getJavaClass() {
        return this.javaClass;
    }

    void setJavaClass(Class<?> javaClass) {
        this.javaClass = javaClass;
    }

    public int getFsSpaceReq() {
        return this.getFeatureImpls().length + 1;
    }

    public int getFsSpaceReq(int length) {
        return this.isHeapStoredArray() ? 2 + length : (this.isArray() ? 3 : this.getFsSpaceReq());
    }

    public int getFsSpaceReq(TOP fs) {
        return this.getFsSpaceReq(this.isHeapStoredArray() ? ((CommonArrayFS)((Object)fs)).size() : 0);
    }

    void initAdjOffset2FeatureMaps(List<FeatureImpl> tmpIntFis, List<FeatureImpl> tmpRefFis, List<FeatureImpl> tmpNsr) {
        tmpIntFis.addAll(Arrays.asList(this.superType.staticMergedIntFeaturesList));
        tmpRefFis.addAll(Arrays.asList(this.superType.staticMergedRefFeaturesList));
        tmpNsr.addAll(Arrays.asList(this.superType.staticMergedNonSofaFsRefs));
    }

    FeatureImpl getFeatureByAdjOffset(int adjOffset, boolean isInInt) {
        if (isInInt) {
            return this.staticMergedIntFeaturesList[adjOffset];
        }
        return this.staticMergedRefFeaturesList[adjOffset];
    }

    int getAdjOffset(String featureShortName) {
        return this.getFeatureByBaseName(featureShortName).getAdjustedOffset();
    }

    public int hashCode() {
        return (int)this.hashCodeLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long hashCodeLong() {
        if (!this.hasHashCodeLong) {
            TypeImpl typeImpl = this;
            synchronized (typeImpl) {
                this.hashCodeLong = this.computeHashCodeLong();
                if (this.getTypeSystem().isCommitted()) {
                    this.hasHashCodeLong = true;
                }
            }
        }
        return this.hashCodeLong;
    }

    public long hashCodeNameLong() {
        return this.hashCodeNameLong;
    }

    private long computeHashCodeLong() {
        long prime = 31L;
        long result = 31L + this.hashCodeNameLong;
        result = 31L * result + (this.superType == null ? 0L : this.superType.hashCodeLong());
        result = 31L * result + (long)(this.isFeatureFinal ? 1231 : 1237);
        result = 31L * result + (long)(this.isInheritanceFinal ? 1231 : 1237);
        for (FeatureImpl fi : this.getFeatureImpls()) {
            result = 31L * result + fi.hashCodeLong();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TypeImpl)) {
            return false;
        }
        TypeImpl other = (TypeImpl)obj;
        return this.hashCodeLong() == other.hashCodeLong();
    }

    @Override
    public int compareTo(TypeImpl t) {
        FeatureImpl[] fis2;
        long thcl;
        if (this == t) {
            return 0;
        }
        long hcl = this.hashCodeLong();
        if (hcl == (thcl = t.hashCodeLong())) {
            return 0;
        }
        int c = Long.compare(this.hashCodeNameLong, t.hashCodeNameLong);
        if (c != 0) {
            return c;
        }
        if (this.superType == null || t.superType == null) {
            throw Misc.internalError();
        }
        c = Long.compare(this.superType.hashCodeNameLong, t.superType.hashCodeNameLong);
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.getNumberOfFeatures(), t.getNumberOfFeatures());
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.isFeatureFinal, t.isFeatureFinal);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.isInheritanceFinal, t.isInheritanceFinal);
        if (c != 0) {
            return c;
        }
        FeatureImpl[] fis1 = this.getFeatureImpls();
        c = Integer.compare(fis1.length, (fis2 = t.getFeatureImpls()).length);
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < fis1.length; ++i) {
            c = fis1[i].compareTo(fis2[i]);
            if (c == 0) continue;
            return c;
        }
        throw Misc.internalError();
    }

    boolean isPrimitiveArrayType() {
        if (!this.isArray()) {
            return false;
        }
        switch (this.typeCode) {
            case 7: 
            case 8: 
            case 9: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public boolean hasRefFeature() {
        return this.hasRefFeature;
    }

    public int getNbrOfLongOrDoubleFeatures() {
        return this.nbrOfLongOrDoubleFeatures;
    }

    public boolean isTypedFsArray() {
        return false;
    }

    void setStaticMergedIntFeaturesList(FeatureImpl[] v) {
        this.staticMergedIntFeaturesList = v;
    }

    void setStaticMergedRefFeaturesList(FeatureImpl[] v) {
        this.staticMergedRefFeaturesList = v;
    }

    void setStaticMergedNonSofaFsRefs(FeatureImpl[] v) {
        this.staticMergedNonSofaFsRefs = v;
    }

    FeatureImpl[] getStaticMergedNonSofaFsRefs() {
        return this.staticMergedNonSofaFsRefs;
    }

    public boolean isTopType() {
        return this.superType == null;
    }

    @Override
    public Iterator<Feature> iterator() {
        final FeatureImpl[] fia = this.getFeatureImpls();
        final int l = fia.length;
        return new Iterator<Feature>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < l;
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return fia[this.i++];
                }
                throw new NoSuchElementException();
            }
        };
    }
}

