/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CopyOnWriteIndexPart;
import org.apache.uima.cas.impl.FsIndex_singletype;
import org.apache.uima.cas.impl.FsIterator_set_sorted2;
import org.apache.uima.cas.impl.FsIterator_set_sorted_pear;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.internal.util.CopyOnWriteOrderedFsSet_array;
import org.apache.uima.internal.util.OrderedFsSet_array;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public final class FsIndex_set_sorted<T extends FeatureStructure>
extends FsIndex_singletype<T> {
    private final OrderedFsSet_array<T> indexedFSs = new OrderedFsSet_array(this.comparatorNoTypeWithID, this.comparatorNoTypeWithoutID);
    private int maxAnnotSpan = -1;

    FsIndex_set_sorted(CASImpl cas, Type type, int indexType, FSIndexComparator comparatorForIndexSpecs) {
        super(cas, type, indexType, comparatorForIndexSpecs);
    }

    @Override
    public void flush() {
        super.flush();
        this.indexedFSs.clear();
    }

    @Override
    public boolean contains(FeatureStructure templateKey) {
        T r = this.find(templateKey);
        return r != null;
    }

    @Override
    void insert(T fs) {
        int span;
        this.maybeCopy();
        if (this.isAnnotIdx && (span = ((Annotation)fs).getEnd() - ((Annotation)fs).getBegin()) > this.maxAnnotSpan) {
            this.maxAnnotSpan = span;
        }
        this.indexedFSs.add(fs, this.isSorted() ? this.comparatorNoTypeWithID : this.comparatorNoTypeWithoutID);
    }

    @Override
    public T find(FeatureStructure templateKey) {
        int pos = this.indexedFSs.findWithoutID((TOP)templateKey);
        return pos >= 0 ? (T)this.indexedFSs.getAtPos(pos) : null;
    }

    @Override
    public int size() {
        return this.indexedFSs.size();
    }

    @Override
    public boolean deleteFS(T fs) {
        if (((TOP)fs)._getTypeImpl() != this.type) {
            throw new IllegalArgumentException(String.format("Wrong type %s passed to deleteFS of index over type %s", ((TOP)fs)._getTypeImpl().getName(), this.type.getName()));
        }
        this.maybeCopy();
        return this.indexedFSs.remove(fs);
    }

    @Override
    protected void bulkAddTo(List<T> v) {
        AbstractCollection coll = new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return null;
            }

            @Override
            public int size() {
                return FsIndex_set_sorted.this.size();
            }

            @Override
            public T[] toArray() {
                return FsIndex_set_sorted.this.indexedFSs.toArray();
            }
        };
        v.addAll(coll);
    }

    @Override
    public LowLevelIterator<T> iterator() {
        return this.iterator(false, false);
    }

    @Override
    public LowLevelIterator<T> iterator(boolean orderNotNeeded, boolean ignoreType) {
        CopyOnWriteIndexPart cow_wrapper = this.getNonNullCow();
        Comparator comparatorMaybeNoTypeWithoutID = ignoreType ? this.comparatorNoTypeWithoutID : this.comparatorWithoutID;
        return this.casImpl.inPearContext() ? new FsIterator_set_sorted_pear(this, cow_wrapper, comparatorMaybeNoTypeWithoutID) : new FsIterator_set_sorted2(this, cow_wrapper, comparatorMaybeNoTypeWithoutID);
    }

    @Override
    protected CopyOnWriteIndexPart createCopyOnWriteIndexPart() {
        return new CopyOnWriteOrderedFsSet_array<T>(this.indexedFSs);
    }

    @Override
    public int ll_maxAnnotSpan() {
        return this.maxAnnotSpan;
    }

    @Override
    public int compare(FeatureStructure o1, FeatureStructure o2) {
        return this.comparatorWithoutID.compare((TOP)o1, (TOP)o2);
    }
}

