/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.BinaryCasSerDes4;
import org.apache.uima.cas.impl.BinaryCasSerDes6;
import org.apache.uima.cas.impl.ByteHeap;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.CASSerializer;
import org.apache.uima.cas.impl.CommonSerDes;
import org.apache.uima.cas.impl.CommonSerDesSequential;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FSsTobeAddedback;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.Heap;
import org.apache.uima.cas.impl.LongHeap;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.ShortHeap;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.StringHeap;
import org.apache.uima.cas.impl.StringHeapDeserializationHelper;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Int2ObjHashMap;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.Obj2IntIdentityHashMap;
import org.apache.uima.internal.util.function.Consumer_T_int_withIOException;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasLoadMode;

public class BinaryCasSerDes {
    private static final boolean TRACE_DESER = false;
    private static final boolean SOFA_IN_NORMAL_ORDER = false;
    private static final boolean SOFA_AHEAD_OF_NORMAL_ORDER = true;
    private static final int arrayLengthFeatOffset = 1;
    private static final int arrayContentOffset = 2;
    private final CASImpl baseCas;
    private TypeSystemImpl tsi;
    Heap heap;
    ByteHeap byteHeap;
    ShortHeap shortHeap;
    LongHeap longHeap;
    StringHeap stringHeap;
    int nextHeapAddrAfterMark;
    int nextStringHeapAddrAfterMark;
    int nextByteHeapAddrAfterMark;
    int nextShortHeapAddrAfterMark;
    int nextLongHeapAddrAfterMark;
    private final Int2ObjHashMap<TOP, TOP> byteAuxAddr2fsa = new Int2ObjHashMap(TOP.class);
    private final Int2ObjHashMap<TOP, TOP> shortAuxAddr2fsa = new Int2ObjHashMap(TOP.class);
    private final Int2ObjHashMap<TOP, TOP> longAuxAddr2fsa = new Int2ObjHashMap(TOP.class);
    boolean isBeforeV3 = false;

    public BinaryCasSerDes(CASImpl baseCAS) {
        this.baseCas = baseCAS;
    }

    public void reinit(CASSerializer ser) {
        this.baseCas.resetNoQuestions();
        this.reinit(ser.getHeapMetadata(), ser.getHeapArray(), ser.getStringTable(), ser.getFSIndex(), ser.getByteArray(), ser.getShortArray(), ser.getLongArray());
    }

    void reinit(int[] heapMetadata, int[] heapArray, String[] stringTable, int[] fsIndex, byte[] byteHeapArray, short[] shortHeapArray, long[] longHeapArray) {
        CommonSerDesSequential csds = new CommonSerDesSequential(this.baseCas);
        csds.setup(null, 1);
        this.heap = new Heap();
        this.byteHeap = new ByteHeap();
        this.shortHeap = new ShortHeap();
        this.longHeap = new LongHeap();
        this.stringHeap = new StringHeap();
        this.createStringTableFromArray(stringTable);
        this.heap.reinit(heapMetadata, heapArray);
        if (byteHeapArray != null) {
            this.byteHeap.reinit(byteHeapArray);
        }
        if (shortHeapArray != null) {
            this.shortHeap.reinit(shortHeapArray);
        }
        if (longHeapArray != null) {
            this.longHeap.reinit(longHeapArray);
        }
        this.createFSsFromHeaps(false, 1, csds);
        this.reinitIndexedFSs(fsIndex, false, i -> csds.addr2fs.get(i));
    }

    public CASImpl setupCasFromCasMgrSerializer(CASMgrSerializer casMgrSerializer) {
        if (null != casMgrSerializer) {
            TypeSystemImpl ts = casMgrSerializer.getTypeSystem();
            this.baseCas.installTypeSystemInAllViews(ts);
            this.baseCas.commitTypeSystem();
            this.baseCas.indexRepository = casMgrSerializer.getIndexRepository(this.baseCas);
            this.baseCas.indexRepository.commit();
            CASImpl initialView = this.baseCas.getInitialView();
            this.baseCas.svd.sofa2indexMap.clear();
            this.baseCas.svd.sofaNbr2ViewMap.clear();
            this.baseCas.svd.viewCount = 0;
            initialView.refreshView(this.baseCas, null);
            this.baseCas.svd.setViewForSofaNbr(1, initialView);
            this.baseCas.svd.viewCount = 1;
        }
        return this.baseCas;
    }

    public void reinit(CASCompleteSerializer casCompSer) {
        TypeSystemImpl ts = casCompSer.getCASMgrSerializer().getTypeSystem();
        this.baseCas.svd.clear();
        this.baseCas.installTypeSystemInAllViews(ts);
        this.baseCas.commitTypeSystem();
        casCompSer.getCASMgrSerializer().getIndexRepository(this.baseCas);
        this.baseCas.indexRepository.commit();
        CASImpl initialView = this.baseCas.getInitialView();
        initialView.refreshView(this.baseCas, null);
        this.baseCas.svd.setViewForSofaNbr(1, initialView);
        this.baseCas.svd.viewCount = 1;
        CASSerializer casSer = casCompSer.getCASSerializer();
        this.reinit(casSer.getHeapMetadata(), casSer.getHeapArray(), casSer.getStringTable(), casSer.getFSIndex(), casSer.getByteArray(), casSer.getShortArray(), casSer.getLongArray());
    }

    public SerialFormat reinit(InputStream istream) throws CASRuntimeException {
        DataInputStream dis = CommonSerDes.maybeWrapToDataInputStream(istream);
        try {
            CommonSerDes.Header h = CommonSerDes.readHeader(dis);
            return this.reinit(h, istream, null, CasLoadMode.DEFAULT, null, AllowPreexistingFS.allow, null);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            throw new CASRuntimeException("BLOB_DESERIALIZATION", msg);
        }
    }

    public SerialFormat reinit(CommonSerDes.Header h, InputStream istream, CASMgrSerializer casMgrSerializer, CasLoadMode casLoadMode, BinaryCasSerDes6 f6, AllowPreexistingFS allowPreexistingFS, TypeSystemImpl ts) throws CASRuntimeException {
        DataInputStream dis = CommonSerDes.maybeWrapToDataInputStream(istream);
        if (!h.isV3 && h.getSeqVersionNbr() < 2) {
            this.isBeforeV3 = true;
        }
        CASMgrSerializer embeddedCasMgrSerializer = BinaryCasSerDes.maybeReadEmbeddedTSI(h, dis);
        if (!h.isForm6() || casLoadMode == CasLoadMode.REINIT) {
            this.setupCasFromCasMgrSerializer(null != embeddedCasMgrSerializer && embeddedCasMgrSerializer.hasIndexRepository() ? embeddedCasMgrSerializer : casMgrSerializer);
        }
        if (!h.isForm6() && casLoadMode == CasLoadMode.LENIENT) {
            throw new CASRuntimeException("LENIENT_NOT_SUPPORTED", h.toString());
        }
        try {
            boolean delta = h.isDelta;
            if (h.getSeqVersionNbr() < 2 && delta) {
                throw new CASRuntimeException("DESERIALIZING_V2_DELTA_V3", new Object[0]);
            }
            if (!delta) {
                this.baseCas.resetNoQuestions();
            }
            if (h.isCompressed) {
                TypeSystemImpl tsRead;
                if (h.form4) {
                    BinaryCasSerDes4 bcsd4 = new BinaryCasSerDes4(this.baseCas.getTypeSystemImpl(), false);
                    bcsd4.deserialize(this.baseCas, dis, delta, h);
                    return h.typeSystemIndexDefIncluded ? SerialFormat.COMPRESSED_TSI : SerialFormat.COMPRESSED;
                }
                CASMgrSerializer cms = embeddedCasMgrSerializer != null ? embeddedCasMgrSerializer : casMgrSerializer;
                TypeSystemImpl typeSystemImpl = tsRead = cms != null ? cms.getTypeSystem() : null;
                if (null != tsRead) {
                    tsRead = tsRead.commit(this.baseCas.getJCasClassLoader());
                }
                TypeSystemImpl ts_for_decoding = tsRead != null && embeddedCasMgrSerializer != null ? tsRead : (ts != null ? ts : (f6 != null && f6.getTgtTs() != null ? f6.getTgtTs() : tsRead));
                try {
                    BinaryCasSerDes6 bcsd = f6 != null ? new BinaryCasSerDes6(f6, ts_for_decoding) : new BinaryCasSerDes6((AbstractCas)this.baseCas, ts_for_decoding);
                    bcsd.deserializeAfterVersion(dis, delta, AllowPreexistingFS.allow);
                    return h.typeSystemIndexDefIncluded ? SerialFormat.COMPRESSED_FILTERED_TSI : (h.typeSystemIncluded ? SerialFormat.COMPRESSED_FILTERED_TS : SerialFormat.COMPRESSED_FILTERED);
                }
                catch (ResourceInitializationException e) {
                    throw new CASRuntimeException("DESERIALIZING_COMPRESSED_BINARY_UNSUPPORTED", null, e);
                }
            }
            return this.binaryDeserialization(h);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            throw new CASRuntimeException("BLOB_DESERIALIZATION", msg);
        }
    }

    static CASMgrSerializer maybeReadEmbeddedTSI(CommonSerDes.Header h, DataInputStream dis) {
        if (h.isTypeSystemIncluded() || h.isTypeSystemIndexDefIncluded()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(dis);
                return (CASMgrSerializer)ois.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CASRuntimeException("UNRECOGNIZED_SERIALIZED_CAS_FORMAT", null, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerialFormat binaryDeserialization(CommonSerDes.Header h) {
        boolean delta = h.isDelta;
        CommonSerDes.Reading r = h.reading;
        DataInputStream dis = r.dis;
        CommonSerDesSequential csds = BinaryCasSerDes4.getCsds(this.baseCas, delta);
        if (delta) {
            if (this.nextHeapAddrAfterMark == 0 || this.heap == null || this.heap.getCellsUsed() <= 1) {
                Misc.internalError();
            }
        } else {
            if (this.heap == null) {
                this.heap = new Heap();
            } else {
                this.heap.reset();
            }
            if (this.byteHeap == null) {
                this.byteHeap = new ByteHeap();
            } else {
                this.byteHeap.reset();
            }
            if (this.shortHeap == null) {
                this.shortHeap = new ShortHeap();
            } else {
                this.shortHeap.reset();
            }
            if (this.longHeap == null) {
                this.longHeap = new LongHeap();
            } else {
                this.longHeap.reset();
            }
            if (this.stringHeap == null) {
                this.stringHeap = new StringHeap();
            } else {
                this.stringHeap.reset();
            }
            this.clearDeltaOffsets();
        }
        try {
            int i2;
            int[] modWords;
            int fsmodssz2;
            int fsheapsz = r.readInt();
            int startPos = 0;
            if (!delta) {
                this.heap.reinitSizeOnly(fsheapsz);
            } else {
                startPos = this.heap.getNextId();
                this.heap.grow(fsheapsz);
            }
            for (int i3 = startPos; i3 < fsheapsz + startPos; ++i3) {
                this.heap.heap[i3] = r.readInt();
            }
            int stringheapsz = r.readInt();
            StringHeapDeserializationHelper shdh = new StringHeapDeserializationHelper();
            shdh.charHeap = new char[stringheapsz];
            for (int i4 = 0; i4 < stringheapsz; ++i4) {
                shdh.charHeap[i4] = (char)r.readShort();
            }
            shdh.charHeapPos = stringheapsz;
            if (stringheapsz % 2 != 0) {
                dis.readChar();
            }
            int refheapsz = r.readInt();
            --refheapsz;
            refheapsz /= 2;
            shdh.refHeap = new int[3 + (refheapsz *= 3)];
            dis.readInt();
            for (int i5 = shdh.refHeapPos; i5 < shdh.refHeap.length; i5 += 3) {
                shdh.refHeap[i5 + 0] = r.readInt();
                shdh.refHeap[i5 + 1] = r.readInt();
                shdh.refHeap[i5 + 2] = 0;
            }
            shdh.refHeapPos = refheapsz + 3;
            this.stringHeap.reinit(shdh, delta);
            if (delta) {
                fsmodssz2 = 2 * r.readInt();
                modWords = new int[fsmodssz2];
                for (int i6 = 0; i6 < fsmodssz2; ++i6) {
                    modWords[i6] = r.readInt();
                }
            } else {
                fsmodssz2 = 0;
                modWords = null;
            }
            int fsindexsz = r.readInt();
            int[] fsindexes = new int[fsindexsz];
            for (int i7 = 0; i7 < fsindexsz; ++i7) {
                fsindexes[i7] = r.readInt();
            }
            int heapsz = r.readInt();
            if (!delta) {
                this.byteHeap.heap = new byte[Math.max(16, heapsz)];
                dis.readFully(this.byteHeap.heap, 0, heapsz);
                this.byteHeap.heapPos = heapsz;
            } else {
                int offset2startOfNewBytes = this.byteHeap.reserve(heapsz);
                dis.readFully(this.byteHeap.heap, offset2startOfNewBytes, heapsz);
            }
            int align = (4 - heapsz % 4) % 4;
            BinaryCasSerDes6.skipBytes(dis, align);
            heapsz = r.readInt();
            if (!delta) {
                this.shortHeap.heap = new short[Math.max(16, heapsz)];
                for (i2 = 0; i2 < heapsz; ++i2) {
                    this.shortHeap.heap[i2] = r.readShort();
                }
                this.shortHeap.heapPos = heapsz;
            } else {
                int pos = this.shortHeap.reserve(heapsz);
                int end = pos + heapsz;
                for (int i8 = pos; i8 < end; ++i8) {
                    this.shortHeap.addShort(r.readShort());
                }
            }
            if (heapsz % 2 != 0) {
                dis.readShort();
            }
            heapsz = r.readInt();
            if (!delta) {
                this.longHeap.heap = new long[Math.max(16, heapsz)];
                for (i2 = 0; i2 < heapsz; ++i2) {
                    this.longHeap.heap[i2] = r.readLong();
                }
                this.longHeap.heapPos = heapsz;
            } else {
                this.longHeap.reserve(heapsz);
                for (i2 = 0; i2 < heapsz; ++i2) {
                    this.longHeap.addLong(r.readLong());
                }
            }
            if (delta) {
                heapsz = this.updateAuxArrayMods(r, this.byteAuxAddr2fsa, (ba, arrayIndex) -> {
                    if (ba instanceof ByteArray) {
                        ((ByteArray)ba).set(arrayIndex, dis.readByte());
                    } else {
                        ((BooleanArray)ba).set(arrayIndex, dis.readByte() == 1);
                    }
                });
                align = (4 - heapsz % 4) % 4;
                BinaryCasSerDes6.skipBytes(dis, align);
                heapsz = this.updateAuxArrayMods(r, this.shortAuxAddr2fsa, (sa, arrayIndex) -> ((ShortArray)sa).set(arrayIndex, r.readShort()));
                if (heapsz % 2 != 0) {
                    dis.readShort();
                }
                this.updateAuxArrayMods(r, this.longAuxAddr2fsa, (la, arrayIndex) -> {
                    if (la instanceof LongArray) {
                        ((LongArray)la).set(arrayIndex, r.readLong());
                    } else {
                        ((DoubleArray)la).set(arrayIndex, CASImpl.long2double(r.readLong()));
                    }
                });
            }
            this.createFSsFromHeaps(delta, startPos == 0 ? 1 : startPos, csds);
            if (delta) {
                BinDeserSupport bds = new BinDeserSupport();
                BinDeserSupport.access$202(bds, new int[csds.addr2fs.size() + 1]);
                IntListIterator it = csds.addr2fs.keyIterator();
                int iaa = 0;
                while (it.hasNext()) {
                    ((BinDeserSupport)bds).fssAddrArray[iaa++] = it.nextNvc();
                }
                ((BinDeserSupport)bds).fssAddrArray[iaa] = this.heap.getCellsUsed();
                Arrays.sort(bds.fssAddrArray);
                assert (bds.fssAddrArray[iaa] == this.heap.getCellsUsed());
                bds.fsStartAddr = -1;
                this.baseCas.svd.disableAutoCorruptionCheck = true;
                try {
                    for (int i9 = 0; i9 < modWords.length; i9 += 2) {
                        int heapAddrBeingModified = modWords[i9];
                        bds.maybeAddBackAndRemoveFs(heapAddrBeingModified, csds.addr2fs);
                        this.updateHeapSlot(bds, heapAddrBeingModified, modWords[i9 + 1], csds.addr2fs);
                    }
                    bds.addBackIfRemoved();
                    BinDeserSupport.access$202(bds, null);
                }
                finally {
                    this.baseCas.svd.disableAutoCorruptionCheck = false;
                }
            }
            IntFunction<TOP> getFsFromAddr = i -> csds.addr2fs.get(i);
            this.reinitIndexedFSs(fsindexes, delta, getFsFromAddr);
            if (!delta) {
                this.setHeapExtents();
                csds.setHeapEnd(this.nextHeapAddrAfterMark);
            }
            this.heap = null;
            this.stringHeap = null;
            this.byteHeap = null;
            this.shortHeap = null;
            this.longHeap = null;
            this.clearAuxAddr2fsa();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            throw new CASRuntimeException("BLOB_DESERIALIZATION", msg);
        }
        return h.typeSystemIndexDefIncluded ? SerialFormat.BINARY_TSI : SerialFormat.BINARY;
    }

    void setHeapExtents() {
        this.nextHeapAddrAfterMark = this.heap.getCellsUsed();
        this.nextStringHeapAddrAfterMark = this.stringHeap.getSize() - 1;
        this.nextByteHeapAddrAfterMark = this.byteHeap.getSize() - 1;
        this.nextShortHeapAddrAfterMark = this.shortHeap.getSize() - 1;
        this.nextLongHeapAddrAfterMark = this.longHeap.getSize() - 1;
    }

    int updateAuxArrayMods(CommonSerDes.Reading r, Int2ObjHashMap<TOP, TOP> auxAddr2fsa, Consumer_T_int_withIOException<TOP> setter) throws IOException {
        int heapsz = r.readInt();
        if (heapsz > 0) {
            int i;
            int[] tempHeapAddrs = new int[heapsz];
            int[] sortedArrayAddrs = auxAddr2fsa.getSortedKeys();
            int sortedArrayAddrsIndex = 0;
            for (i = 0; i < heapsz; ++i) {
                tempHeapAddrs[i] = r.readInt();
            }
            for (i = 0; i < heapsz; ++i) {
                sortedArrayAddrsIndex = this.getSortedArrayAddrsIndex(sortedArrayAddrs, tempHeapAddrs[i], sortedArrayAddrsIndex);
                int arrayStart = sortedArrayAddrs[sortedArrayAddrsIndex];
                TOP fs = auxAddr2fsa.get(arrayStart);
                int arrayIndex = tempHeapAddrs[i] - arrayStart;
                setter.accept(fs, arrayIndex);
            }
        }
        return heapsz;
    }

    void reinitIndexedFSs(int[] fsIndex, boolean isDeltaMods, IntFunction<TOP> getFsFromAddr) {
        int idx = this.reinitIndexedFSsSofas(fsIndex, isDeltaMods, getFsFromAddr);
        this.reinitIndexedFSs(fsIndex, isDeltaMods, getFsFromAddr, fsIndex[0], idx);
    }

    void reinitIndexedFSs(int[] fsIndex, boolean isDeltaMods, IntFunction<TOP> getFsFromAddr, IntFunction<TOP> getSofaFromAddr) {
        int idx = this.reinitIndexedFSsSofas(fsIndex, isDeltaMods, getSofaFromAddr);
        this.reinitIndexedFSs(fsIndex, isDeltaMods, getFsFromAddr, fsIndex[0], idx);
    }

    int reinitIndexedFSsSofas(int[] fsIndex, boolean isDeltaMods, IntFunction<TOP> getFsFromAddr) {
        int idx;
        int numSofas = fsIndex[1];
        int end1 = 2 + numSofas;
        for (idx = 2; idx < end1; ++idx) {
            this.baseCas.indexRepository.addFS((FeatureStructure)getFsFromAddr.apply(fsIndex[idx]));
        }
        return idx;
    }

    void reinitIndexedFSs(int[] fsIndex, boolean isDeltaMods, IntFunction<TOP> getFsFromAddr, int numViews, int idx) {
        this.baseCas.forAllSofas(sofa -> {
            String id = sofa.getSofaID();
            if ("_InitialView".equals(id)) {
                this.baseCas.registerInitialSofa();
                this.baseCas.addSofaViewName(id);
            }
            this.baseCas.getView((SofaFS)sofa).registerView((Sofa)sofa);
        });
        this.baseCas.getInitialView();
        this.baseCas.setViewCount(numViews);
        for (int viewNbr = 1; viewNbr <= numViews; ++viewNbr) {
            CASImpl view = viewNbr == 1 ? this.baseCas.getInitialView() : (CASImpl)this.baseCas.getView(viewNbr);
            FSIndexRepositoryImpl ir = view == null ? null : view.indexRepository;
            int length = fsIndex[idx++];
            this.reinitDeltaIndexedFSsInner(ir, fsIndex, idx, length, true, getFsFromAddr);
            idx += length;
            if (isDeltaMods) {
                length = fsIndex[idx++];
                this.reinitDeltaIndexedFSsInner(ir, fsIndex, idx, length, false, getFsFromAddr);
                idx += length;
                length = fsIndex[idx++];
                idx += length;
            }
            if (view == null) continue;
            view.updateDocumentAnnotation();
        }
    }

    void reinitDeltaIndexedFSsInner(FSIndexRepositoryImpl ir, int[] fsindexes, int idx, int length, boolean isAdd, IntFunction<TOP> getFsFromAddr) {
        if (ir == null) {
            return;
        }
        int end1 = idx + length;
        while (idx < end1) {
            TOP fs = getFsFromAddr.apply(fsindexes[idx]);
            if (isAdd) {
                ir.addFS(fs);
            } else {
                ir.removeFS(fs);
            }
            ++idx;
        }
    }

    private int getSortedArrayAddrsIndex(int[] sortedArrayAddrs, int auxAddr, int sortedArrayAddrsIndex) {
        int nextStart;
        int curStart = sortedArrayAddrs[sortedArrayAddrsIndex];
        int n = nextStart = sortedArrayAddrsIndex + 1 == sortedArrayAddrs.length ? Integer.MAX_VALUE : sortedArrayAddrs[sortedArrayAddrsIndex + 1];
        if (auxAddr >= curStart && auxAddr < nextStart) {
            return sortedArrayAddrsIndex;
        }
        int v = Arrays.binarySearch(sortedArrayAddrs, auxAddr);
        return v >= 0 ? v : -v - 2;
    }

    int[] getIndexedFSs(Obj2IntIdentityHashMap<TOP> fs2addr) {
        IntVector v = new IntVector();
        int numViews = this.baseCas.getViewCount();
        v.add(numViews);
        Collection<TOP> fss = this.baseCas.indexRepository.getIndexedFSs();
        this.addIdsToIntVector(fss, v, fs2addr);
        this.baseCas.forAllViews(view -> this.addIdsToIntVector(view.getIndexedFSs(), v, fs2addr));
        return v.toArray();
    }

    void addIdsToIntVector(Collection<TOP> fss, IntVector v, Obj2IntIdentityHashMap<TOP> fs2addr) {
        v.add(fss.size());
        if (null == fs2addr) {
            for (TOP fs : fss) {
                v.add(fs._id);
            }
        } else {
            for (TOP fs : fss) {
                v.add(fs2addr.get(fs));
            }
        }
    }

    void addIdsToIntVector(Set<TOP> fss, IntVector v, Obj2IntIdentityHashMap<TOP> fs2addr) {
        v.add(fss.size());
        for (TOP fs : fss) {
            v.add(fs2addr.get(fs));
        }
    }

    int[] getDeltaIndexedFSs(MarkerImpl mark, Obj2IntIdentityHashMap<TOP> fs2addr) {
        IntVector v = new IntVector();
        int numViews = this.baseCas.getViewCount();
        v.add(numViews);
        IntVector newSofas = new IntVector();
        this.baseCas.indexRepository.walkIndexedFSs(fs -> {
            if (mark.isNew((FeatureStructure)fs)) {
                newSofas.add(fs2addr.get((TOP)fs));
            }
        });
        v.add(newSofas.size());
        v.add(newSofas.getArray(), 0, newSofas.size());
        for (int viewNbr = 1; viewNbr <= numViews; ++viewNbr) {
            Set<TOP> fssReindexed;
            Set<TOP> fssDeleted;
            Set<TOP> fssAdded;
            FSIndexRepositoryImpl loopIndexRep = this.baseCas.getSofaIndexRepository(viewNbr);
            if (loopIndexRep != null) {
                fssAdded = loopIndexRep.getAddedFSs();
                fssDeleted = loopIndexRep.getDeletedFSs();
                fssReindexed = loopIndexRep.getReindexedFSs();
            } else {
                fssAdded = Collections.emptySet();
                fssDeleted = Collections.emptySet();
                fssReindexed = Collections.emptySet();
            }
            this.addIdsToIntVector(fssAdded, v, fs2addr);
            this.addIdsToIntVector(fssDeleted, v, fs2addr);
            this.addIdsToIntVector(fssReindexed, v, fs2addr);
        }
        return v.toArray();
    }

    void createStringTableFromArray(String[] stringTable) {
        this.stringHeap.reset();
        for (int i = 1; i < stringTable.length; ++i) {
            this.stringHeap.addString(stringTable[i]);
        }
    }

    public static int getFsSpaceReq(TOP fs, TypeImpl type) {
        return type.getFsSpaceReq(fs);
    }

    List<TOP> scanAllFSsForBinarySerialization(MarkerImpl mark, CommonSerDesSequential csds) {
        boolean isMarkSet = mark != null;
        List<TOP> all = null;
        int prevHeapEnd = csds.getHeapEnd();
        if (isMarkSet) {
            all = csds.setup(mark, csds.getHeapEnd());
        }
        this.heap = new Heap(isMarkSet ? 1 + csds.getHeapEnd() - prevHeapEnd : csds.getHeapEnd());
        this.byteHeap = new ByteHeap();
        this.shortHeap = new ShortHeap();
        this.longHeap = new LongHeap();
        this.stringHeap = new StringHeap();
        if (!isMarkSet) {
            this.clearDeltaOffsets();
            this.clearAuxAddr2fsa();
        }
        List<TOP> itemsToExtract = csds.getSortedFSs();
        for (TOP fs : itemsToExtract) {
            if (isMarkSet && !mark.isNew(fs)) continue;
            this.extractFsToV2Heaps(fs, isMarkSet, csds.fs2addr);
        }
        return all;
    }

    private void extractFsToV2Heaps(TOP fs, boolean isMarkSet, Obj2IntIdentityHashMap<TOP> fs2addr) {
        block28: {
            int pos;
            TypeImpl type;
            block27: {
                int length;
                type = fs._getTypeImpl();
                pos = this.heap.add(BinaryCasSerDes.getFsSpaceReq(fs, type), type.getCode());
                if (!type.isArray()) break block27;
                this.heap.heap[pos + 1] = length = ((CommonArrayFS)((Object)fs)).size();
                int i = pos + 2;
                switch (type.getComponentSlotKind()) {
                    case Slot_Int: {
                        System.arraycopy(((IntegerArray)fs)._getTheArray(), 0, this.heap.heap, pos + 2, length);
                        break;
                    }
                    case Slot_Float: {
                        for (float v : ((FloatArray)fs)._getTheArray()) {
                            this.heap.heap[i++] = CASImpl.float2int(v);
                        }
                        break block28;
                    }
                    case Slot_StrRef: {
                        for (String s : ((StringArray)fs)._getTheArray()) {
                            int strAddr = this.stringHeap.addString(s);
                            this.heap.heap[i++] = strAddr == 0 ? 0 : this.nextStringHeapAddrAfterMark + strAddr;
                        }
                        break block28;
                    }
                    case Slot_BooleanRef: {
                        int baAddr = this.byteHeap.addBooleanArray(((BooleanArray)fs)._getTheArray());
                        this.heap.heap[i] = this.nextByteHeapAddrAfterMark + baAddr;
                        this.byteAuxAddr2fsa.put(this.nextByteHeapAddrAfterMark + baAddr, fs);
                        break;
                    }
                    case Slot_ByteRef: {
                        int baAddr = this.byteHeap.addByteArray(((ByteArray)fs)._getTheArray());
                        this.heap.heap[i] = this.nextByteHeapAddrAfterMark + baAddr;
                        this.byteAuxAddr2fsa.put(this.nextByteHeapAddrAfterMark + baAddr, fs);
                        break;
                    }
                    case Slot_ShortRef: {
                        int saAddr = this.shortHeap.addShortArray(((ShortArray)fs)._getTheArray());
                        this.heap.heap[i] = this.nextShortHeapAddrAfterMark + saAddr;
                        this.shortAuxAddr2fsa.put(this.nextShortHeapAddrAfterMark + saAddr, fs);
                        break;
                    }
                    case Slot_LongRef: {
                        int laAddr = this.longHeap.addLongArray(((LongArray)fs)._getTheArray());
                        this.heap.heap[i] = this.nextLongHeapAddrAfterMark + laAddr;
                        this.longAuxAddr2fsa.put(this.nextLongHeapAddrAfterMark + laAddr, fs);
                        break;
                    }
                    case Slot_DoubleRef: {
                        int laAddr = this.longHeap.addDoubleArray(((DoubleArray)fs)._getTheArray());
                        this.heap.heap[i] = this.nextLongHeapAddrAfterMark + laAddr;
                        this.longAuxAddr2fsa.put(this.nextLongHeapAddrAfterMark + laAddr, fs);
                        break;
                    }
                    case Slot_HeapRef: {
                        for (TOP fsitem : ((FSArray)fs)._getTheArray()) {
                            this.heap.heap[i++] = fs2addr.get(fsitem);
                        }
                        break block28;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
                break block28;
            }
            if (fs instanceof UimaSerializable) {
                ((UimaSerializable)((Object)fs))._save_to_cas_data();
            }
            int i = pos + 1;
            block25: for (FeatureImpl feat : type.getFeatureImpls()) {
                switch (feat.getSlotKind()) {
                    case Slot_Boolean: {
                        this.heap.heap[i++] = fs._getBooleanValueNc(feat) ? 1 : 0;
                        continue block25;
                    }
                    case Slot_Byte: {
                        this.heap.heap[i++] = fs._getByteValueNc(feat);
                        continue block25;
                    }
                    case Slot_Short: {
                        this.heap.heap[i++] = fs._getShortValueNc(feat);
                        continue block25;
                    }
                    case Slot_Int: {
                        this.heap.heap[i++] = fs._getIntValueNc(feat);
                        continue block25;
                    }
                    case Slot_Float: {
                        this.heap.heap[i++] = CASImpl.float2int(fs._getFloatValueNc(feat));
                        continue block25;
                    }
                    case Slot_LongRef: {
                        int lAddr = this.longHeap.addLong(fs._getLongValueNc(feat));
                        this.heap.heap[i++] = this.nextLongHeapAddrAfterMark + lAddr;
                        continue block25;
                    }
                    case Slot_DoubleRef: {
                        int lAddr = this.longHeap.addLong(CASImpl.double2long(fs._getDoubleValueNc(feat)));
                        this.heap.heap[i++] = this.nextLongHeapAddrAfterMark + lAddr;
                        continue block25;
                    }
                    case Slot_StrRef: {
                        int sAddr = this.stringHeap.addString(fs._getStringValueNc(feat));
                        this.heap.heap[i++] = sAddr == 0 ? 0 : this.nextStringHeapAddrAfterMark + sAddr;
                        continue block25;
                    }
                    case Slot_HeapRef: {
                        this.heap.heap[i++] = fs2addr.get(fs._getFeatureValueNc(feat));
                        continue block25;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
            }
        }
    }

    private void createFSsFromHeaps(boolean isDelta, int startPos, CommonSerDesSequential csds) {
        TypeImpl type;
        TOP fs;
        int heapsz = this.heap.getCellsUsed();
        Int2ObjHashMap<TOP, TOP> addr2fs = csds.addr2fs;
        this.tsi = this.baseCas.getTypeSystemImpl();
        CASImpl initialView = this.baseCas.getInitialView();
        ArrayList<Runnable> fixups4forwardFsRefs = new ArrayList<Runnable>();
        ArrayList<Runnable> fixups4UimaSerialization = new ArrayList<Runnable>();
        block18: for (int heapIndex = startPos; heapIndex < heapsz; heapIndex += BinaryCasSerDes.getFsSpaceReq(fs, type)) {
            int typecode = this.heap.heap[heapIndex];
            type = this.tsi.getTypeForCode(this.heap.heap[heapIndex]);
            if (type == null) {
                throw new CASRuntimeException("deserialized_type_not_found", this.heap.heap[heapIndex]);
            }
            if (type.isArray()) {
                int len = this.heap.heap[heapIndex + 1];
                int bhi = this.heap.heap[heapIndex + 2];
                int hhi = heapIndex + 2;
                fs = this.baseCas.createArray(type, len);
                csds.addFS(fs, heapIndex);
                switch (type.getComponentSlotKind()) {
                    case Slot_BooleanRef: {
                        int ai;
                        boolean[] ba = ((BooleanArray)fs)._getTheArray();
                        for (ai = 0; ai < len; ++ai) {
                            ba[ai] = this.byteHeap.heap[bhi + ai] == 1;
                        }
                        continue block18;
                    }
                    case Slot_ByteRef: {
                        System.arraycopy(this.byteHeap.heap, bhi, ((ByteArray)fs)._getTheArray(), 0, len);
                        break;
                    }
                    case Slot_ShortRef: {
                        System.arraycopy(this.shortHeap.heap, bhi, ((ShortArray)fs)._getTheArray(), 0, len);
                        break;
                    }
                    case Slot_LongRef: {
                        System.arraycopy(this.longHeap.heap, bhi, ((LongArray)fs)._getTheArray(), 0, len);
                        break;
                    }
                    case Slot_DoubleRef: {
                        int ai;
                        double[] da = ((DoubleArray)fs)._getTheArray();
                        for (ai = 0; ai < len; ++ai) {
                            da[ai] = CASImpl.long2double(this.longHeap.heap[bhi + ai]);
                        }
                        continue block18;
                    }
                    case Slot_Int: {
                        System.arraycopy(this.heap.heap, hhi, ((IntegerArray)fs)._getTheArray(), 0, len);
                        break;
                    }
                    case Slot_Float: {
                        int ai;
                        float[] fa = ((FloatArray)fs)._getTheArray();
                        for (ai = 0; ai < len; ++ai) {
                            fa[ai] = CASImpl.int2float(this.heap.heap[hhi + ai]);
                        }
                        continue block18;
                    }
                    case Slot_StrRef: {
                        int ai;
                        String[] sa = ((StringArray)fs)._getTheArray();
                        for (ai = 0; ai < len; ++ai) {
                            sa[ai] = this.stringHeap.getStringForCode(this.heap.heap[hhi + ai]);
                        }
                        continue block18;
                    }
                    case Slot_HeapRef: {
                        int ai;
                        TOP[] fsa = ((FSArray)fs)._getTheArray();
                        for (ai = 0; ai < len; ++ai) {
                            int a = this.heap.heap[hhi + ai];
                            if (a == 0) continue;
                            TOP item2 = addr2fs.get(a);
                            if (item2 != null) {
                                fsa[ai] = item2;
                                continue;
                            }
                            int aiSaved = ai;
                            int addrSaved = a;
                            fixups4forwardFsRefs.add(() -> {
                                fsa[aiSaved] = (TOP)addr2fs.get(addrSaved);
                            });
                        }
                        continue block18;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
                continue;
            }
            CASImpl view = null;
            boolean isSofa = false;
            if (type.isAnnotationBaseType()) {
                Sofa sofa = this.getSofaFromAnnotBase(heapIndex, this.stringHeap, addr2fs, csds);
                CASImpl cASImpl = view = sofa == null ? this.baseCas.getInitialView() : this.baseCas.getView(sofa);
                if (type == this.tsi.docType) {
                    fs = (TOP)view.getDocumentAnnotation();
                    view.removeFromCorruptableIndexAnyView(fs, view.getAddbackSingle());
                } else {
                    fs = (TOP)view.createFS(type);
                    if (fs instanceof UimaSerializable) {
                        UimaSerializable ufs = (UimaSerializable)((Object)fs);
                        fixups4UimaSerialization.add(() -> ufs._init_from_cas_data());
                    }
                }
            } else if (type == this.tsi.sofaType) {
                fs = this.makeSofaFromHeap(heapIndex, this.stringHeap, csds, false);
                isSofa = true;
            } else {
                fs = (TOP)initialView.createFS(type);
                if (fs instanceof UimaSerializable) {
                    UimaSerializable ufs = (UimaSerializable)((Object)fs);
                    fixups4UimaSerialization.add(() -> ufs._init_from_cas_data());
                }
            }
            if (!isSofa) {
                csds.addFS(fs, heapIndex);
            }
            block24: for (FeatureImpl feat : type.getFeatureImpls()) {
                SlotKinds.SlotKind slotKind = feat.getSlotKind();
                switch (slotKind) {
                    case Slot_Int: 
                    case Slot_Float: 
                    case Slot_Boolean: 
                    case Slot_Byte: 
                    case Slot_Short: {
                        if (isSofa && feat == this.tsi.sofaNum) continue block24;
                        fs._setIntLikeValueNcNj(slotKind, feat, this.heapFeat(heapIndex, feat));
                        continue block24;
                    }
                    case Slot_LongRef: {
                        fs._setLongValueNcNj(feat, this.longHeap.heap[this.heapFeat(heapIndex, feat)]);
                        continue block24;
                    }
                    case Slot_DoubleRef: {
                        fs._setDoubleValueNcNj(feat, CASImpl.long2double(this.longHeap.heap[this.heapFeat(heapIndex, feat)]));
                        continue block24;
                    }
                    case Slot_StrRef: {
                        String s = this.stringHeap.getStringForCode(this.heapFeat(heapIndex, feat));
                        if (!this.updateStringFeature(fs, feat, s, fixups4forwardFsRefs)) continue block24;
                        fs._setStringValueNcNj(feat, s);
                        continue block24;
                    }
                    case Slot_HeapRef: {
                        TOP finalFs = fs;
                        if (feat == this.tsi.annotBaseSofaFeat) continue block24;
                        this.setFeatOrDefer(heapIndex, feat, fixups4forwardFsRefs, item -> {
                            if (feat == this.tsi.sofaArray) {
                                ((Sofa)finalFs).setLocalSofaData((FeatureStructure)item);
                            } else {
                                finalFs._setFeatureValueNcNj(feat, item);
                            }
                        }, addr2fs);
                        continue block24;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
            }
            if (type != this.tsi.docType) continue;
            view.addbackSingle(fs);
        }
        for (Runnable r : fixups4forwardFsRefs) {
            r.run();
        }
        for (Runnable r : fixups4UimaSerialization) {
            r.run();
        }
    }

    private void setFeatOrDefer(int heapIndex, FeatureImpl feat, List<Runnable> fixups4forwardFsRefs, Consumer<TOP> setter, Int2ObjHashMap<TOP, TOP> addr2fs) {
        int a = this.heapFeat(heapIndex, feat);
        if (a == 0) {
            return;
        }
        TOP item = addr2fs.get(a);
        if (item != null) {
            setter.accept(item);
        } else {
            fixups4forwardFsRefs.add(() -> setter.accept((TOP)addr2fs.get(a)));
        }
    }

    private int heapFeat(int nextFsAddr, FeatureImpl feat) {
        return this.heap.heap[nextFsAddr + 1 + feat.getOffset()];
    }

    private Sofa getSofaFromAnnotBase(int annotBaseAddr, StringHeap stringHeap2, Int2ObjHashMap<TOP, TOP> addr2fs, CommonSerDesSequential csds) {
        int sofaAddr = this.heapFeat(annotBaseAddr, this.tsi.annotBaseSofaFeat);
        if (0 == sofaAddr) {
            return null;
        }
        return this.makeSofaFromHeap(sofaAddr, stringHeap2, csds, true);
    }

    private Sofa makeSofaFromHeap(int sofaAddr, StringHeap stringHeap2, CommonSerDesSequential csds, boolean isUnordered) {
        TOP sofa = csds.addr2fs.get(sofaAddr);
        if (sofa != null) {
            return (Sofa)sofa;
        }
        int sofaNum = this.heapFeat(sofaAddr, this.tsi.sofaNum);
        String sofaName = stringHeap2.getStringForCode(this.heapFeat(sofaAddr, this.tsi.sofaId));
        sofa = this.baseCas.createSofa(sofaNum, sofaName, null);
        if (isUnordered) {
            csds.addFSunordered(sofa, sofaAddr);
        } else {
            csds.addFS(sofa, sofaAddr);
        }
        return (Sofa)sofa;
    }

    private void updateHeapSlot(BinDeserSupport bds, int slotAddr, int slotValue, Int2ObjHashMap<TOP, TOP> addr2fs) {
        TOP fs = bds.fs;
        TypeImpl type = fs._getTypeImpl();
        if (type.isArray()) {
            int hsai = slotAddr - bds.fsStartAddr - 2;
            switch (type.getComponentSlotKind()) {
                case Slot_Int: {
                    ((IntegerArray)fs).set(hsai, slotValue);
                    break;
                }
                case Slot_Float: {
                    ((FloatArray)fs).set(hsai, CASImpl.int2float(slotValue));
                    break;
                }
                case Slot_StrRef: {
                    ((StringArray)fs).set(hsai, this.stringHeap.getStringForCode(slotValue));
                    break;
                }
                case Slot_HeapRef: {
                    ((FSArray)fs).set(hsai, (FeatureStructure)addr2fs.get(slotValue));
                    break;
                }
                default: {
                    Misc.internalError();
                    break;
                }
            }
        } else {
            int offset0 = slotAddr - bds.fsStartAddr - 1;
            FeatureImpl feat = type.getFeatureImpls()[offset0];
            SlotKinds.SlotKind slotKind = feat.getSlotKind();
            switch (slotKind) {
                case Slot_Int: 
                case Slot_Float: 
                case Slot_Boolean: 
                case Slot_Byte: 
                case Slot_Short: {
                    fs._setIntLikeValue(slotKind, feat, slotValue);
                    break;
                }
                case Slot_LongRef: {
                    fs.setLongValue(feat, this.longHeap.getHeapValue(slotValue));
                    break;
                }
                case Slot_DoubleRef: {
                    fs.setDoubleValue(feat, CASImpl.long2double(this.longHeap.getHeapValue(slotValue)));
                    break;
                }
                case Slot_StrRef: {
                    String s = this.stringHeap.getStringForCode(slotValue);
                    if (!this.updateStringFeature(fs, feat, s, null)) break;
                    fs.setStringValue(feat, this.stringHeap.getStringForCode(slotValue));
                    break;
                }
                case Slot_HeapRef: {
                    fs.setFeatureValue(feat, addr2fs.get(slotValue));
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
        }
    }

    private boolean updateStringFeature(TOP fs, FeatureImpl feat, String s, List<Runnable> fixups4forwardFsRefs) {
        if (null == s) {
            return false;
        }
        if (fs instanceof Sofa) {
            if (feat == this.tsi.sofaId) {
                return false;
            }
            Sofa sofa = (Sofa)fs;
            if (feat == this.tsi.sofaMime) {
                sofa.setMimeType(s);
                return false;
            }
            if (feat == this.tsi.sofaUri) {
                sofa.setRemoteSofaURI(s);
                return false;
            }
            if (feat == this.tsi.sofaString) {
                if (fixups4forwardFsRefs != null) {
                    Sofa capturedSofa = sofa;
                    String capturedString = s;
                    fixups4forwardFsRefs.add(() -> capturedSofa.setLocalSofaDataNoDocAnnotUpdate(capturedString));
                } else {
                    sofa.setLocalSofaData(s);
                }
                return false;
            }
        }
        return true;
    }

    CASImpl getCas() {
        return this.baseCas;
    }

    private void clearDeltaOffsets() {
        this.nextHeapAddrAfterMark = 0;
        this.nextStringHeapAddrAfterMark = 0;
        this.nextByteHeapAddrAfterMark = 0;
        this.nextShortHeapAddrAfterMark = 0;
        this.nextLongHeapAddrAfterMark = 0;
    }

    private void clearAuxAddr2fsa() {
        this.byteAuxAddr2fsa.clear();
        this.shortAuxAddr2fsa.clear();
        this.longAuxAddr2fsa.clear();
    }

    public void clear() {
        this.clearDeltaOffsets();
        this.clearAuxAddr2fsa();
        this.heap = null;
        this.byteHeap = null;
        this.shortHeap = null;
        this.longHeap = null;
        this.stringHeap = null;
    }

    private class BinDeserSupport {
        private TOP fs;
        private int fsStartAddr;
        private int fsEndAddr;
        private int[] fssAddrArray;
        private int fssIndex;
        private int addrOfFsToBeAddedBack;
        private TOP fsToBeAddedBack;
        private FSsTobeAddedback tobeAddedback = FSsTobeAddedback.createSingle();

        private BinDeserSupport() {
        }

        private void maybeAddBack() {
            if (this.addrOfFsToBeAddedBack != this.fsStartAddr) {
                this.addBackIfRemoved();
            }
        }

        private void addBackIfRemoved() {
            if (this.fsToBeAddedBack != null) {
                this.tobeAddedback.addback(this.fsToBeAddedBack);
            }
        }

        private void maybeRemove(int heapAddr) {
            TypeImpl type = this.fs._getTypeImpl();
            if (!type.isArray()) {
                FeatureImpl feat = type.getFeatureImpls()[heapAddr - this.fsStartAddr - 1];
                boolean wasRemoved = BinaryCasSerDes.this.baseCas.checkForInvalidFeatureSetting(this.fs, feat.getCode(), this.tobeAddedback);
                this.addrOfFsToBeAddedBack = wasRemoved ? this.fsStartAddr : 0;
                this.fsToBeAddedBack = wasRemoved ? this.fs : null;
            }
        }

        private void maybeAddBackAndRemoveFs(int heapAddr, Int2ObjHashMap<TOP, TOP> addr2fs) {
            if (this.fsStartAddr == -1) {
                this.fssIndex = -1;
                this.addrOfFsToBeAddedBack = -1;
                this.fsToBeAddedBack = null;
                this.fs = null;
                this.tobeAddedback.clear();
            }
            this.findCorrespondingFs(heapAddr, addr2fs);
            this.maybeAddBack();
            this.maybeRemove(heapAddr);
        }

        private void findCorrespondingFs(int heapAddr, Int2ObjHashMap<TOP, TOP> addr2fs) {
            if (this.fsStartAddr < heapAddr && heapAddr < this.fsEndAddr) {
                return;
            }
            ++this.fssIndex;
            this.fsStartAddr = this.fssAddrArray[this.fssIndex];
            if (this.fssIndex + 1 < this.fssAddrArray.length) {
                this.fsEndAddr = this.fssAddrArray[this.fssIndex + 1];
                if (this.fsStartAddr < heapAddr && heapAddr < this.fsEndAddr) {
                    this.fs = addr2fs.get(this.fsStartAddr);
                    return;
                }
            }
            int result = heapAddr > this.fsEndAddr ? Arrays.binarySearch(this.fssAddrArray, this.fssIndex + 1, this.fssAddrArray.length, heapAddr) : Arrays.binarySearch(this.fssAddrArray, 0, this.fssIndex - 1, heapAddr);
            assert (result < 0);
            this.fssIndex = -result - 2;
            this.fsStartAddr = this.fssAddrArray[this.fssIndex];
            this.fsEndAddr = this.fssAddrArray[this.fssIndex + 1];
            this.fs = addr2fs.get(this.fsStartAddr);
            assert (this.fsStartAddr < heapAddr && heapAddr < this.fsEndAddr);
        }

        static /* synthetic */ int[] access$202(BinDeserSupport x0, int[] x1) {
            x0.fssAddrArray = x1;
            return x1;
        }
    }
}

