/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class StructuralTransformation
implements Serializable {
    protected final OWLDataFactory df;
    protected final Set<OWLEntity> signature = new HashSet<OWLEntity>();
    private int nameCounter = 0;

    public StructuralTransformation(OWLDataFactory dataFactory) {
        this.df = OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
    }

    protected OWLClass createNewName() {
        OWLClass cls = this.df.getOWLClass("http://www.semanticweb.org/ontology#", "X" + this.nameCounter);
        ++this.nameCounter;
        return cls;
    }

    public Set<OWLAxiom> getTransformedAxioms(Set<OWLAxiom> axioms) {
        OWLAPIPreconditions.checkNotNull(axioms, "axioms cannot be null");
        this.signature.clear();
        axioms.forEach(ax -> OWLAPIStreamUtils.add(this.signature, ax.signature()));
        AxiomRewriter rewriter = new AxiomRewriter();
        HashSet<OWLAxiom> transformedAxioms = new HashSet<OWLAxiom>();
        for (OWLAxiom ax2 : axioms) {
            for (OWLAxiom oWLAxiom : ax2.accept(rewriter)) {
                if (oWLAxiom instanceof OWLSubClassOfAxiom) {
                    AxiomFlattener flattener = new AxiomFlattener(this.df, ((OWLSubClassOfAxiom)oWLAxiom).getSuperClass());
                    Set<OWLAxiom> flattenedAxioms = flattener.getAxioms();
                    if (!flattenedAxioms.isEmpty()) {
                        transformedAxioms.addAll(flattenedAxioms);
                        continue;
                    }
                    transformedAxioms.add(oWLAxiom);
                    continue;
                }
                transformedAxioms.add(oWLAxiom);
            }
        }
        return transformedAxioms;
    }

    private class AxiomRewriter
    implements OWLAxiomVisitorEx<Collection<? extends OWLAxiom>> {
        AxiomRewriter() {
        }

        private Collection<OWLAxiom> subClassOf(OWLClassExpression sub, OWLClassExpression sup) {
            return this.doDefault(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectUnionOf(StructuralTransformation.this.df.getOWLObjectComplementOf(sub), sup).getNNF()));
        }

        private OWLAxiom subClassOfSingle(OWLClassExpression sub, OWLClassExpression sup) {
            return StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectUnionOf(StructuralTransformation.this.df.getOWLObjectComplementOf(sub), sup).getNNF());
        }

        @Override
        public Collection<OWLAxiom> doDefault(Object o) {
            return Collections.singleton((OWLAxiom)o);
        }

        @Override
        public Collection<OWLAxiom> visit(OWLClassAssertionAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf(axiom.getIndividual()), axiom.getClassExpression());
        }

        @Override
        public Collection<OWLAxiom> visit(OWLDataPropertyDomainAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getTopDatatype()), (OWLClassExpression)axiom.getDomain());
        }

        @Override
        public Collection<OWLAxiom> visit(OWLDataPropertyRangeAxiom axiom) {
            return this.doDefault(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)axiom.getRange())));
        }

        @Override
        public Collection<OWLAxiom> visit(OWLDifferentIndividualsAxiom axiom) {
            return axiom.walkPairwise((a, b) -> this.subClassOfSingle(StructuralTransformation.this.df.getOWLObjectOneOf((OWLIndividual)a), StructuralTransformation.this.df.getOWLObjectOneOf((OWLIndividual)b)));
        }

        @Override
        public Collection<? extends OWLAxiom> visit(OWLDisjointClassesAxiom axiom) {
            return axiom.asOWLSubClassOfAxioms();
        }

        @Override
        public Collection<OWLAxiom> visit(OWLDisjointUnionAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            axioms.addAll(StructuralTransformation.this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)axiom.getOWLClass(), (OWLClassExpression)StructuralTransformation.this.df.getOWLObjectUnionOf(axiom.classExpressions())).accept(this));
            axioms.addAll(StructuralTransformation.this.df.getOWLDisjointClassesAxiom(axiom.classExpressions()).accept(this));
            return axioms;
        }

        @Override
        public Collection<? extends OWLAxiom> visit(OWLEquivalentClassesAxiom axiom) {
            return axiom.asOWLSubClassOfAxioms();
        }

        @Override
        public Collection<OWLAxiom> visit(OWLEquivalentDataPropertiesAxiom axiom) {
            return axiom.walkPairwise(StructuralTransformation.this.df::getOWLEquivalentDataPropertiesAxiom);
        }

        @Override
        public Collection<OWLAxiom> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            return axiom.walkPairwise(StructuralTransformation.this.df::getOWLEquivalentObjectPropertiesAxiom);
        }

        @Override
        public Collection<OWLAxiom> visit(OWLDisjointDataPropertiesAxiom axiom) {
            return axiom.walkPairwise((xva$0, xva$1) -> StructuralTransformation.this.df.getOWLDisjointDataPropertiesAxiom((OWLDataPropertyExpression)xva$0, (OWLDataPropertyExpression)xva$1));
        }

        @Override
        public Collection<OWLAxiom> visit(OWLDisjointObjectPropertiesAxiom axiom) {
            return axiom.walkPairwise((xva$0, xva$1) -> StructuralTransformation.this.df.getOWLDisjointObjectPropertiesAxiom((OWLObjectPropertyExpression)xva$0, (OWLObjectPropertyExpression)xva$1));
        }

        @Override
        public Collection<OWLAxiom> visit(OWLFunctionalDataPropertyAxiom axiom) {
            return this.doDefault(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLDataMaxCardinality(1, (OWLDataPropertyExpression)axiom.getProperty())));
        }

        @Override
        public Collection<OWLAxiom> visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return this.doDefault(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)axiom.getProperty())));
        }

        @Override
        public Collection<OWLAxiom> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return this.doDefault(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectMaxCardinality(1, ((OWLObjectPropertyExpression)axiom.getProperty()).getInverseProperty())));
        }

        @Override
        public Collection<OWLAxiom> visit(OWLInverseObjectPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            axioms.add(StructuralTransformation.this.df.getOWLSubObjectPropertyOfAxiom(axiom.getFirstProperty(), axiom.getSecondProperty().getInverseProperty()));
            axioms.add(StructuralTransformation.this.df.getOWLSubObjectPropertyOfAxiom(axiom.getSecondProperty(), axiom.getFirstProperty().getInverseProperty()));
            return axioms;
        }

        @Override
        public Collection<OWLAxiom> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf(axiom.getSubject()), StructuralTransformation.this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getOWLDataComplementOf(StructuralTransformation.this.df.getOWLDataOneOf((OWLLiteral)axiom.getObject()))));
        }

        @Override
        public Collection<OWLAxiom> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf(axiom.getSubject()), StructuralTransformation.this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getOWLObjectComplementOf(StructuralTransformation.this.df.getOWLObjectOneOf((OWLIndividual)axiom.getObject()))));
        }

        @Override
        public Collection<OWLAxiom> visit(OWLObjectPropertyDomainAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getOWLThing()), (OWLClassExpression)axiom.getDomain());
        }

        @Override
        public Collection<OWLAxiom> visit(OWLObjectPropertyRangeAxiom axiom) {
            return this.doDefault(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)axiom.getRange())));
        }

        @Override
        public Collection<OWLAxiom> visit(OWLSameIndividualAxiom axiom) {
            return Collections.emptySet();
        }

        @Override
        public Collection<OWLAxiom> visit(OWLSubClassOfAxiom axiom) {
            return this.subClassOf(axiom.getSubClass(), axiom.getSuperClass());
        }
    }

    private class AxiomFlattener
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        private final OWLDataFactory ldf;
        private final Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        private final OWLClassExpression rhs;

        AxiomFlattener(OWLDataFactory df, OWLClassExpression rhs) {
            this.ldf = df;
            this.rhs = rhs;
        }

        @Override
        public OWLClassExpression doDefault(Object o) {
            return (OWLClassExpression)o;
        }

        private OWLSubClassOfAxiom getSCA(OWLClass lhs, OWLClassExpression ce) {
            return this.ldf.getOWLSubClassOfAxiom(lhs, ce);
        }

        public Set<OWLAxiom> getAxioms() {
            this.axioms.clear();
            OWLClass lhs = this.ldf.getOWLThing();
            this.axioms.add(this.getSCA(lhs, this.rhs.accept(this)));
            return this.axioms;
        }

        @Override
        public OWLClassExpression visit(OWLObjectAllValuesFrom ce) {
            if (StructuralTransformation.this.signature.containsAll(OWLAPIStreamUtils.asList(((OWLClassExpression)ce.getFiller()).signature()))) {
                OWLClass name = StructuralTransformation.this.createNewName();
                this.axioms.add(this.getSCA(name, ((OWLClassExpression)ce.getFiller()).accept(this)));
                return this.ldf.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)ce.getProperty(), name);
            }
            return ce;
        }

        @Override
        public OWLClassExpression visit(OWLObjectComplementOf ce) {
            if (ce.getOperand().isAnonymous()) {
                throw new IllegalStateException("Negation of arbitrary class expressions not allowed");
            }
            return ce;
        }

        @Override
        public OWLClassExpression visit(OWLObjectExactCardinality ce) {
            if (StructuralTransformation.this.signature.containsAll(OWLAPIStreamUtils.asList(((OWLClassExpression)ce.getFiller()).signature()))) {
                OWLClass name = StructuralTransformation.this.createNewName();
                this.axioms.add(this.getSCA(name, ((OWLClassExpression)ce.getFiller()).accept(this)));
                return this.ldf.getOWLObjectExactCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)ce.getProperty(), name);
            }
            return ce;
        }

        @Override
        public OWLClassExpression visit(OWLObjectIntersectionOf ce) {
            OWLClass name = StructuralTransformation.this.createNewName();
            ce.operands().forEach(op -> this.axioms.add(this.getSCA(name, op.accept(this))));
            return name;
        }

        @Override
        public OWLClassExpression visit(OWLObjectMaxCardinality ce) {
            if (StructuralTransformation.this.signature.containsAll(OWLAPIStreamUtils.asList(((OWLClassExpression)ce.getFiller()).signature()))) {
                OWLClass name = StructuralTransformation.this.createNewName();
                this.axioms.add(this.getSCA(name, ((OWLClassExpression)ce.getFiller()).accept(this)));
                return this.ldf.getOWLObjectMaxCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)ce.getProperty(), name);
            }
            return ce;
        }

        @Override
        public OWLClassExpression visit(OWLObjectMinCardinality ce) {
            if (StructuralTransformation.this.signature.containsAll(OWLAPIStreamUtils.asList(((OWLClassExpression)ce.getFiller()).signature()))) {
                OWLClass name = StructuralTransformation.this.createNewName();
                this.axioms.add(this.getSCA(name, ((OWLClassExpression)ce.getFiller()).accept(this)));
                return this.ldf.getOWLObjectMinCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)ce.getProperty(), name);
            }
            return ce;
        }

        @Override
        public OWLClassExpression visit(OWLObjectOneOf ce) {
            if (ce.individuals().count() > 1L) {
                throw new IllegalStateException("ObjectOneOf with more than one individual!");
            }
            return ce;
        }

        @Override
        public OWLClassExpression visit(OWLObjectSomeValuesFrom ce) {
            if (((OWLClassExpression)ce.getFiller()).isAnonymous()) {
                OWLClass name = StructuralTransformation.this.createNewName();
                this.axioms.add(this.getSCA(name, ((OWLClassExpression)ce.getFiller()).accept(this)));
                return this.ldf.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)ce.getProperty(), name);
            }
            return ce;
        }

        @Override
        public OWLClassExpression visit(OWLObjectUnionOf ce) {
            HashSet descs = new HashSet();
            ce.operands().forEach(op -> this.visitOperand(descs, (OWLClassExpression)op));
            return this.ldf.getOWLObjectUnionOf(descs);
        }

        protected void visitOperand(Set<OWLClassExpression> descs, OWLClassExpression op) {
            OWLClassExpression flatOp = op.accept(this);
            if (flatOp.isAnonymous() || StructuralTransformation.this.signature.contains(flatOp.asOWLClass())) {
                OWLClass name = StructuralTransformation.this.createNewName();
                descs.add(name);
                this.axioms.add(this.ldf.getOWLSubClassOfAxiom(name, flatOp));
            } else {
                descs.add(flatOp);
            }
        }
    }
}

