/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.fetcher;

import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.crawler.authentication.AuthInfo;
import edu.uci.ics.crawler4j.crawler.authentication.BasicAuthInfo;
import edu.uci.ics.crawler4j.crawler.authentication.FormAuthInfo;
import edu.uci.ics.crawler4j.crawler.authentication.NtAuthInfo;
import edu.uci.ics.crawler4j.crawler.exceptions.PageBiggerThanMaxSizeException;
import edu.uci.ics.crawler4j.fetcher.BasicAuthHttpRequestInterceptor;
import edu.uci.ics.crawler4j.fetcher.IdleConnectionMonitorThread;
import edu.uci.ics.crawler4j.fetcher.PageFetchResult;
import edu.uci.ics.crawler4j.fetcher.SniPoolingHttpClientConnectionManager;
import edu.uci.ics.crawler4j.fetcher.SniSSLConnectionSocketFactory;
import edu.uci.ics.crawler4j.url.URLCanonicalizer;
import edu.uci.ics.crawler4j.url.WebURL;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageFetcher {
    protected static final Logger logger = LoggerFactory.getLogger(PageFetcher.class);
    protected final Object mutex = new Object();
    protected final CrawlConfig config;
    protected PoolingHttpClientConnectionManager connectionManager;
    protected CloseableHttpClient httpClient;
    protected long lastFetchTime = 0L;
    protected IdleConnectionMonitorThread connectionMonitorThread = null;

    public PageFetcher(CrawlConfig config) {
        List<AuthInfo> authInfos;
        this.config = config;
        RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(false).setCookieSpec(config.getCookiePolicy()).setRedirectsEnabled(false).setSocketTimeout(config.getSocketTimeout()).setConnectTimeout(config.getConnectionTimeout()).build();
        RegistryBuilder connRegistryBuilder = RegistryBuilder.create();
        connRegistryBuilder.register("http", (Object)PlainConnectionSocketFactory.INSTANCE);
        if (config.isIncludeHttpsPages()) {
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) {
                        return true;
                    }
                }).build();
                SniSSLConnectionSocketFactory sslsf = new SniSSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                connRegistryBuilder.register("https", (Object)sslsf);
            }
            catch (Exception e) {
                logger.warn("Exception thrown while trying to register https");
                logger.debug("Stacktrace", (Throwable)e);
            }
        }
        Registry connRegistry = connRegistryBuilder.build();
        this.connectionManager = new SniPoolingHttpClientConnectionManager((Registry<ConnectionSocketFactory>)connRegistry, config.getDnsResolver());
        this.connectionManager.setMaxTotal(config.getMaxTotalConnections());
        this.connectionManager.setDefaultMaxPerRoute(config.getMaxConnectionsPerHost());
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (config.getCookieStore() != null) {
            clientBuilder.setDefaultCookieStore(config.getCookieStore());
        }
        clientBuilder.setDefaultRequestConfig(requestConfig);
        clientBuilder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        clientBuilder.setUserAgent(config.getUserAgentString());
        clientBuilder.setDefaultHeaders(config.getDefaultHeaders());
        HashMap<AuthScope, Credentials> credentialsMap = new HashMap<AuthScope, Credentials>();
        if (config.getProxyHost() != null) {
            if (config.getProxyUsername() != null) {
                AuthScope authScope = new AuthScope(config.getProxyHost(), config.getProxyPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(config.getProxyUsername(), config.getProxyPassword());
                credentialsMap.put(authScope, (Credentials)credentials);
            }
            HttpHost proxy = new HttpHost(config.getProxyHost(), config.getProxyPort());
            clientBuilder.setProxy(proxy);
            logger.debug("Working through Proxy: {}", (Object)proxy.getHostName());
        }
        if ((authInfos = config.getAuthInfos()) != null) {
            for (AuthInfo authInfo : authInfos) {
                if (AuthInfo.AuthenticationType.BASIC_AUTHENTICATION.equals((Object)authInfo.getAuthenticationType())) {
                    this.addBasicCredentials((BasicAuthInfo)authInfo, credentialsMap);
                    continue;
                }
                if (!AuthInfo.AuthenticationType.NT_AUTHENTICATION.equals((Object)authInfo.getAuthenticationType())) continue;
                this.addNtCredentials((NtAuthInfo)authInfo, credentialsMap);
            }
            if (!credentialsMap.isEmpty()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsMap.forEach((arg_0, arg_1) -> PageFetcher.lambda$new$0((CredentialsProvider)credentialsProvider, arg_0, arg_1));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                clientBuilder.addInterceptorFirst((HttpRequestInterceptor)new BasicAuthHttpRequestInterceptor());
            }
            this.httpClient = clientBuilder.build();
            authInfos.stream().filter(info -> AuthInfo.AuthenticationType.FORM_AUTHENTICATION.equals((Object)info.getAuthenticationType())).map(FormAuthInfo.class::cast).forEach(this::doFormLogin);
        } else {
            this.httpClient = clientBuilder.build();
        }
        if (this.connectionMonitorThread == null) {
            this.connectionMonitorThread = new IdleConnectionMonitorThread(this.connectionManager);
        }
        this.connectionMonitorThread.start();
    }

    private void addBasicCredentials(BasicAuthInfo authInfo, Map<AuthScope, Credentials> credentialsMap) {
        logger.info("BASIC authentication for: {}", (Object)authInfo.getLoginTarget());
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(authInfo.getUsername(), authInfo.getPassword());
        credentialsMap.put(new AuthScope(authInfo.getHost(), authInfo.getPort()), (Credentials)credentials);
    }

    private void addNtCredentials(NtAuthInfo authInfo, Map<AuthScope, Credentials> credentialsMap) {
        logger.info("NT authentication for: {}", (Object)authInfo.getLoginTarget());
        try {
            NTCredentials credentials = new NTCredentials(authInfo.getUsername(), authInfo.getPassword(), InetAddress.getLocalHost().getHostName(), authInfo.getDomain());
            credentialsMap.put(new AuthScope(authInfo.getHost(), authInfo.getPort()), (Credentials)credentials);
        }
        catch (UnknownHostException e) {
            logger.error("Error creating NT credentials", (Throwable)e);
        }
    }

    private void doFormLogin(FormAuthInfo authInfo) {
        logger.info("FORM authentication for: {}", (Object)authInfo.getLoginTarget());
        String fullUri = authInfo.getProtocol() + "://" + authInfo.getHost() + ":" + authInfo.getPort() + authInfo.getLoginTarget();
        HttpPost httpPost = new HttpPost(fullUri);
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        formParams.add(new BasicNameValuePair(authInfo.getUsernameFormStr(), authInfo.getUsername()));
        formParams.add(new BasicNameValuePair(authInfo.getPasswordFormStr(), authInfo.getPassword()));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        try {
            this.httpClient.execute((HttpUriRequest)httpPost);
            logger.debug("Successfully request to login in with user: {} to: {}", (Object)authInfo.getUsername(), (Object)authInfo.getHost());
        }
        catch (ClientProtocolException e) {
            logger.error("While trying to login to: {} - Client protocol not supported", (Object)authInfo.getHost(), (Object)e);
        }
        catch (IOException e) {
            logger.error("While trying to login to: {} - Error making request", (Object)authInfo.getHost(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageFetchResult fetchPage(WebURL webUrl) throws InterruptedException, IOException, PageBiggerThanMaxSizeException {
        PageFetchResult fetchResult = new PageFetchResult();
        String toFetchURL = webUrl.getURL();
        HttpUriRequest request = null;
        try {
            request = this.newHttpUriRequest(toFetchURL);
            if (this.config.getPolitenessDelay() > 0) {
                Object object = this.mutex;
                synchronized (object) {
                    long now = new Date().getTime();
                    if (now - this.lastFetchTime < (long)this.config.getPolitenessDelay()) {
                        Thread.sleep((long)this.config.getPolitenessDelay() - (now - this.lastFetchTime));
                    }
                    this.lastFetchTime = new Date().getTime();
                }
            }
            CloseableHttpResponse response = this.httpClient.execute(request);
            fetchResult.setEntity(response.getEntity());
            fetchResult.setResponseHeaders(response.getAllHeaders());
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 301 || statusCode == 302 || statusCode == 300 || statusCode == 303 || statusCode == 307 || statusCode == 308) {
                Header header = response.getFirstHeader("Location");
                if (header != null) {
                    String movedToUrl = URLCanonicalizer.getCanonicalURL(header.getValue(), toFetchURL);
                    fetchResult.setMovedToUrl(movedToUrl);
                }
            } else if (statusCode >= 200 && statusCode <= 299) {
                fetchResult.setFetchedUrl(toFetchURL);
                String uri = request.getURI().toString();
                if (!uri.equals(toFetchURL) && !URLCanonicalizer.getCanonicalURL(uri).equals(toFetchURL)) {
                    fetchResult.setFetchedUrl(uri);
                }
                if (fetchResult.getEntity() != null) {
                    long size = fetchResult.getEntity().getContentLength();
                    if (size == -1L) {
                        Header length = response.getLastHeader("Content-Length");
                        if (length == null) {
                            length = response.getLastHeader("Content-length");
                        }
                        if (length != null) {
                            size = Integer.parseInt(length.getValue());
                        }
                    }
                    if (size > (long)this.config.getMaxDownloadSize()) {
                        response.close();
                        throw new PageBiggerThanMaxSizeException(size);
                    }
                }
            }
            fetchResult.setStatusCode(statusCode);
            PageFetchResult pageFetchResult = fetchResult;
            return pageFetchResult;
        }
        finally {
            if (fetchResult.getEntity() == null && request != null) {
                request.abort();
            }
        }
    }

    public synchronized void shutDown() {
        if (this.connectionMonitorThread != null) {
            this.connectionManager.shutdown();
            this.connectionMonitorThread.shutdown();
        }
    }

    protected HttpUriRequest newHttpUriRequest(String url) {
        return new HttpGet(url);
    }

    protected CrawlConfig getConfig() {
        return this.config;
    }

    private static /* synthetic */ void lambda$new$0(CredentialsProvider credentialsProvider, AuthScope authscope, Credentials credentials) {
        credentialsProvider.setCredentials(authscope, credentials);
    }
}

