/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntStat
extends Stat<Integer> {
    private static final long serialVersionUID = 1L;
    private int counter;

    public IntStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
    }

    public IntStat(StatGroup group, StatDefinition definition, int counter) {
        super(group, definition);
        this.counter = counter;
    }

    @Override
    public Integer get() {
        return this.counter;
    }

    @Override
    public void set(Integer newValue) {
        this.counter = newValue;
    }

    public void increment() {
        ++this.counter;
    }

    public void add(int count) {
        this.counter += count;
    }

    @Override
    public void add(Stat<Integer> otherStat) {
        this.counter += otherStat.get().intValue();
    }

    @Override
    public Stat<Integer> computeInterval(Stat<Integer> base) {
        Stat<Integer> ret = this.copy();
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            ret.set(this.counter - base.get());
        }
        return ret;
    }

    @Override
    public void negate() {
        this.counter = -this.counter;
    }

    @Override
    public void clear() {
        this.counter = 0;
    }

    @Override
    protected String getFormattedValue() {
        return Stat.FORMAT.format(this.counter);
    }

    @Override
    public boolean isNotSet() {
        return this.counter == 0;
    }
}

