/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.plugin.officescraper;

import java.io.IOException;
import java.io.InputStream;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.plugin.officescraper.ExcelExtractorFactory;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.vocab.Excel;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class ExcelExtractor
implements Extractor.ContentExtractor {
    private static final Excel excel = Excel.getInstance();
    private boolean stopAtFirstError = false;

    public boolean isStopAtFirstError() {
        return this.stopAtFirstError;
    }

    public void setStopAtFirstError(boolean f) {
        this.stopAtFirstError = f;
    }

    public ExtractorDescription getDescription() {
        return ExcelExtractorFactory.getDescriptionInstance();
    }

    public void run(ExtractionParameters extractionParameters, ExtractionContext context, InputStream in, ExtractionResult er) throws IOException, ExtractionException {
        try {
            IRI documentIRI = context.getDocumentIRI();
            Workbook workbook = this.createWorkbook(documentIRI, in);
            this.processWorkbook(documentIRI, workbook, er);
        }
        catch (Exception e) {
            throw new ExtractionException("An error occurred while extracting MS Excel content.", (Throwable)e);
        }
    }

    private Workbook createWorkbook(IRI document, InputStream is) throws IOException {
        String documentIRI = document.toString();
        if (documentIRI.endsWith(".xlsx")) {
            return new XSSFWorkbook(is);
        }
        if (documentIRI.endsWith("xls")) {
            return new HSSFWorkbook(is);
        }
        throw new IllegalArgumentException("Unsupported extension for resource [" + documentIRI + "]");
    }

    private void processWorkbook(IRI documentIRI, Workbook wb, ExtractionResult er) {
        for (int sheetIndex = 0; sheetIndex < wb.getNumberOfSheets(); ++sheetIndex) {
            Sheet sheet = wb.getSheetAt(sheetIndex);
            IRI sheetIRI = this.getSheetIRI(documentIRI, sheet);
            er.writeTriple((Resource)documentIRI, ExcelExtractor.excel.containsSheet, (Value)sheetIRI);
            er.writeTriple((Resource)sheetIRI, RDF.TYPE, (Value)ExcelExtractor.excel.sheet);
            this.writeSheetMetadata(sheetIRI, sheet, er);
            for (Row row : sheet) {
                IRI rowIRI = this.getRowIRI(sheetIRI, row);
                er.writeTriple((Resource)sheetIRI, ExcelExtractor.excel.containsRow, (Value)rowIRI);
                er.writeTriple((Resource)rowIRI, RDF.TYPE, (Value)ExcelExtractor.excel.row);
                this.writeRowMetadata(rowIRI, row, er);
                for (Cell cell : row) {
                    this.writeCell(rowIRI, cell, er);
                }
            }
        }
    }

    private void writeSheetMetadata(IRI sheetIRI, Sheet sheet, ExtractionResult er) {
        String sheetName = sheet.getSheetName();
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        er.writeTriple((Resource)sheetIRI, ExcelExtractor.excel.sheetName, (Value)RDFUtils.literal((String)sheetName));
        er.writeTriple((Resource)sheetIRI, ExcelExtractor.excel.firstRow, (Value)RDFUtils.literal((int)firstRowNum));
        er.writeTriple((Resource)sheetIRI, ExcelExtractor.excel.lastRow, (Value)RDFUtils.literal((int)lastRowNum));
    }

    private void writeRowMetadata(IRI rowIRI, Row row, ExtractionResult er) {
        short firstCellNum = row.getFirstCellNum();
        short lastCellNum = row.getLastCellNum();
        er.writeTriple((Resource)rowIRI, ExcelExtractor.excel.firstCell, (Value)RDFUtils.literal((int)firstCellNum));
        er.writeTriple((Resource)rowIRI, ExcelExtractor.excel.lastCell, (Value)RDFUtils.literal((int)lastCellNum));
    }

    private void writeCell(IRI rowIRI, Cell cell, ExtractionResult er) {
        IRI cellType = this.cellTypeToType(cell.getCellType());
        if (cellType == null) {
            return;
        }
        IRI cellIRI = this.getCellIRI(rowIRI, cell);
        er.writeTriple((Resource)rowIRI, ExcelExtractor.excel.containsCell, (Value)cellIRI);
        er.writeTriple((Resource)cellIRI, RDF.TYPE, (Value)ExcelExtractor.excel.cell);
        er.writeTriple((Resource)cellIRI, ExcelExtractor.excel.cellValue, (Value)RDFUtils.literal((String)cell.getStringCellValue(), (IRI)cellType));
    }

    private IRI getSheetIRI(IRI documentIRI, Sheet sheet) {
        return RDFUtils.iri((String)(documentIRI.toString() + "/sheet/" + sheet.getSheetName()));
    }

    private IRI getRowIRI(IRI sheetIRI, Row row) {
        return RDFUtils.iri((String)(sheetIRI.toString() + "/" + row.getRowNum()));
    }

    private IRI getCellIRI(IRI rowIRI, Cell cell) {
        return RDFUtils.iri((String)(rowIRI + String.format("/%d/", cell.getColumnIndex())));
    }

    private IRI cellTypeToType(int cellType) {
        String postfix;
        switch (cellType) {
            case 1: {
                postfix = "string";
                break;
            }
            case 4: {
                postfix = "boolean";
                break;
            }
            case 0: {
                postfix = "numeric";
                break;
            }
            default: {
                postfix = null;
            }
        }
        return postfix == null ? null : RDFUtils.iri((String)(excel.getNamespace().toString() + postfix));
    }
}

