/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.citation.DefaultTelephone;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.CodeList;

final class LegacyTelephones
extends LegacyPropertyAdapter<String, Telephone> {
    private final CodeList<?> type;

    LegacyTelephones(Collection<Telephone> collection, CodeList<?> codeList) {
        super(collection);
        this.type = codeList;
    }

    @Override
    protected Telephone wrap(String string) {
        return new DefaultTelephone(string, this.type);
    }

    @Override
    protected String unwrap(Telephone telephone) {
        CodeList<?> codeList;
        if (telephone instanceof DefaultTelephone && (codeList = ((DefaultTelephone)telephone).numberType) != null && this.type.name().equals(codeList.name())) {
            return ((DefaultTelephone)telephone).getNumber();
        }
        return null;
    }

    @Override
    protected boolean update(Telephone telephone, String string) {
        CodeList<?> codeList;
        if (telephone instanceof DefaultTelephone && ((codeList = ((DefaultTelephone)telephone).numberType) == null || this.type.name().equals(codeList.name()))) {
            if (codeList == null) {
                ((DefaultTelephone)telephone).numberType = this.type;
            }
            ((DefaultTelephone)telephone).setNumber(string);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(String string) {
        Telephone telephone;
        if (string == null || string.isEmpty()) {
            return false;
        }
        Iterator iterator = this.elements.iterator();
        if (iterator.hasNext() && (telephone = (Telephone)iterator.next()) instanceof DefaultTelephone && ((DefaultTelephone)telephone).isEmpty() && this.update(telephone, string)) {
            return true;
        }
        return this.elements.add(this.wrap(string));
    }
}

