/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Identifier_Type", propOrder={"code", "authority"})
@XmlRootElement(name="MD_Identifier")
public class DefaultIdentifier
extends ISOMetadata
implements Identifier {
    private static final long serialVersionUID = -23375776954553866L;
    private String code;
    private String codeSpace;
    private String version;
    private InternationalString description;
    private Citation authority;

    public DefaultIdentifier() {
    }

    public DefaultIdentifier(String string) {
        this.code = string;
    }

    public DefaultIdentifier(Citation citation, String string) {
        this.authority = citation;
        this.code = string;
        this.codeSpace = Citations.getCodeSpace(citation);
    }

    public DefaultIdentifier(Identifier identifier) {
        super(identifier);
        if (identifier != null) {
            this.code = identifier.getCode();
            this.authority = identifier.getAuthority();
            if (identifier instanceof DefaultIdentifier) {
                DefaultIdentifier defaultIdentifier = (DefaultIdentifier)identifier;
                this.codeSpace = defaultIdentifier.getCodeSpace();
                this.version = defaultIdentifier.getVersion();
                this.description = defaultIdentifier.getDescription();
            } else if (identifier instanceof ReferenceIdentifier) {
                ReferenceIdentifier referenceIdentifier = (ReferenceIdentifier)identifier;
                this.codeSpace = referenceIdentifier.getCodeSpace();
                this.version = referenceIdentifier.getVersion();
            }
        }
    }

    public static DefaultIdentifier castOrCopy(Identifier identifier) {
        if (identifier == null || identifier instanceof DefaultIdentifier) {
            return (DefaultIdentifier)identifier;
        }
        return new DefaultIdentifier(identifier);
    }

    @Override
    @XmlElement(name="code", required=true)
    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        this.checkWritePermission();
        this.code = string;
    }

    @UML(identifier="codeSpace", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public String getCodeSpace() {
        return this.codeSpace;
    }

    public void setCodeSpace(String string) {
        this.checkWritePermission();
        this.codeSpace = string;
    }

    @UML(identifier="version", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.checkWritePermission();
        this.version = string;
    }

    @UML(identifier="description", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @Override
    @XmlElement(name="authority")
    public Citation getAuthority() {
        return this.authority;
    }

    public void setAuthority(Citation citation) {
        this.checkWritePermission();
        this.authority = citation;
    }
}

